/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ GUI ]
 */

#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "gui.h"
#include "subctrl.h"
#include "multipag.h"
#include "keyboard.h"
#include "fdc.h"
#include "tapelp.h"
#include "tools.h"
#include "opn.h"
#include "device.h"

/*
 *	萔`
 */
#define GUI_PLANES		5			/* zVRAMv[ */
#define GUI_WINDOWS		8			/* EChE */
#define GUI_BLINK_TIME	0x80		/* _Ŏ */

/*
 *	\̒`
 */
typedef struct {
	BOOL flag;
	BYTE plane;
	BYTE left;
	BYTE top;
	BYTE width;
	BYTE height;
} window_t;

/*
 *	j[\̒`
 */
typedef struct {
	char *str;
	BOOL (*func)(void);
	BOOL enable;
	BOOL check;
} menu_item_t;

/*
 *	O[o [N
 */
BOOL gui_flag;							/* GUI쒆tO */
BOOL bootfast_flag;						/* N[h */

/*
 *	X^eBbN [N
 */
static WORD gui_key_fm7;				/* L[(FM-7݊) */
static WORD gui_key_save;				/* L[(Z[u) */
static BYTE *gui_screen;				/* XN[obt@ */
static window_t gui_window[GUI_WINDOWS];/* EChEobt@ */
static BOOL gui_exit_flag;				/* GUIEovtO */
static BYTE gui_timer_cnt;				/* GUI^C}[JEg */
#ifdef _XWIN
static BYTE *gui_backup;				/* vram_c̃obNAbv */
#endif

static int maincur;						/* Cj[J[\ */
static int diskcur;						/* fBXNj[J[\ */
static int diskdrv;						/* fBXNhCu */
static int ctapecur;					/* e[vj[J[\ */
static int prncur;						/* v^j[J[\ */
static int configcur;					/* RtBOJ[\ */
static int bootmcur;					/* N[hJ[\ */
static int subfcur;						/* Tu[hJ[\ */
static int utycur;						/* [eBeBj[J[\ */
static WORD debugnum;					/* fobOpXio[ */
static BOOL debugflag;					/* fobOoktO */
static int kbdwnd;						/* L[\EChE */
static int tapecwnd;					/* e[vJE^EChE */
static int fdcwnd;						/* FDCANZXEChE */

static char disk_fname[FDC_DRIVES][128+1];
static char ctape_fname[128+1];
static char lp_fname[128+1];
static char d77_new_fname[128+1];
static char d77_new_title[16+1];
static char t77_new_fname[128+1];
static char vfd_conv_fname[128+1];
static char twod_conv_fname[128+1];
static char vtp_conv_fname[128+1];
static char state_fname[128+1];

/*
 *	f[^
 */
static BYTE gui_back_chr[8] = {
	0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa
};
char *disk2d_name = "2D DISK";
char *enter_fname = "ENTER FILE NAME:";

/*
 *	vg^Cv錾
 */
static void status_disp(void);		/* L[{[h\ */
static int disk_setup(void);		/* fBXNj[ */
static void ctape_setup(void);		/* e[vj[ */
static void sub_fast_setup(void);	/* Tuj[ */

/*
 *	GUI
 *	
 */
BOOL gui_init(void)
{
	int i;

	/* GUIȂ */
	gui_flag = FALSE;

	/* N[hL */
	bootfast_flag = TRUE;

	/* XN[obt@m */
	gui_screen = (BYTE *)malloc(40 * 25 * 2 * GUI_PLANES);
	if (gui_screen == NULL) {
		return FALSE;
	}

#ifdef _XWIN
	/* obNAbvobt@m */
	gui_backup = (BYTE *)malloc(0xc000);
	if (gui_backup == NULL) {
		return FALSE;
	}
#endif

	/* EChE[N */
	memset(gui_window, 0, sizeof(gui_window));

	/* J[\ */
	maincur = 0;
	diskcur = 0;
	ctapecur = 0;
	configcur = 0;
	bootmcur = 0;
	subfcur = 0;
	prncur = 0;
	utycur = 0;
	debugnum = 0;
	debugflag = FALSE;
	for (i=0; i<FDC_DRIVES; i++) {
		strcpy(disk_fname[i], "noname.d77");
	}
	strcpy(ctape_fname, "noname.t77");
	strcpy(lp_fname, "printer.log");
	strcpy(d77_new_fname, "newdisk.d77");
	strcpy(d77_new_title, "Default");
	strcpy(t77_new_fname, "newtape.t77");
	strcpy(vfd_conv_fname, "vfddisk.vfd");
	strcpy(twod_conv_fname, "2ddisk.2d");
	strcpy(vtp_conv_fname, "vtptape.vtp");
	strcpy(state_fname, "noname.xm7");

	return TRUE;
}

/*
 *	GUI
 *	N[Abv
 */
void gui_cleanup(void)
{
#ifdef _XWIN
	if (gui_backup) {
		free(gui_backup);
	}
#endif
	if (gui_screen) {
		free(gui_screen);
	}
}

/*
 *	GUI
 *	Zbg
 */
void gui_reset(void)
{
}

/*
 *	GUI
 *	̐؂ڂGUIɓ
 */
void gui_start(void)
{
	/* GUIj[ȂAȂ */
	if (gui_flag) {
		return;
	}

	/* GUIX^[g */
	gui_flag = TRUE;
}

/*
 *	GUI
 *	ʂ̑
 */
static void gui_enter(void)
{
	int i;
	WORD addr;

	/* L[ */
	gui_key_save = key_fm7;

#ifdef _XWIN
	/* VRAMobNAbv */
	memcpy(gui_backup, vram_c, 0xc000);
#endif

	/* pbgSOFF */
	for (i=0; i<8; i++) {
		ttlpalet_setb(i, 0);
	}

#ifndef _XWIN
	/* ʃNA */
	for (addr=0; addr<0xc000; addr++) {
		vram_setb(addr, 0);
	}
#endif

	/* pbgWݒ */
	for (i=0; i<8; i++) {
		ttlpalet_setb(i, (BYTE)i);
	}

	/* XN[obt@ */
	memset(gui_screen, 0, 40 * 25 * 2 * GUI_PLANES);

	/* PSG */
	opn_setb(8, 0);
	opn_setb(9, 0);
	opn_setb(10, 0);

	/* FM */
	for (i=0x40; i<0x50; i++) {
		if ((i & 3) != 3) {
			opn_setb((BYTE)i, 0x7f);
		}
	}

	/* L[{[h */
	gui_key_fm7 = 0;

	/* tO */
	gui_exit_flag = FALSE;
}

/*
 *	GUI
 *	ʂ̑N[Abv
 */
static void gui_leave(void)
{
	int i;
	WORD addr;

	/* pbgSOFF */
	for (i=0; i<8; i++) {
		ttlpalet_setb(i, 0);
	}

#ifdef _XWIN
	/* VRAM */
	memcpy(vram_c, gui_backup, 0xc000);
#endif

	if (!stopreq_flag) {
		/* VRAMZbg */
		for (addr=0; addr<0xc000; addr++) {
			vram_setb(addr, vram_c[addr]);
		}

		/* }`y[W𗘗păpbgݒ */
		multipag_writeb(0xfd37, multi_page);

		/* PSG */
		opn_setb(8, opn_reg[8]);
		opn_setb(9, opn_reg[9]);
		opn_setb(10, opn_reg[10]);

		/* FM */
		for (i=0x40; i<0x50; i++) {
			if ((i & 3) != 3) {
				opn_setb((BYTE)i, opn_reg[i]);
			}
		}

		/* L[ */
		key_fm7 = gui_key_save;
	}

	/* tO */
	gui_flag = FALSE;
}

/*-[ XN[ ]-----------------------------------------------------------*/


/*
 *	P\ Tu
 */
static void gui_putc_sub(BYTE *buf, BYTE code, int flag)
{
	int i;
	int j;
	BYTE dat;
	WORD set;
	BYTE *font;

	if (code == 0x7f) {
		font = gui_back_chr;
	}
	else {
		font = &subrom_c[code * 8];
	}

	/* 擾WJ[v */
	for (i=0; i<8; i++) {
		dat = *font++;
		set = 0;
		for (j=0; j<8; j++) {
			set <<= 2;
			if (dat & 0x80) {
				set |= 0x03;
			}
			dat <<= 1;
		}
		/* Zbg */
		if (flag) {
			*buf++ |= (BYTE)(set >> 8);
			*buf++ |= (BYTE)(set & 0xff);
		}
		else {
			set = ~set;
			*buf++ &= (BYTE)(set >> 8);
			*buf++ &= (BYTE)(set & 0xff);
		}
	}
}

/*
 *	P\ r
 */
static void gui_putc_keisen(BYTE *buf, BYTE attr)
{
	int p;
	int y;

	/*  */
	if (attr & 0x80) {
		for (p=0; p<3; p++) {
			buf[p * 16 + 0] = 0xff;
			buf[p * 16 + 1] = 0xff;
			buf[p * 16 + 2] = 0;
			buf[p * 16 + 3] = 0;
		}
	}

	/*  */
	if (attr & 0x40) {
		for (p=0; p<3; p++) {
			buf[p * 16 + 14] = 0xff;
			buf[p * 16 + 15] = 0xff;
			buf[p * 16 + 12] = 0;
			buf[p * 16 + 13] = 0;
		}
	}

	/*  */
	if (attr & 0x20) {
		for (p=0; p<3; p++) {
			for (y=0; y<8; y++) {
				buf[p*16 + y*2] |= 0xc0;
				if ((y == 0) && (attr & 0x80)) {
					continue;
				}
				if ((y == 7) && (attr & 0x40)) {
					continue;
				}
				buf[p*16 + y*2] &= 0xcf;
			}
		}
	}

	/* E */
	if (attr & 0x10) {
		for (p=0; p<3; p++) {
			for (y=0; y<8; y++) {
				buf[p*16 + y*2 + 1] |= 0x03;
				if ((y == 0) && (attr & 0x80)) {
					continue;
				}
				if ((y == 7) && (attr & 0x40)) {
					continue;
				}
				buf[p*16 + y*2 + 1] &= 0xf3;
			}
		}
	}
}

/*
 *	P\ NA
 */
static void gui_putc_clr(BYTE *buf, BYTE code)
{
	int offset;
	int i;
	int j;
	BYTE dat;
	WORD set;

	offset = (int)code;
	offset *= 8;

	/* PCɉ */
	buf += 2;

	/* 擾WJ[v */
	for (i=0; i<7; i++) {
		dat = subrom_c[offset++];
		set = 0;
		for (j=0; j<8; j++) {
			set <<= 2;
			if (dat & 0x80) {
				set |= 0x03;
			}
			dat <<= 1;
		}
		/* Zbg */
		set >>= 2;
		set = ~set;
		buf[0] &= (BYTE)(set >> 8);
		buf[1] &= (BYTE)(set & 0xff);
		buf[16] &= (BYTE)(set >> 8);
		buf[17] &= (BYTE)(set & 0xff);
		buf[32] &= (BYTE)(set >> 8);
		buf[33] &= (BYTE)(set & 0xff);
		buf += 2;
	}
}

/*
 *	P\ o[X
 */
static void gui_putc_rev(BYTE *buf)
{
	int i;

	for (i=0; i<48; i++) {
		*buf = ~*buf;
		buf++;
	}
}

/*
 *	P\
 */
static void gui_putc(int x, int y, BYTE attr, BYTE code)
{
	BYTE buf[16 * 3];
	WORD addr;
	int offset;

	/* assert */
	ASSERT((x >= 0) && (x < 40));
	ASSERT((y >= 0) && (y < 25));

	/* obt@NA */
	memset(buf, 0, sizeof(buf));

	/* AhXɎZo */
	addr = (WORD)y;
	addr *= 0x280;
	addr += (WORD)x;
	addr += (WORD)x;

	/* wi` */
	if ((code != 0x7f) && (!(attr & 0x08))) {
		offset = 0;
		for (y=0; y<8; y++) {
			if (y & 1) {
				buf[offset++] = 0x33;
				buf[offset++] = 0x33;
			}
			else {
				buf[offset++] = 0xcc;
				buf[offset++] = 0xcc;
			}
		}
	}

	if (attr & 0xf0) {
		/* r */
		gui_putc_keisen(buf, attr);
	}
	else {
		/* ŃNA */
		if (!(attr & 0x08)) {
			gui_putc_clr(buf, code);
		}

		/* Zbg */
		gui_putc_sub(&buf[0], code, attr & 01);
		gui_putc_sub(&buf[16], code, attr & 0x02);
		gui_putc_sub(&buf[32], code, attr & 0x04);

		/* o[X */
		if (attr & 0x08) {
			gui_putc_rev(buf);
		}
	}

	/* ` */
	offset = 0;
	for (x=0; x<3; x++) {
		for (y=0; y<8; y++) {
#ifdef _XWIN
			vram_c[addr] = buf[offset];
#endif
			vram_setb(addr++, buf[offset++]);
#ifdef _XWIN
			vram_c[addr] = buf[offset];
#endif
			vram_setb(addr, buf[offset++]);
			addr += 0x4f;
		}
		addr += (0x4000 - (0x50 * 8));
	}
}

/*
 *	ʍĕ`
 */
static void gui_refresh(void)
{
	BYTE *p[GUI_PLANES];
	BYTE attr;
	BYTE chr;
	int i;
	int x;
	int y;

	/* assert */
	ASSERT(gui_screen);

	/* |C^ݒ */
	for (i=0; i<GUI_PLANES; i++) {
		p[i] = &gui_screen[40 * 25 * 2 * i];
	}

	/* x, y[v */
	for (y=0; y<25; y++) {
		for (x=0; x<40; x++) {
			/* ŏ̃v[DxႢ */
			chr = 0;
			for (i=1; i<GUI_PLANES; i++) {
				if (*(p[i] + 1) != 0) {
					attr = *p[i];
					chr = *(p[i] + 1);
				}
			}
			/* ΁A027fݒ */
			if (chr == 0) {
				attr = 0x02;
				chr = 0x7f;
			}
			/* v[OƔrAĂΕ` */
			if ((*p[0] != attr) || (*(p[0] + 1) != chr)) {
				*p[0] = attr;
				*(p[0] + 1) = chr; 
				gui_putc(x, y, attr, chr);
			}
			/* Sv[ɐi߂ */
			for (i=0; i<GUI_PLANES; i++) {
				p[i] += 2;
			}
		}
	}
}

/*-[ EChE]------------------------------------------------------------*/

/*
 *	EChEgZbg(NA)
 */
static void window_box(int plane, int x, int y, int width, int height)
{
	BYTE *p;
	int i, j;

	ASSERT((x >= 0) && (x < 40));
	ASSERT((y >= 0) && (y < 25));
	ASSERT((width >= 3) && (x + width < 40));
	ASSERT((height >= 3) && (y + height < 25));
	ASSERT((plane >= 1) && (plane < GUI_PLANES));

	/* gZbg */
	p = &gui_screen[(40 * 25 * 2 * plane) + y * 80 + x * 2];

	/* iZbg */
	*p++ = 0xa0;
	*p++ = 0x20;
	for (i=1; i<width - 1; i++) {
		*p++ = 0x80;
		*p++ = 0x20;
	}
	*p++ = 0x90;
	*p++ = 0x20;
	p += (40 - width) * 2;

	/* iZbg */
	for (j=1; j<height - 1; j++) {
		*p++ = 0x20;
		*p++ = 0x20;
		for (i=1; i<width - 1; i++) {
			*p++ = 0x07;
			*p++ = 0x20;
		}
		*p++ = 0x10;
		*p++ = 0x20;
		p += (40 - width) * 2;
	}

	/* iZbg */
	*p++ = 0x60;
	*p++ = 0x20;
	for (i=1; i<width - 1; i++) {
		*p++ = 0x40;
		*p++ = 0x20;
	}
	*p++ = 0x50;
	*p++ = 0x20;
}

/*
 *	EChE`NA
 */
static void window_clr(int plane, int x, int y, int width, int height)
{
	BYTE *p;
	int i;

	ASSERT((x >= 0) && (x < 40));
	ASSERT((y >= 0) && (y < 25));
	ASSERT((width >= 3) && (x + width < 40));
	ASSERT((height >= 3) && (y + height < 25));
	ASSERT((plane >= 1) && (plane < GUI_PLANES));

	/* AhXݒ */
	p = &gui_screen[(40 * 25 * 2 * plane) + y * 80 + x * 2];

	/* NA */
	for (i=0; i<height; i++) {
		memset(p, 0, width * 2);
		p += 40 * 2;
	}
}

/*
 *	EChEI[v
 */
static int window_open(int plane, int x, int y, int w, int h)
{
	int i;

	/* assert */
	ASSERT((plane >= 1) && (plane < GUI_PLANES));
	ASSERT((x >= 0) && (x < 40));
	ASSERT((y >= 0) && (y < 25));
	ASSERT((w >= 3) && (x + w <= 40));
	ASSERT((h >= 3) && (y + h <= 25));

	/* 󂢂Ă郏[NT */
	for (i=0; i<GUI_WINDOWS; i++) {
		if (gui_window[i].flag == FALSE) {
			break;
		}
	}
	if (i == GUI_WINDOWS) {
		return -1;
	}

	/* [Nݒ */
	gui_window[i].flag = TRUE;
	gui_window[i].left = x;
	gui_window[i].top = y;
	gui_window[i].width = w;
	gui_window[i].height = h;
	gui_window[i].plane = plane;

	/* g` */
	window_box(plane, x, y, w, h);

	return i;
}

/*
 *	EChEN[Y
 */
static void window_close(int handle)
{
	/* assert */
	ASSERT((handle >= 0) && (handle < GUI_WINDOWS));
	ASSERT(gui_window[handle].flag);

	/* NA */
	window_clr( gui_window[handle].plane,
				gui_window[handle].left,
				gui_window[handle].top,
				gui_window[handle].width,
				gui_window[handle].height
	);
	
	/*  */
	gui_window[handle].flag = FALSE;
}

/*
 *	EChEo
 */
static void window_putc(int handle, char c, int x, int y, int attr)
{
	BYTE *p;

	/* assert */
	ASSERT((handle >= 0) && (handle < GUI_WINDOWS));
	ASSERT(gui_window[handle].flag == TRUE);

	/* ItZbg擾 */
	x++;
	y++;
	ASSERT((x >= 1) && (x < gui_window[handle].width - 1));
	ASSERT((y >= 1) && (y < gui_window[handle].height - 1));
	p = &gui_screen[gui_window[handle].plane * 40 * 25 * 2
					+ (gui_window[handle].top + y) * 40 * 2
					+ (gui_window[handle].left + x) * 2];

	/* Zbg */
	*p++ = (BYTE)attr;
	*p++ = c;
}

/*
 *	EChEo
 */
static void window_print(int handle, char *str, int x, int y, int attr)
{
	BYTE *p;

	/* assert */
	ASSERT(str);
	ASSERT((handle >= 0) && (handle < GUI_WINDOWS));
	ASSERT(gui_window[handle].flag == TRUE);

	/* ItZbg擾 */
	x++;
	y++;
	ASSERT((x >= 1) && (x < gui_window[handle].width - 1));
	ASSERT((y >= 1) && (y < gui_window[handle].height - 1));
	p = &gui_screen[gui_window[handle].plane * 40 * 25 * 2
					+ (gui_window[handle].top + y) * 40 * 2
					+ (gui_window[handle].left + x) * 2];

	/* Zbg[v */
	while (*str != '\0') {
		ASSERT(x < (gui_window[handle].width - 1));
		*p++ = (BYTE)attr;
		*p++ = *str++;
		x++;
	}
}

/*-[ L[{[h ]-----------------------------------------------------------*/

/*
 *	L[{[h荞
 */
void gui_key_irq(void)
{
	gui_key_fm7 = key_fm7;
}

/*
 *	L[{[h擾(EFCg)
 */
static WORD gui_inkey(void)
{
	WORD dat;

	dat = gui_key_fm7;
	gui_key_fm7 = 0;

	return dat;
}

/*
 *	L[{[h擾(EFCgL)
 */
static WORD gui_key(void)
{
	WORD dat;

	for (;;) {
		dat = gui_inkey();
		if (dat != 0) {
			break;
		}

		/* L[΁ACxg */
		do_events();

		/* IwoĂ΁AȂ΂ȂȂ */
		if (stopreq_flag == TRUE) {
			gui_exit_flag = TRUE;
		}
		if (gui_exit_flag) {
			return 0x1b;
		}

		/* L[{[hXe[^X */
		status_disp();
	}

	return dat;
}

/*
 *	L[{[h擾(K҂)
 */
static void gui_wait(void)
{
	WORD dat;

	for (;;) {
		dat = gui_inkey();
		if (dat == 0) {
			break;
		}

		/* L[ĂCxg */
		do_events();

		/* IwoĂ΁AȂ΂ȂȂ */
		if (stopreq_flag == TRUE) {
			gui_exit_flag = TRUE;
		}
		if (gui_exit_flag) {
			return;
		}

		/* L[{[hXe[^X */
		status_disp();
	}

	gui_key();
}

/*-[ j[ ]-------------------------------------------------------------*/

/*
 *	j[\
 */
static int menu_setup(int handle, int *cursor, menu_item_t *menudat)
{
	int i;
	int j;
	int attr;
	char buf[128];

	/* assert */
	ASSERT((handle >= 0) && (handle < GUI_WINDOWS));
	ASSERT(*cursor >= 0);
	ASSERT(menudat);
	ASSERT(gui_window[handle].flag == TRUE);

	/* j[NA */
	window_box( gui_window[handle].plane,
				gui_window[handle].left,
				gui_window[handle].top,
				gui_window[handle].width,
				gui_window[handle].height);

	/*  */
	i = 0;
	for (;;) {
		/* I`FbN */
		if (menudat[i].str == NULL) {
			break;
		}

		/* Agr[g쐬 */
		if (!menudat[i].enable) {
			attr = 0;
		}
		else {
			if (menudat[i].check) {
				attr = 0x04;
			}
			else {
				attr = 0x07;
			}
		}
		if (*cursor == i) {
			if ((gui_timer_cnt & (GUI_BLINK_TIME - 1)) < GUI_BLINK_TIME / 2) {
				attr |= 0x08;
			}
		}

		/* obt@ݒ */
		memset(buf, 0x20, gui_window[handle].width - 2);
		buf[gui_window[handle].width - 2] = '\0';
		for (j=0; j<(gui_window[handle].width - 2); j++) {
			if (menudat[i].str[j] == '\0') {
				break;
			}
			buf[j] = menudat[i].str[j];
		}

		/* \ */
		ASSERT(i < (gui_window[handle].height - 2));
		window_print(handle, buf, 0, i, attr);
		i++;
	}

	return i;
}

/*
 *	j[s
 */
static BOOL gui_menu(int handle, int *cursor, menu_item_t *menudat)
{
	int num;
	WORD key;

	/* asseert */
	ASSERT(cursor);
	ASSERT(menudat);

	/*  */
	gui_timer_cnt = 0;

	for (;;) {
		/* \ */
		num = menu_setup(handle, cursor, menudat);
		gui_refresh();

		/* L[҂ */
		key = gui_inkey();

		/* L[ꍇ */
		if (key == 0) {
			do_events();

			/* IwoĂ΁AȂ΂ȂȂ */
			if (stopreq_flag == TRUE) {
				gui_exit_flag = TRUE;
				return FALSE;
			}
			if (gui_exit_flag) {
				return FALSE;
			}

			status_disp();
			continue;
		}

		switch (key) {
			/*  */
			case 0x0d:
				/* R[obNĂяo */
				if (menudat[*cursor].func) {
					gui_timer_cnt = 0;
					menu_setup(handle, cursor, menudat);
					if (!menudat[*cursor].func()) {
						return TRUE;
					}
					if (gui_exit_flag) {
						return FALSE;
					}
				}
				break;

			/* LZ */
			case 0x1b:
				return TRUE;

			/*  */
			case 0x1e:
				for (;;) {
					(*cursor)--;
					if (*cursor < 0) {
						*cursor = num - 1;
					}
					if (menudat[*cursor].enable) {
						break;
					}
				}
				gui_timer_cnt = 0;
				break;

			/*  */
			case 0x1f:
				for (;;) {
					(*cursor)++;
					if (*cursor >= num) {
						*cursor = 0;
					}
					if (menudat[*cursor].enable) {
						break;
					}
				}
				gui_timer_cnt = 0;
				break;
		}
	}
}

/*
 *	 ZbgAbv
 */
static void input_setup(int handle, int y, int cursor, char *inp)
{
	int x;
	int w;

	char buf[41];

	/* EChE̕ */
	w = gui_window[handle].width - 2;
	memset(buf, 0x20, w);
	buf[w] = '\0';

	/* J[\zĂ邩 */
	if (cursor >= w) {
		for (x=0; x<w; x++) {
			if (inp[cursor - w + x + 1] != '\0') {
				buf[x] = inp[cursor - w + x + 1];
			}
		}
		window_print(handle, buf, 0, y, 0x07);
		/* _ŃJ[\ݒ */
		if ((gui_timer_cnt & (GUI_BLINK_TIME - 1)) < GUI_BLINK_TIME / 2) {
			if (inp[cursor] == 0) {
				window_putc(handle, 0x20, w - 1, y, 0x0f);
			}
			else {
				window_putc(handle, inp[cursor], w - 1, y, 0x0f);
			}
		}
	}
	else {
		for (x=0; x<w; x++) {
			if (inp[x] == '\0') {
				break;
			}
			else {
				buf[x] = inp[x];
			}
		}
		window_print(handle, buf, 0, y, 0x07);
		/* _ŃJ[\ݒ */
		if ((gui_timer_cnt & (GUI_BLINK_TIME - 1)) < GUI_BLINK_TIME / 2) {
			if (inp[cursor] == '\0') {
				window_putc(handle, 0x20, cursor, y, 0x0f);
			}
			else {
				window_putc(handle, inp[cursor], cursor, y, 0x0f);
			}
		}
	}
}

/*
 *	
 */
static BOOL gui_input(int handle, int y, char *buf, int maxchr)
{
	WORD key;
	int cursor;
	int i;

	/* assert */
	ASSERT((handle >= 0) && (handle < GUI_WINDOWS));
	ASSERT(gui_window[handle].flag == TRUE);
	ASSERT(y >= 0);
	ASSERT(y < (gui_window[handle].height - 2));
	ASSERT(buf);

	/*  */
	gui_timer_cnt = 0;
	cursor = 0;

	for (;;) {
		/* \ */
		input_setup(handle, y, cursor, buf);
		gui_refresh();

		/* L[҂ */
		key = gui_inkey();

		/* L[ꍇ */
		if (key == 0) {
			do_events();

			/* IwoĂ΁AȂ΂ȂȂ */
			if (stopreq_flag == TRUE) {
				gui_exit_flag = TRUE;
				return FALSE;
			}
			if (gui_exit_flag) {
				return FALSE;
			}

			status_disp();
			continue;
		}

		switch (key) {
			/*  */
			case 0x0d:
				return TRUE;

			/* LZ */
			case 0x1b:
				return FALSE;

			/*  */
			case 0x1d:
				if (cursor == 0) {
					break;
				}
				cursor--;
				gui_timer_cnt = 0;
				break;

			/* E */
			case 0x1c:
				if (cursor >= (maxchr - 1)) {
					break;
				}
				if (buf[cursor] == '\0') {
					break;
				}
				cursor++;
				gui_timer_cnt = 0;
				break;

			/* obNXy[X */
			case 0x08:
				if (cursor > 0) {
					cursor--;
				}
				/* ̂܂܃f[gɑ */

			/* f[g */
			case 0x7f:
				for (i=0; i<maxchr; i++) {
					buf[cursor + i] = buf[cursor + i + 1];
					if (buf[cursor + i] == '\0') {
						break;
					}
				}
				gui_timer_cnt = 0;
				break;

			/* CT[g */
			case 0x12:
				for (i=maxchr-2; i>=cursor; i--) {
					buf[i + 1] = buf[i];
				}
				buf[cursor] = 0x20;
				gui_timer_cnt = 0;
				break;

			default:
				/* ʏ̕ */
				if ((key < 0x20) || (key >= 0x0100)) {
					break;
				}
				if (buf[cursor] == '\0') {
					buf[cursor] = (BYTE)key;
					buf[cursor + 1] = '\0';
				}
				else {
					buf[cursor] = (BYTE)key;
				}
				if (cursor < (maxchr - 1)) {
					cursor++;
				}
				gui_timer_cnt = 0;
				break;
		}
	}
}

/*
 *	io[(4) ZbgAbv
 */
static void numinp_setup(int handle, int y, int cursor, WORD *num)
{
	char buf[5];
	int i;
	int attr;

	/* obt@𖄂߂ */
	buf[0] = (*num) / 1000;
	buf[1] = ((*num) % 1000) / 100;
	buf[2] = ((*num) % 100) / 10;
	buf[3] = (*num) % 10;
	buf[4] = '\0';

	/* \ */
	for (i=0; i<4; i++) {
		/* Agr[gw */
		attr = 0x07;
		if (cursor == i) {
			if ((gui_timer_cnt & (GUI_BLINK_TIME - 1)) < GUI_BLINK_TIME / 2) {
				attr = 0x0f;
			}
		}

		/* o */
		window_putc(handle, (BYTE)(buf[i] + 0x30), i, y, attr);
	}
}

/*
 *	io[(4)
 */
static BOOL gui_numinp(int handle, int y, WORD *num)
{
	WORD key;
	WORD num_add;
	WORD num_sub;
	int cursor;

	/* assert */
	ASSERT((handle >= 0) && (handle < GUI_WINDOWS));
	ASSERT(gui_window[handle].flag == TRUE);
	ASSERT(y >= 0);
	ASSERT(y < (gui_window[handle].height - 2));
	ASSERT(num);

	/*  */
	gui_timer_cnt = 0;
	cursor = 0;

	for (;;) {
		/* \ */
		numinp_setup(handle, y, cursor, num);
		gui_refresh();

		/* L[҂ */
		key = gui_inkey();

		/* L[ꍇ */
		if (key == 0) {
			do_events();

			/* IwoĂ΁AȂ΂ȂȂ */
			if (stopreq_flag == TRUE) {
				gui_exit_flag = TRUE;
				return FALSE;
			}
			if (gui_exit_flag) {
				return FALSE;
			}

			status_disp();
			continue;
		}

		switch (key) {
			/*  */
			case 0x0d:
				return TRUE;

			/* LZ */
			case 0x1b:
				return FALSE;

			/*  */
			case 0x1d:
				if (cursor == 0) {
					break;
				}
				cursor--;
				gui_timer_cnt = 0;
				break;

			/* E */
			case 0x1c:
				if (cursor >= 3) {
					break;
				}
				cursor++;
				gui_timer_cnt = 0;
				break;

			default:
				/* ʏ̕ */
				if ((key < 0x30) || (key > 0x39)) {
					break;
				}
				/* Y镔Zbg */
				key -= 0x30;
				switch (cursor) {
					case 3:
						num_sub = (*num) % 10;
						num_add = key;
						break;
					case 2:
						num_sub = (*num) % 100;
						num_sub = (num_sub / 10) * 10;
						num_add = key * 10;
						break;
					case 1:
						num_sub = (*num) % 1000;
						num_sub = (num_sub / 100) * 100;
						num_add = key * 100;
						break;
					case 0:
						num_sub = (*num) % 10000;
						num_sub = (num_sub / 1000) * 1000;
						num_add = key * 1000;
						break;
					default:
						ASSERT(FALSE);
						break;
				}
				*num -= num_sub;
				*num += num_add;
				if (cursor < 3) {
					cursor++;
				}
				gui_timer_cnt = 0;
				break;
		}
	}
}

/*
 *	10ms^C}[
 */
void gui_timer(void)
{
	gui_timer_cnt++;
}

/*-[ L[{[hLED ]--------------------------------------------------------*/

/*
 *	Xe[^XEChE I[v
 */
static void status_open(void)
{
	kbdwnd = window_open(1, 1, 21, 12, 3);
	tapecwnd = window_open(1, 14, 21, 11, 3);
	fdcwnd = window_open(1, 26, 21, 13, 3);
}

/*
 *	Xe[^XEChE \
 */
static void status_disp(void)
{
	char kana[3];
	char buf[6];
	int count;
	int color;

	/* L[{[h */
	kana[0] = (BYTE)0xb6;
	kana[1] = (BYTE)0xc5;
	kana[2] = '\0';
	if (caps_flag) {
		window_print(kbdwnd, "CAP", 0, 0, 0x02);
	}
	else {
		window_print(kbdwnd, "CAP", 0, 0, 0x07);
	}

	if (kana_flag) {
		window_print(kbdwnd, kana, 4, 0, 0x02);
	}
	else {
		window_print(kbdwnd, kana, 4, 0, 0x07);
	}

	if (ins_flag) {
		window_print(kbdwnd, "INS", 7, 0, 0x02);
	}
	else {
		window_print(kbdwnd, "INS", 7, 0, 0x07);
	}

	/* e[v */
	window_print(tapecwnd, "TAPE ", 0, 0, 0x07);
	count = (int)(tape_offset >> 8) % 10000;
	buf[0] = ((count / 1000) % 10) + 0x30;
	buf[1] = ((count / 100) % 10) + 0x30;
	buf[2] = ((count / 10) % 10) + 0x30;
	buf[3] = (count % 10) + 0x30;
	buf[4] = '\0';
	window_print(tapecwnd, buf, 5, 0, 0x07);

	/* fBXN */
	for (count=0; count<2; count++) {
		strcpy(buf, "READY");
		color = 7;
		if (fdc_ready[count] == FDC_TYPE_NOTREADY) {
			color = 0;
		}
		else {
			switch (fdc_access[count]) {
				case FDC_ACCESS_READY:
					break;
				case FDC_ACCESS_SEEK:
					strcpy(buf, "SEEK ");
					color = 6;
					break;
				case FDC_ACCESS_READ:
					strcpy(buf, "READ ");
					color = 4;
					break;
				case FDC_ACCESS_WRITE:
					strcpy(buf, "WRITE");
					color = 2;
					break;
			}
		}
		window_print(fdcwnd, buf, (count ^ 1) * 6, 0, color);
	}

	/* \ */
	gui_refresh();
}

/*
 *	Xe[^XEChE N[Y
 */
static void status_close(void)
{
	window_close(fdcwnd);
	window_close(tapecwnd);
	window_close(kbdwnd);
}

/*-[ fBXN ]-------------------------------------------------------------*/

/*
 *	t@CȂ
 */
static void file_not_found(void)
{
	int error_wnd;

	error_wnd = window_open(2, 10, 10, 16, 3);
	window_print(error_wnd, "FILE NOT FOUND", 0, 0, 0x07);
	gui_refresh();
	gui_wait();
	window_close(error_wnd);
}

/*
 *	t@CG[
 */
static void file_error(void)
{
	int error_wnd;

	error_wnd = window_open(2, 14, 10, 12, 3);
	window_print(error_wnd, "FILE ERROR", 0, 0, 0x07);
	gui_refresh();
	gui_wait();
	window_close(error_wnd);
}

/*
 *	fBXNt@C(VO)
 */
static BOOL disk_single(void)
{
	int fname_wnd;

	/* EChEI[v */
	fname_wnd = window_open(3, 8, 8, 23, 5);
	window_print(fname_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(fname_wnd, 2, disk_fname[diskdrv], 128)) {
		window_close(fname_wnd);
		return TRUE;
	}
	window_close(fname_wnd);

	/* t@CJ邩`FbN */
	if (fdc_setdisk(diskdrv, disk_fname[diskdrv]) == 0) {
		file_not_found();
		diskcur = disk_setup();
		return TRUE;
	}
	diskcur = disk_setup();
	return TRUE;
}

/*
 *	fBXNt@C()
 */
static BOOL disk_both(void)
{
	int fname_wnd;

	/* EChEI[v */
	fname_wnd = window_open(3, 8, 8, 23, 5);
	window_print(fname_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(fname_wnd, 2, disk_fname[diskdrv], 128)) {
		window_close(fname_wnd);
		return TRUE;
	}
	window_close(fname_wnd);

	/* t@Cw */
	if (fdc_setdisk(0, disk_fname[diskdrv]) == 0) {
		file_not_found();
		diskcur = disk_setup();
		return TRUE;
	}
	if (fdc_ready[0] != FDC_TYPE_NOTREADY) {
		if (fdc_medias[0] > 1) {
			fdc_setdisk(1, disk_fname[diskdrv]);
			fdc_setmedia(1, 1);
		}
	}
	diskcur = disk_setup();
	return TRUE;
}

/*
 *	fBXNO
 */
static BOOL disk_no(void)
{
	fdc_setdisk(diskdrv, NULL);
	diskcur = disk_setup();

	return FALSE;
}

/*
 *	fBXNCgveNg
 */
static BOOL disk_wr(void)
{
	if (fdc_writep[diskdrv]) {
		fdc_setwritep(diskdrv, FALSE);
	}
	else {
		fdc_setwritep(diskdrv, TRUE);
	}

	disk_setup();
	return TRUE;
}

/*
 *	fBXNZbg
 */
static BOOL disk_set(void)
{
	if (fdc_setmedia(diskdrv, diskcur - 5)) {
		gui_exit_flag = TRUE;
		return TRUE;
	}

	diskcur = disk_setup();
	return TRUE;
}

/*
 *	fBXNj[e[u
 */
static menu_item_t diskmenu_dat[] = {
	{ "OPEN (SINGLE)", disk_single, TRUE, FALSE },
	{ "OPEN (BOTH)", disk_both, TRUE, FALSE },
	{ "SET NO DISK", disk_no, TRUE, FALSE },
	{ "WRITE PROTECT", disk_wr, TRUE, FALSE },
	{ " ", NULL, FALSE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, disk_set, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	fBXNj[ ZbgAbv
 */
static int disk_setup()
{
	int i;

	/* assert */
	ASSERT((diskdrv >= 0) && (diskdrv < FDC_DRIVES));

	/* mbgfB̏ꍇ */
	if (fdc_ready[diskdrv] == FDC_TYPE_NOTREADY) {
		diskmenu_dat[2].enable = FALSE;
		diskmenu_dat[3].enable = FALSE;
		diskmenu_dat[5].str = NULL;
		return 0;
	}

	/* m[fBXNݒ */
	diskmenu_dat[2].enable = TRUE;

	/* CgveNg */
	if (fdc_fwritep[diskdrv]) {
		diskmenu_dat[3].enable = FALSE;
	}
	else {
		diskmenu_dat[3].enable = TRUE;
		if (fdc_writep[diskdrv]) {
			diskmenu_dat[3].check = TRUE;
		}
		else {
			diskmenu_dat[3].check = FALSE;
		}
	}

	/* ݒ */
	for (i=0; i<8; i++) {
		diskmenu_dat[i + 5].str = NULL;
	}

	/* lZbg */
	for (i=0; i<8; i++) {
		if (i < fdc_medias[diskdrv]) {
			/* fBXN */
			if (fdc_ready[diskdrv] == FDC_TYPE_2D) {
				diskmenu_dat[i + 5].str = disk2d_name;
			}
			else {
				diskmenu_dat[i + 5].str = fdc_name[diskdrv][i];
			}

			/* CgveNg */
			if (fdc_media[diskdrv] == i) {
				diskmenu_dat[i + 5].check = TRUE;
			}
			else {
				diskmenu_dat[i + 5].check = FALSE;
			}
		}
	}

	/* J[\ʒu߂ */
	return fdc_media[diskdrv] + 5;
}

/*
 *	fBXNj[
 */
static BOOL disk_menu(void)
{
	int disk_wnd;
	BOOL ret;

	/* assert */
	ASSERT((diskdrv >= 0) && (diskdrv < FDC_DRIVES));

	/* EChEI[v */
	disk_wnd = window_open(2, 5, 5, 18, 15);

	/* j[s */
	diskcur = disk_setup();
	ret = gui_menu(disk_wnd, &diskcur, diskmenu_dat);
	window_close(disk_wnd);

	return ret;
}

/*-[ e[v ]---------------------------------------------------------------*/

/*
 *	e[vI[v
 */
static BOOL ctape_open(void)
{
	int fname_wnd;

	/* EChEI[v */
	fname_wnd = window_open(3, 8, 8, 23, 5);
	window_print(fname_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(fname_wnd, 2, ctape_fname, 128)) {
		window_close(fname_wnd);
		return TRUE;
	}
	window_close(fname_wnd);

	/* t@CJ邩`FbN */
	tape_setfile(ctape_fname);
	if (tape_fileh == -1) {
		file_not_found();
	}
	ctape_setup();

	return TRUE;
}

/*
 *	e[v߂
 */
static BOOL ctape_rew(void)
{
	tape_rew();
	return TRUE;
}

/*
 *	e[v
 */
static BOOL ctape_ff(void)
{
	tape_ff();
	return TRUE;
}

/*
 *	e[v^
 */
static BOOL ctape_rec(void)
{
	tape_setrec(!tape_rec);
	ctape_setup();
	return TRUE;
}

/*
 *	e[vj[e[u
 */
static menu_item_t ctapemenu_dat[] = {
	{ "OPEN", ctape_open, TRUE, FALSE },
	{ "REW", ctape_rew, TRUE, FALSE },
	{ "FF", ctape_ff, TRUE, FALSE },
	{ "REC", ctape_rec, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	e[vj[@ZbgAbv
 */
void ctape_setup(void)
{
	if (tape_fileh == -1) {
		ctapemenu_dat[1].enable = FALSE;
		ctapemenu_dat[2].enable = FALSE;
		ctapemenu_dat[3].enable = FALSE;
		ctapecur = 0;
		return;
	}

	ctapemenu_dat[1].enable = TRUE;
	ctapemenu_dat[2].enable = TRUE;
	ctapemenu_dat[3].enable = TRUE;
	if (tape_writep) {
		ctapemenu_dat[3].enable = FALSE;
	}
	if (tape_rec) {
		ctapemenu_dat[3].check = TRUE;
	}
	else {
		ctapemenu_dat[3].check = FALSE;
	}
}

/*
 *	e[vj[
 */
static BOOL ctape(void)
{
	int ctape_wnd;
	BOOL ret;

	/* EChEI[v */
	ctape_wnd = window_open(2, 11, 7, 6, 6);

	/* j[s */
	ctape_setup();
	ret = gui_menu(ctape_wnd, &ctapecur, ctapemenu_dat);
	window_close(ctape_wnd);

	return ret;
}

/*-[ v^ ]-------------------------------------------------------------*/

/*
 *	v^I[v
 */
static BOOL prn_open(void)
{
	int fname_wnd;

	/* EChEI[v */
	fname_wnd = window_open(3, 8, 10, 23, 5);
	window_print(fname_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(fname_wnd, 2, lp_fname, 128)) {
		window_close(fname_wnd);
		return TRUE;
	}
	window_close(fname_wnd);

	/* t@Cݒ */
	lp_setfile(lp_fname);

	return FALSE;
}

/*
 *	v^N[Y
 */
static BOOL prn_close(void)
{
	lp_setfile(NULL);

	return FALSE;
}

/*
 *	v^j[e[u
 */
static menu_item_t prnmenu_dat[] = {
	{ "OPEN  LOG FILE", prn_open, TRUE, FALSE },
	{ "CLOSE LOG FILE", prn_close, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	v^j[
 */
static BOOL printer(void)
{
	int prn_wnd;
	BOOL ret;

	/* EChEI[vAj[AN[Y */
	prn_wnd = window_open(2, 7, 8, 16, 4);
	ret = gui_menu(prn_wnd, &prncur, prnmenu_dat);
	window_close(prn_wnd);

	return ret;
}


/*-[ RtBO ]-----------------------------------------------------------*/

/*
 *	N[hBASIC
 */
static BOOL boot_mode_bas(void)
{
	boot_mode = BOOT_BASIC;
	system_reset();

	gui_exit_flag = TRUE;
	return TRUE;
}

/*
 *	N[hDOS
 */
static BOOL boot_mode_dos(void)
{
	boot_mode = BOOT_DOS;
	system_reset();

	gui_exit_flag = TRUE;
	return TRUE;
}

/*
 *	N[hj[e[u
 */
static menu_item_t bootmenu_dat[] = {
	{ "BASIC MODE", boot_mode_bas, TRUE, FALSE },
	{ "DOS   MODE", boot_mode_dos, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	N[h
 */
static BOOL boot_mode_cfg(void)
{
	int bootm_wnd;
	BOOL ret;

	/* j[ݒ */
	if (boot_mode == BOOT_BASIC) {
		bootmenu_dat[0].check = TRUE;
		bootmenu_dat[1].check = FALSE;
	}
	else {
		bootmenu_dat[0].check = FALSE;
		bootmenu_dat[1].check = TRUE;
	}

	/* EChEI[vAj[AN[Y */
	bootm_wnd = window_open(3, 12, 11, 12, 4);
	ret = gui_menu(bootm_wnd, &bootmcur, bootmenu_dat);
	window_close(bootm_wnd);

	return ret;
}

/*
 *	Tu[hNORMAL
 */
static BOOL sub_fast_normal(void)
{
	subfast_flag = 0;
	sub_fast_setup();

	return TRUE;
}

/*
 *	Tu[hFAST
 */
static BOOL sub_fast_fast(void)
{
	subfast_flag = 1;
	sub_fast_setup();

	return TRUE;
}

/*
 *	Tu[hj[e[u
 */
static menu_item_t subfast_dat[] = {
	{ "NORMAL", sub_fast_normal, TRUE, FALSE },
	{ "BOOST ", sub_fast_fast, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	Tu[h ZbgAbv
 */
void sub_fast_setup(void)
{
	if (subfast_flag == 0) {
		subfast_dat[0].check = TRUE;
		subfast_dat[1].check = FALSE;
	}
	else {
		subfast_dat[0].check = FALSE;
		subfast_dat[1].check = TRUE;
	}
}

/*
 *	Tu[h
 */
static BOOL sub_fast_cfg(void)
{
	int subfast_wnd;
	BOOL ret;

	/* ZbgAbv */
	sub_fast_setup();

	/* EChEI[vAj[AN[Y */
	subfast_wnd = window_open(3, 11, 11, 8, 4);
	ret = gui_menu(subfast_wnd, &subfcur, subfast_dat);
	window_close(subfast_wnd);

	return ret;
}

/*
 *	N[hʏ
 */
static BOOL boot_fast_normal(void)
{
	bootfast_flag = FALSE;
	system_reset();

	gui_exit_flag = TRUE;
	return TRUE;
}

/*
 *	N[h
 */
static BOOL boot_fast_fast(void)
{
	bootfast_flag = TRUE;
	system_reset();

	gui_exit_flag = TRUE;
	return TRUE;
}

/*
 *	N[hj[e[u
 */
static menu_item_t bootfast_dat[] = {
	{ "NORMAL", boot_fast_normal, TRUE, FALSE },
	{ "FAST  ", boot_fast_fast, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	N[h
 */
static BOOL boot_fast_cfg(void)
{
	int bootfast_wnd;
	int cursor;
	BOOL ret;

	/* ZbgAbv */
	if (bootfast_flag) {
		cursor = 1;
		bootfast_dat[0].check = FALSE;
		bootfast_dat[1].check = TRUE;
	}
	else {
		cursor = 0;
		bootfast_dat[0].check = TRUE;
		bootfast_dat[1].check = FALSE;
	}

	/* EChEI[vAj[AN[Y */
	bootfast_wnd = window_open(3, 11, 7, 8, 4);
	ret = gui_menu(bootfast_wnd, &cursor, bootfast_dat);
	window_close(bootfast_wnd);

	return ret;
}

/*
 *	RtBOj[e[u
 */
static menu_item_t cfgmenu_dat[] = {
	{ "BOOT MODE", boot_mode_cfg, TRUE, FALSE },
	{ "SUB BOOST", sub_fast_cfg,  TRUE, FALSE },
	{ "FAST BOOT", boot_fast_cfg, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	RtBOj[
 */
static BOOL config(void)
{
	int cfg_wnd;
	BOOL ret;

	/* EChEI[vAj[AN[Y */
	cfg_wnd = window_open(2, 9, 8, 11, 5);
	ret = gui_menu(cfg_wnd, &configcur, cfgmenu_dat);
	window_close(cfg_wnd);

	return ret;
}

/*-[ [eBeB ]-------------------------------------------------------*/

/*
 *	VKfBXN쐬
 */
static BOOL make_new_disk(void)
{
	int fname_wnd;
	int title_wnd;

	/* EChEI[v */
	fname_wnd = window_open(3, 8, 7, 23, 5);
	window_print(fname_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(fname_wnd, 2, d77_new_fname, 128)) {
		window_close(fname_wnd);
		return TRUE;
	}

	/* ^CgEChEI[v */
	title_wnd = window_open(4, 10, 11, 18, 5);
	window_print(title_wnd, "ENTER TITLE:", 0, 0, 0x06);

	/* ^Cg */
	if (!gui_input(title_wnd, 2, d77_new_title, 16)) {
		window_close(title_wnd);
		window_close(fname_wnd);
		return TRUE;
	}

	window_close(title_wnd);
	window_close(fname_wnd);

	/* VKfBXN쐬 */
	if (!make_new_d77(d77_new_fname, d77_new_title)) {
		file_error();
	}

	return TRUE;
}

/*
 *	VKe[v쐬
 */
static BOOL make_new_tape(void)
{
	int fname_wnd;

	/* EChEI[v */
	fname_wnd = window_open(3, 8, 7, 23, 5);
	window_print(fname_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(fname_wnd, 2, t77_new_fname, 128)) {
		window_close(fname_wnd);
		return TRUE;
	}
	window_close(fname_wnd);

	/* VKe[v쐬 */
	if (!make_new_t77(t77_new_fname)) {
		file_error();
	}

	return TRUE;
}

/*
 *	VFD to D77Ro[g
 */
static BOOL vfd_to_d77(void)
{
	int src_wnd;
	int dst_wnd;
	int title_wnd;

	/* \[XEChEI[v */
	src_wnd = window_open(3, 8, 7, 23, 5);
	window_print(src_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(src_wnd, 2, vfd_conv_fname, 128)) {
		window_close(src_wnd);
		return TRUE;
	}

	/* fBXgl[VEChEI[v */
	dst_wnd = window_open(3, 9, 8, 23, 5);
	window_print(dst_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(dst_wnd, 2, d77_new_fname, 128)) {
		window_close(dst_wnd);
		window_close(src_wnd);
		return TRUE;
	}

	/* ^CgEChEI[v */
	title_wnd = window_open(4, 10, 11, 18, 5);
	window_print(title_wnd, "ENTER TITLE:", 0, 0, 0x06);

	/* ^Cg */
	if (!gui_input(title_wnd, 2, d77_new_title, 16)) {
		window_close(title_wnd);
		window_close(dst_wnd);
		window_close(src_wnd);
		return TRUE;
	}

	window_close(title_wnd);
	window_close(dst_wnd);
	window_close(src_wnd);

	/* Ro[g */
	if (!conv_vfd_to_d77(vfd_conv_fname, d77_new_fname, d77_new_title)) {
		file_error();
	}

	return TRUE;
}

/*
 *	2D to D77Ro[g
 */
static BOOL twod_to_d77(void)
{
	int src_wnd;
	int dst_wnd;
	int title_wnd;

	/* \[XEChEI[v */
	src_wnd = window_open(3, 8, 7, 23, 5);
	window_print(src_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(src_wnd, 2, twod_conv_fname, 128)) {
		window_close(src_wnd);
		return TRUE;
	}

	/* fBXgl[VEChEI[v */
	dst_wnd = window_open(3, 9, 8, 23, 5);
	window_print(dst_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(dst_wnd, 2, d77_new_fname, 128)) {
		window_close(dst_wnd);
		window_close(src_wnd);
		return TRUE;
	}

	/* ^CgEChEI[v */
	title_wnd = window_open(4, 10, 11, 18, 5);
	window_print(title_wnd, "ENTER TITLE:", 0, 0, 0x06);

	/* ^Cg */
	if (!gui_input(title_wnd, 2, d77_new_title, 16)) {
		window_close(title_wnd);
		window_close(dst_wnd);
		window_close(src_wnd);
		return TRUE;
	}

	window_close(title_wnd);
	window_close(dst_wnd);
	window_close(src_wnd);

	/* Ro[g */
	if (!conv_2d_to_d77(twod_conv_fname, d77_new_fname, d77_new_title)) {
		file_error();
	}

	return TRUE;
}

/*
 *	VTP to T77Ro[g
 */
static BOOL vtp_to_t77(void)
{
	int src_wnd;
	int dst_wnd;

	/* \[XEChEI[v */
	src_wnd = window_open(3, 8, 7, 23, 5);
	window_print(src_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(src_wnd, 2, vtp_conv_fname, 128)) {
		window_close(src_wnd);
		return TRUE;
	}

	/* fBXgl[VEChEI[v */
	dst_wnd = window_open(3, 9, 8, 23, 5);
	window_print(dst_wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(dst_wnd, 2, t77_new_fname, 128)) {
		window_close(dst_wnd);
		window_close(src_wnd);
		return TRUE;
	}

	window_close(dst_wnd);
	window_close(src_wnd);

	/* Ro[g */
	if (!conv_vtp_to_t77(vtp_conv_fname, t77_new_fname)) {
		file_error();
	}

	return TRUE;
}

/*
 *	ԃ[h
 */
static BOOL load_state(void)
{
	int wnd;

	/* \[XEChEI[v */
	wnd = window_open(3, 8, 7, 23, 5);
	window_print(wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(wnd, 2, state_fname, 128)) {
		window_close(wnd);
		return TRUE;
	}

	window_close(wnd);

	/* [h */
	if (!system_load(state_fname)) {
		file_error();
	}

	return TRUE;
}

/*
 *	ԃZ[u
 */
static BOOL save_state(void)
{
	int wnd;

	/* \[XEChEI[v */
	wnd = window_open(3, 8, 7, 23, 5);
	window_print(wnd, enter_fname, 0, 0, 0x06);

	/* t@C */
	if (!gui_input(wnd, 2, state_fname, 128)) {
		window_close(wnd);
		return TRUE;
	}

	window_close(wnd);

	/* Z[u */
	if (!system_save(state_fname)) {
		file_error();
	}

	return TRUE;
}

/*
 *	[eBeBj[e[u
 */
static menu_item_t utymenu_dat[] = {
	{ "MAKE BLANK DISK", make_new_disk, TRUE, FALSE },
	{ "MAKE BLANK TAPE", make_new_tape, TRUE, FALSE },
	{ "CONVERT VFD\x1c\x44\x37\x37", vfd_to_d77, TRUE, FALSE },
	{ "CONVERT  2D\x1c\x44\x37\x37", twod_to_d77, TRUE, FALSE },
	{ "CONVERT VTP\x1c\x54\x37\x37", vtp_to_t77, TRUE, FALSE },
	{ "LOAD STATE", load_state, TRUE, FALSE },
	{ "SAVE STATE", save_state, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*
 *	[eBeBj[
 */
static BOOL utility(void)
{
	int uty_wnd;
	BOOL ret;

	/* EChEI[vAj[AN[Y */
	uty_wnd = window_open(2, 7, 10, 17, 9);
	ret = gui_menu(uty_wnd, &utycur, utymenu_dat);
	window_close(uty_wnd);

	return ret;
}

/*-[ fobO ]---------------------------------------------------------*/

/*
 *	fobO HEX
 */
static void debug_info_hex(BYTE dat, char *buf)
{
	dat &= 0x0f;
	dat += 0x30;
	if (dat > 0x39) {
		dat += 7;
	}
	*buf = dat;
}

/*
 *	fobO HEX2
 */
static void debug_info_2hex(BYTE dat, char *buf)
{
	debug_info_hex((BYTE)(dat >> 4), buf);
	debug_info_hex((BYTE)(dat & 0x0f), buf+1);
}

/*
 *	fobO HEX4
 */
static void debug_info_4hex(WORD dat, char *buf)
{
	debug_info_2hex((BYTE)(dat >> 8), buf);
	debug_info_2hex((BYTE)(dat & 0xff), buf+2);
}

/*
 *	fobO Tu
 */
static void debug_info_sub(int handle, int cpu, int y)
{
	cpu6809_t tmp;
	char buf[80];

	/* ^Cg */
	if (cpu == MAINCPU) {
		window_print(handle, "MAIN CPU:", 0, y, 0x06);
		tmp = maincpu;
	}
	else {
		window_print(handle, "SUB CPU:", 0, y, 0x06);
		tmp = subcpu;
	}

	/* Ps */
	strcpy(buf, "CC-00 A-00 B-00 D-0000 DP-00");
	debug_info_2hex(tmp.cc, &buf[3]);
	debug_info_2hex(tmp.acc.h.a, &buf[8]);
	debug_info_2hex(tmp.acc.h.b, &buf[13]);
	debug_info_4hex(tmp.acc.d, &buf[18]);
	debug_info_2hex(tmp.dp, &buf[26]);
	window_print(handle, buf, 0, y + 2, 0x07);

	/* Qs */
	strcpy(buf, "X-0000 Y-0000 U-0000 S-0000 PC-0000");
	debug_info_4hex(tmp.x, &buf[2]);
	debug_info_4hex(tmp.y, &buf[9]);
	debug_info_4hex(tmp.u, &buf[16]);
	debug_info_4hex(tmp.s, &buf[23]);
	debug_info_4hex(tmp.pc, &buf[31]);
	window_print(handle, buf, 0, y + 3, 0x07);

	/* tAZu */
	disline(cpu, tmp.pc, buf);
	window_print(handle, buf+4, 0, y + 5, 0x07);
}

/*
 *	fobO
 */
static BOOL debug_info(void)
{
	int inp_wnd;
	int debug_wnd;

	/* pXio[ */
	while (!debugflag) {
		inp_wnd = window_open(2, 12, 7, 7, 5);
		window_print(inp_wnd, "PASS:", 0, 0, 0x06);
		if (!gui_numinp(inp_wnd, 2, &debugnum)) {
			window_close(inp_wnd);
			return TRUE;
		}
		window_close(inp_wnd);
		if ((debugnum + 3191) == 10000) {
			debugflag = TRUE;
		}
	}

	/* EChEI[v */
	debug_wnd = window_open(2, 0, 5, 40, 15);
	debug_info_sub(debug_wnd, MAINCPU, 0);
	debug_info_sub(debug_wnd, SUBCPU, 7);
	gui_refresh();
	gui_wait();
	window_close(debug_wnd);

	return TRUE;
}

/*-[ Cj[ ]-------------------------------------------------------*/

/*
 *	fBXN(hCu0)
 */
static BOOL disk_drv0(void)
{
	diskdrv = 0;
	return disk_menu();
}

/*
 *	fBXN(hCu1)
 */
static BOOL disk_drv1(void)
{
	diskdrv = 1;
	return disk_menu();
}

/*
 *	Zbg
 */
static BOOL reset_xm7(void)
{
	system_reset();
	gui_exit_flag = TRUE;

	return TRUE;
}

/*
 *	o[W
 */
static BOOL about_xm7(void)
{
	int wnd;

	/* EChEI[v */
	wnd = window_open(2, 11, 9, 19, 6);
	window_print(wnd, "FM-7 EMULATOR XM7", 0, 0, 0x07);
	window_print(wnd, "V1.0L20(01/03/23)", 0, 1, 0x07);
	window_print(wnd, "COPYRIGHT (C) PI.", 0, 3, 0x07);

	/* EFCgAN[Y */
	gui_refresh();
	gui_wait();
	window_close(wnd);
	return TRUE;
}

/*
 *	VXeI
 */
static BOOL quit_xm7(void)
{
	stopreq_flag = TRUE;
	gui_exit_flag = TRUE;

	return TRUE;
}

/*
 *	Cj[e[u
 */
static menu_item_t mainmenu_dat[] = {
	{ "DISK(DRIVE0)", disk_drv0, TRUE, FALSE },
	{ "DISK(DRIVE1)", disk_drv1, TRUE, FALSE },
	{ "TAPE", ctape, TRUE, FALSE },
	{ "PRINTER", printer, FALSE, FALSE },
	{ "CONFIG", config, TRUE, FALSE },
	{ "UTILITY", utility, TRUE, FALSE },
	{ "DEBUG INFO", debug_info, TRUE, FALSE },
	{ "RESET", reset_xm7, TRUE, FALSE },
	{ "ABOUT XM7", about_xm7, TRUE, FALSE },
	{ "QUIT  XM7", quit_xm7, TRUE, FALSE },
	{ NULL, FALSE, FALSE }
};

/*-[ C ]---------------------------------------------------------------*/

/*
 *	GUI
 *	C
 */
void gui_run(void)
{
	int main_wnd;

	/* GUIJn */
	gui_enter();
	status_open();

	main_wnd = window_open(1, 2, 2, 14, 12);
	gui_menu(main_wnd, &maincur, mainmenu_dat);
	window_close(main_wnd);

	/* GUII */
	status_close();
	gui_leave();
}

/*
 *	GUI
 *	Z[u
 */
BOOL gui_save(int fileh)
{
	return file_bool_write(fileh, bootfast_flag);
}

/*
 *	GUI
 *	[h
 */
BOOL gui_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	return file_bool_read(fileh, &bootfast_flag);
}
