/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ ROM ]
 */

#include <assert.h>
#include <stdlib.h>
#include <string.h>
#include "xm7.h"
#include "kanji.h"
#include "device.h"

/*
 *	O[o [N
 */
BOOL kanji_flag;						/* PROM  */
WORD kanji_addr;						/* PAhX */
BYTE *kanji_rom[4];						/* PROM */

/*
 *	ROM
 *	
 */
BOOL kanji_init(void)
{
	int i;
	int handle;

	/*  */
	memset(kanji_rom, 0, sizeof(kanji_rom));
	kanji_flag = FALSE;

	/* m */
	for (i=0; i<4; i++) {
		kanji_rom[i] = (BYTE *)malloc(0x8000);
		if (kanji_rom[i] == NULL) {
			return TRUE;
		}
	}

	/* t@Cǂݍ */
	handle = file_open(KANJI_ROM, OPEN_R);
	if (handle == -1) {
		return TRUE;
	}
	for (i=0; i<4; i++) {
		file_read(handle, kanji_rom[i], 0x8000);
	}
	file_close(handle);

	kanji_flag = TRUE;
	return TRUE;
}

/*
 *	ROM
 *	N[Abv
 */
void kanji_cleanup(void)
{
	int i;

	for (i=0; i<4; i++) {
		if (kanji_rom[i] != NULL) {
			free(kanji_rom[i]);
		}
	}
}

/*
 *	ROM
 *	Zbg
 */
void kanji_reset(void)
{
	kanji_addr = 0;
}

/*
 *	ROM
 *	PoCgǂݏo
 */
BOOL kanji_readb(WORD addr, BYTE *dat)
{
	int index;
	WORD offset;
	BYTE *p;

	switch (addr) {
		/* AhX */
		case 0xfd20:
			if (!kanji_flag) {
				*dat = 0xff;
				return TRUE;
			}
			*dat = kanji_addr >> 8;
			return TRUE;
		/* AhX */
		case 0xfd21:
			if (!kanji_flag) {
				*dat = 0xff;
				return TRUE;
			}
			*dat = kanji_addr & 0xff;
			return TRUE;
		/* f[^LEFT */
		case 0xfd22:
			if (!kanji_flag) {
				*dat = 0xff;
				return TRUE;
			}
			index = (kanji_addr >> 14);
			ASSERT((index >= 0) && (index <= 3));
			offset = kanji_addr & 0x3fff;
			p = kanji_rom[index];
			*dat = p[offset * 2 + 0];
			return TRUE;
		/* f[^RIGHT */
		case 0xfd23:
			if (!kanji_flag) {
				*dat = 0xff;
				return TRUE;
			}
			index = (kanji_addr >> 14);
			ASSERT((index >= 0) && (index <= 3));
			offset = kanji_addr & 0x3fff;
			p = kanji_rom[index];
			*dat = p[offset * 2 + 1];
			return TRUE;
	}

	return FALSE;
}

/*
 *	ROM
 *	PoCg
 */
BOOL kanji_writeb(WORD addr, BYTE dat)
{
	switch (addr) {
		/* AhX */
		case 0xfd20:
			kanji_addr &= 0x00ff;
			kanji_addr |= (dat << 8);
			return TRUE;
		/* AhX */
		case 0xfd21:
			kanji_addr &= 0xff00;
			kanji_addr |= dat;
			return TRUE;
		/* f[^LEFT*/
		case 0xfd22:
			return TRUE;
		/* f[^RIGHT */
		case 0xfd23:
			return TRUE;
	}

	return FALSE;
}

/*
 *	ROM
 *	Z[u
 */
BOOL kanji_save(int fileh)
{
	if (!file_bool_write(fileh, kanji_flag)) {
		return FALSE;
	}

	if (!file_word_write(fileh, kanji_addr)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	ROM
 *	[h
 */
BOOL kanji_load(int fileh, int ver)
{
	BOOL flag;

	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	/* ROMLtO̓_~[[hAύXȂ */
	if (!file_bool_read(fileh, &flag)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &kanji_addr)) {
		return FALSE;
	}

	return TRUE;
}
