/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ L[{[h ]
 */

#ifndef _keyboard_h_
#define _keyboard_h_

#ifdef __cplusplus
extern "C" {
#endif
/*
 *	vGg
 */
BOOL keyboard_init(void);
										/*  */
void keyboard_cleanup(void);
										/* N[Abv */
void keyboard_reset(void);
										/* Zbg */
BOOL keyboard_readb(WORD addr, BYTE *dat);
										/* ǂݏo */
BOOL keyboard_writeb(WORD addr, BYTE dat);
										/*  */
BOOL keyboard_save(int fileh);
										/* Z[u */
BOOL keyboard_load(int fileh, int ver);
										/* [h */
void keyboard_make(BYTE dat);
										/* L[ */
void keyboard_break(BYTE dat);
										/* L[ */
void keyboard_timer(void);
										/* 10ms^C}[(L[s[gp) */

/*
 *	v[N
 */
extern BOOL caps_flag;
										/* CAPS tO */
extern BOOL kana_flag;
										/* Ji tO */
extern BOOL ins_flag;
										/* INS tO */
extern BOOL shift_flag;
										/* SHIFTL[tO */
extern BOOL ctrl_flag;
										/* CTRLL[tO */
extern BOOL graph_flag;
										/* GRAPHL[tO */
extern BOOL break_flag;
										/* BreakL[tO */
extern BYTE key_scan;
										/* L[R[h(, Make/Breakp) */
extern WORD key_fm7;
										/* L[R[h(FM-7݊) */
#ifdef __cplusplus
}
#endif

#endif	/* _keyboard_h_ */
