/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ CCPU ]
 */

#include <assert.h>
#include "xm7.h"
#include "subctrl.h"
#include "keyboard.h"
#include "mainetc.h"
#include "tapelp.h"
#include "device.h"

/*
 *	O[o [N
 */
cpu6809_t maincpu;

/*
 *	vg^Cv錾
 */
#ifdef CPU_ASM
void main_reset(void);
void main_line(void);
void main_exec(void);
#else
static void cpu_reset(void);
static void cpu_execline(void);
static void cpu_exec(void);
#endif

/*
 *	CCPU
 *	
 */
BOOL maincpu_init(void)
{
	maincpu.readmem = (DWORD)mainmem_readb;
	maincpu.writemem = (DWORD)mainmem_writeb;

	return TRUE;
}

/*
 *	CCPU
 *	N[Abv
 */
void maincpu_cleanup(void)
{
	return;
}

/*
 *	CCPU
 *	Zbg
 */
void maincpu_reset(void)
{
#ifdef	CPU_ASM
	main_reset();
#else
	cpu_reset();
#endif
}

/*
 *	CCPU
 *	Pss
 */
void maincpu_execline(void)
{
#ifdef	CPU_ASM
	main_line();
#else
	cpu_execline();
#endif

	/* e[vJE^ */
	if (tape_motor) {
		tape_subcnt += maincpu.cycle;
		if (tape_subcnt >= 0x10) {
			tape_subcnt -= 0x10;
			tape_count++;
			if (tape_count == 0) {
				tape_count = 0xffff;
			}
		}
	}
}

/*
 *	CCPU
 *	s
 */
void maincpu_exec(void)
{
	/* s */
#ifdef	CPU_ASM
	main_exec();
#else
	cpu_exec();
#endif

	/* e[vJE^ */
	if (tape_motor) {
		tape_subcnt += maincpu.cycle;
		if (tape_subcnt >= 0x10) {
			tape_subcnt -= 0x10;
			tape_count++;
			if (tape_count == 0) {
				tape_count = 0xffff;
			}
		}
	}
}

/*
 *	CCPU
 *	FIRQ荞ݐݒ
 */
void maincpu_firq(void)
{
	/* BREAKL[yсATuCPŨAeV荞 */
	if (break_flag || subattn_flag) {
		maincpu.intr |= INTR_FIRQ;
	}
	else {
		maincpu.intr &= ~INTR_FIRQ;
	}
}

/*
 *	CCPU
 *	IRQ荞ݐݒ
 */
void maincpu_irq(void)
{
	/* IRQ荞ݐݒ */
	if ((key_irq_flag && !(key_irq_mask)) ||
		timer_irq_flag ||
		lp_irq_flag ||
		mfd_irq_flag ||
		txrdy_irq_flag ||
		rxrdy_irq_flag ||
		syndet_irq_flag ||
		opn_irq_flag) {
		maincpu.intr |= INTR_IRQ;
	}
	else {
		maincpu.intr &= ~INTR_IRQ;
	}
}

/*
 *	CCPU
 *	Z[u
 */
BOOL maincpu_save(int fileh)
{
	/* vbgtH[Ƃ̃pbLO邽߁A */
	if (!file_byte_write(fileh, maincpu.cc)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, maincpu.dp)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.acc.d)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.x)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.y)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.u)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.s)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.pc)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.intr)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.cycle)) {
		return FALSE;
	}

	if (!file_word_write(fileh, maincpu.total)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	CCPU
 *	[h
 */
BOOL maincpu_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	/* vbgtH[Ƃ̃pbLO邽߁A */
	if (!file_byte_read(fileh, &maincpu.cc)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &maincpu.dp)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.acc.d)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.x)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.y)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.u)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.s)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.pc)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.intr)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.cycle)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &maincpu.total)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	C6809RA
 */
#ifndef	CPU_ASM

#define CCREG			maincpu.cc
#define AREG			maincpu.acc.h.a
#define BREG			maincpu.acc.h.b
#define DREG			maincpu.acc.d
#define DPREG			maincpu.dp
#define XREG			maincpu.x
#define YREG			maincpu.y
#define UREG			maincpu.u
#define SREG			maincpu.s
#define PCREG			maincpu.pc
#define INTR			maincpu.intr
#define CYCLE			maincpu.cycle
#define TOTAL			maincpu.total

#define READB(addr)		mainmem_readb((WORD)(addr))
#define READW(addr)		((mainmem_readb((WORD)(addr)) << 8) | mainmem_readb((WORD)((addr) + 1)))
#define WRITEB(addr,b)	mainmem_writeb((WORD)(addr), (BYTE)(b))
#define WRITEW(addr,w)	{mainmem_writeb((WORD)(addr), (BYTE)((w) >> 8)); mainmem_writeb((WORD)((addr) + 1), (BYTE)((w) & 0xff));}

#include "cpu.c"

#endif
