/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ }`y[W ]
 */

#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "multipag.h"
#include "display.h"
#include "ttlpalet.h"
#include "device.h"

/*
 *	O[o [N
 */
BYTE multi_page;						/* }`y[W [N */

/*
 *	}`y[W
 *	
 */
BOOL multipag_init(void)
{
	return TRUE;
}

/*
 *	}`y[W
 *	N[Abv
 */
void multipag_cleanup(void)
{
}

/*
 *	}`y[W
 *	Zbg
 */
void multipag_reset(void)
{
	multi_page = 0;
}

/*
 *	}`y[W
 *	PoCgǂݏo
 */
BOOL multipag_readb(WORD addr, BYTE *dat)
{
	if (addr != 0xfd37) {
		return FALSE;
	}

	/* FFǂݏo */
	*dat = 0xff;
	return TRUE;
}

/*
 *	}`y[W
 *	PoCg
 */
BOOL multipag_writeb(WORD addr, BYTE dat)
{
	BYTE v_page;
	int i;
	
	if (addr != 0xfd37) {
		return FALSE;
	}

	/* f[^L */
	multi_page = dat;

	/* \y[W */
	v_page = (BYTE)((dat >> 4) ^ 0x07);
	for (i=0; i<8; i++) {
		if (crt_flag) {
			if ((i & v_page) != i) {
				/* }XNĂ */
				ttlpalet_setb(i, ttl_palet[i & v_page]);
			}
			else {
				/* }XNĂȂ */
				ttlpalet_setb(i, ttl_palet[i]);
			}
		}
		else {
			/* CRT OFF */
			ttlpalet_setb(i, 0);
		}
	}

	return TRUE;
}

/*
 *	}`y[W
 *	Z[u
 */
BOOL multipag_save(int fileh)
{
	return file_byte_write(fileh, multi_page);
}

/*
 *	}`y[W
 *	[h
 */
BOOL multipag_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	return file_byte_read(fileh, &multi_page);
}
