/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ OPN(YM2203) ]
 */

#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "opn.h"
#include "mainetc.h"
#include "device.h"

/*
 *	O[o [N
 */
BYTE opn_reg[256];						/* OPNWX^ */
BOOL opn_timera;						/* ^C}[AtO */
BOOL opn_timerb;						/* ^C}[BtO */
WORD opn_timera_tick;					/* ^C}[AԊu */
WORD opn_timerb_tick;					/* ^C}[BԊu */
BYTE opn_scale;							/* vXP[ */

/*
 *	X^eBbN [N
 */
static BYTE opn_pstate;						/* |[g */
static BYTE opn_selreg;						/* ZNgWX^ */
static BYTE opn_seldat;						/* ZNgf[^ */
static BOOL opn_timera_int;					/* ^C}[AI[o[t[ */
static BOOL opn_timerb_int;					/* ^C}[BI[o[t[ */
static WORD opn_timera_one;					/* Vbg */
static WORD opn_timerb_one;					/* Vbg */
static WORD opn_timera_total;				/* ^C}[Ag[^ */
static WORD opn_timerb_total;				/* ^C}[Bg[^ */

/*
 *	OPN
 *	
 */
BOOL opn_init(void)
{
	return TRUE;
}

/*
 *	OPN
 *	N[Abv
 */
void opn_cleanup(void)
{
	BYTE i;

	/* PSG */
	for (i=0; i<6; i++) {
		opn_setb(i, 0);
	}
	opn_setb(7, 0xff);

	/* TL=$7F */
	for (i=0x40; i<0x50; i++) {
		if ((i & 0x03) == 3) {
			continue;
		}
		opn_setb(i, 0x7f);
	}

	/* L[It */
	for (i=0; i<3; i++) {
		opn_setb(0x28, i);
	}
}

/*
 *	OPN
 *	Zbg
 */
void opn_reset(void)
{
	BYTE i;

	/* WX^NAA^C}[OFF */
	memset(opn_reg, 0, sizeof(opn_reg));
	opn_timera = FALSE;
	opn_timerb = FALSE;

	/* I/O */
	opn_pstate = OPN_INACTIVE;
	opn_selreg = 0;
	opn_seldat = 0;

	/* foCX */
	opn_timera_int = FALSE;
	opn_timerb_int = FALSE;
	opn_timera_tick = 0;
	opn_timerb_tick = 0;
	opn_timera_one = 0;
	opn_timerb_one = 0;
	opn_timera_total = 1000;
	opn_timerb_total = 1000;
	opn_scale = 3;

	/* PSG */
	for (i=0; i<14;i++) {
		if (i == 7) {
			opn_setb(i, 0xff);
			opn_reg[i] = 0xff;
		}
		else {
			opn_setb(i, 0);
		}
	}

	/* MUL,DT */
	for (i=0x30; i<0x40; i++) {
		if ((i & 0x03) == 3) {
			continue;
		}
		opn_setb(i, 0);
	}

	/* TL=$7F */
	for (i=0x40; i<0x50; i++) {
		if ((i & 0x03) == 3) {
			continue;
		}
		opn_setb(i, 0x7f);
		opn_reg[i] = 0x7f;
	}

	/* AR=$1F */
	for (i=0x50; i<0x60; i++) {
		if ((i & 0x03) == 3) {
			continue;
		}
		opn_setb(i, 0x1f);
		opn_reg[i] = 0x1f;
	}

	/* ̑ */
	for (i=0x60; i<0xb4; i++) {
		if ((i & 0x03) == 3) {
			continue;
		}
		opn_setb(i, 0);
	}

	/* SL/RR */
	for (i=0x80; i<0x90; i++) {
		if ((i & 0x03) == 3) {
			continue;
		}
		opn_setb(i, 0xff);
		opn_reg[i] = 0xff;
	}

	/* L[It */
	for (i=0; i<3; i++) {
		opn_setb(0x28, i);
	}
}

/*
 *	OPN
 *	^C}[I[o[t[
 */
static void opn_overflow(void)
{
	/* ^C}[A */
	if (opn_timera) {
		if (opn_timera_total >= opn_timera_one) {
			/* \e΁AĊ荞݉񐔂𑝂₷ */
			opn_timera_total -= opn_timera_one;
			opn_timera_one = 0;
			opn_timera_int = TRUE;
			opn_timera = FALSE;
			mainetc_opn();
		}
		else {
			/* łȂ΁AoneĂ */
			opn_timera_one -= opn_timera_total;
			opn_timera_total = 0;
		}
	}

	/* ^C}[B */
	if (opn_timerb) {
		if (opn_timerb_total >= opn_timerb_one) {
			/* \e΁AĊ荞݉񐔂𑝂₷ */
			opn_timerb_total -= opn_timerb_one;
			opn_timerb_one = 0;
			opn_timerb_int = TRUE;
			opn_timerb = FALSE;
			mainetc_opn();
		}
		else {
			/* łȂ΁AoneĂ */
			opn_timerb_one -= opn_timerb_total;
			opn_timerb_total = 0;
		}
	}
}

/*
 *	OPN
 *	WX^ACǂݏo
 */
static BYTE opn_readreg(BYTE reg)
{
	/* FM͓ǂݏoȂ */
	if (reg >= 0x10) {
		return 0xff;
	}

	return opn_reg[reg];
}

/*
 *	OPN
 *	WX^AC֏
 */
static void opn_writereg(BYTE reg, BYTE dat)
{
	DWORD t;
	BYTE temp;

	/* f[^L */
	opn_reg[reg] = dat;

	switch (reg) {
		/* vXP[P */
		case 0x2d:
			if (opn_scale != 3) {
				opn_scale = 6;
			}
			return;
		/* vXP[Q */
		case 0x2e:
			opn_scale = 3;
			return;
		/* vXP[R */
		case 0x2f:
			opn_scale = 2;
			return;
		/* ^C}[A(10sPʂŌvZ) */
		case 0x24:
		case 0x25:

			/* vZ */
			t = opn_reg[0x24];
			t *= 4;
			temp = opn_reg[0x25] & 3;
			t |= temp;
			t &= 0x3ff;
			t = (1024 - t);
			t *= opn_scale;
			t *= 12;
			t *= 100;
			t /= 1229;
			opn_timera_tick = (WORD)t;
			return;
		/* ^C}[B(10sPʂŌvZ) */
		case 0x26:
			/* vZ */
			t = opn_reg[0x26];
			t = (256 - t);
			t *= 192;
			t *= opn_scale;
			t *= 100;
			t /= 1229;
			opn_timerb_tick = (WORD)t;
			return;
		case 0x27:
			/* I[o[t[tÕNA */
			if (dat & 0x10) {
				opn_timera_int = FALSE;
			}
			if (dat & 0x20) {
				opn_timerb_int = FALSE;
			}

			if (!opn_timera && !opn_timera_int) {
				if ((dat & 0x05) == 0x05) {
					/* ^C}[AJn */
					opn_timera = TRUE;
					opn_timera_one += opn_timera_tick;
				}
			}
			else {
				if ((dat & 0x01) == 0) {
					/* ^C}[A~ */
					opn_timera = FALSE;
				}
			}
			if (!opn_timerb && !opn_timerb_int) {
				if ((dat & 0x0a) == 0x0a) {
					/* ^C}[BJn */
					opn_timerb = TRUE;
					opn_timerb_one += opn_timerb_tick;
				}
			}
			else {
				if ((dat & 0x02) == 0) {
					/* ^C}[B~ */
					opn_timerb = FALSE;
				}
			}
			/* Ŋ荞݃tO~낷 */
			if (!opn_timera_int && !opn_timerb_int) {
				opn_irq_flag = FALSE;
				maincpu_irq();
			}
			/* Kvł΁AŊ荞݂ėǂ */
			opn_overflow();

			/* [hݒ̂ݏo */
			opn_setb(0x27, (BYTE)(dat & 0xc0));
			return;
	}

	/* o͐i */
	if ((reg >= 14) && (reg <= 0x26)) {
		return;
	}
	if ((reg >= 0x29) && (reg <= 0x2f)) {
		return;
	}

	opn_setb(reg, dat);
}

/*
 *	OPN
 *	10ms^C}[
 */
void opn_timer(void)
{
	/* Reload */
	opn_timera_total = 1000;
	opn_timerb_total = 1000;

	/* I[o[t[`FbN */
	opn_overflow();
}

/*
 *	OPN
 *	PoCgǂݏo
 */
BOOL opn_readb(WORD addr, BYTE *dat)
{
	switch (addr) {
		/* R}hWX^͓ǂݏo֎~ */
		case 0xfd0d:
		case 0xfd15:
			*dat = 0xff;
			return TRUE;

		/* f[^WX^ */
		case 0xfd0e:
		case 0xfd16:
			switch (opn_pstate) {
				/* ʏR}h */
				case OPN_INACTIVE:
				case OPN_READDAT:
				case OPN_WRITEDAT:
				case OPN_ADDRESS:
					*dat = opn_seldat;
					break;

				/* Xe[^Xǂݏo */
				case OPN_READSTAT:
					*dat = 0;
					if (opn_timera_int) {
						*dat |= 0x01;
					}
					if (opn_timerb_int) {
						*dat |= 0x02;
					}
					break;

				/* WCXeBbNǂݎ */
				case OPN_JOYSTICK:
					if (opn_selreg == 14) {
						if ((opn_reg[15] & 0xf0) == 0x20) {
							/* WCXeBbNP */
							*dat = (~joy_getb(0) | 0xc0);
							break;
						}
						if ((opn_reg[15] & 0xf0) == 0x50) {
							/* WCXeBbNQ */
							*dat = (~joy_getb(1) | 0xc0);
							break;
						}
						/* ȊO */
						*dat = 0xff;
					}
					else {
						/* WX^14łȂ΁AFFȊOԂ */
						/* HOW MANY ROBOT΍ */
						*dat = 0;
					}
					break;
			}
			return TRUE;

		/* g荞݃Xe[^X */
		case 0xfd17:
			/* FM77AVȍ~̃T|[gHElevator Action΍ */
			if (opn_timera_int || opn_timerb_int) {
				*dat = 0xf7;
			}
			else {
				*dat = 0xff;
			}
			return TRUE;
	}

	return FALSE;
}

/*
 *	OPN
 *	PoCg
 */
BOOL opn_writeb(WORD addr, BYTE dat)
{
	switch (addr) {
		/* PSGR}hWX^ */
		case 0xfd0d:
			switch (dat & 0x03) {
				/* CANeBu(`ȂAf[^WX^) */
				case OPN_INACTIVE:
					opn_pstate = OPN_INACTIVE;
					break;
				/* f[^ǂݏo */
				case OPN_READDAT:
					opn_pstate = OPN_READDAT;
					opn_seldat = opn_readreg(opn_selreg);
					break;
				/* f[^ */
				case OPN_WRITEDAT:
					opn_pstate = OPN_WRITEDAT;
					opn_writereg(opn_selreg, opn_seldat);
					break;
				/* b`AhX */
				case OPN_ADDRESS:
					opn_pstate = OPN_ADDRESS;
					opn_selreg = opn_seldat;
					break;
			}
			return TRUE;

		/* OPNR}hWX^ */
		case 0xfd15:
			switch (dat & 0x0f) {
				/* CANeBu(`ȂAf[^WX^) */
				case OPN_INACTIVE:
					opn_pstate = OPN_INACTIVE;
					break;
				/* f[^ǂݏo */
				case OPN_READDAT:
					opn_pstate = OPN_READDAT;
					opn_seldat = opn_readreg(opn_selreg);
					break;
				/* f[^ */
				case OPN_WRITEDAT:
					opn_pstate = OPN_WRITEDAT;
					opn_writereg(opn_selreg, opn_seldat);
					break;
				/* b`AhX */
				case OPN_ADDRESS:
					opn_pstate = OPN_ADDRESS;
					opn_selreg = opn_seldat;
					break;
				/* [hXe[^X */
				case OPN_READSTAT:
					opn_pstate = OPN_READSTAT;
					break;
				/* WCXeBbNǂݎ */
				case OPN_JOYSTICK:
					opn_pstate = OPN_JOYSTICK;
					break;
			}
			return TRUE;

		/* f[^WX^ */
		case 0xfd0e:
		case 0xfd16:
			opn_seldat = dat;
			/* CANeBuȊȌꍇ́A̓s */
			switch (opn_pstate){
				/* f[^ */
				case OPN_WRITEDAT:
					opn_writereg(opn_selreg, opn_seldat);
					break;
				/* b`AhX */
				case OPN_ADDRESS:
					opn_selreg = opn_seldat;
					break;
			}
			return TRUE;
	}

	return FALSE;
}

/*
 *	OPN
 *	Z[u
 */
BOOL opn_save(int fileh)
{
	if (!file_write(fileh, opn_reg, 256)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, opn_timera)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, opn_timerb)) {
		return FALSE;
	}
	if (!file_word_write(fileh, opn_timera_tick)) {
		return FALSE;
	}
	if (!file_word_write(fileh, opn_timerb_tick)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, opn_scale)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, opn_pstate)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, opn_selreg)) {
		return FALSE;
	}
	if (!file_byte_write(fileh, opn_seldat)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, opn_timera_int)) {
		return FALSE;
	}
	if (!file_bool_write(fileh, opn_timerb_int)) {
		return FALSE;
	}

	if (!file_word_write(fileh, opn_timera_one)) {
		return FALSE;
	}
	if (!file_word_write(fileh, opn_timerb_one)) {
		return FALSE;
	}
	if (!file_word_write(fileh, opn_timera_total)) {
		return FALSE;
	}
	if (!file_word_write(fileh, opn_timerb_total)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	OPN
 *	[h
 */
BOOL opn_load(int fileh, int ver)
{
	int i;

	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	if (!file_read(fileh, opn_reg, 256)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &opn_timera)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &opn_timerb)) {
		return FALSE;
	}
	if (!file_word_read(fileh, &opn_timera_tick)) {
		return FALSE;
	}
	if (!file_word_read(fileh, &opn_timerb_tick)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &opn_scale)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &opn_pstate)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &opn_selreg)) {
		return FALSE;
	}
	if (!file_byte_read(fileh, &opn_seldat)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &opn_timera_int)) {
		return FALSE;
	}
	if (!file_bool_read(fileh, &opn_timerb_int)) {
		return FALSE;
	}

	if (!file_word_read(fileh, &opn_timera_one)) {
		return FALSE;
	}
	if (!file_word_read(fileh, &opn_timerb_one)) {
		return FALSE;
	}
	if (!file_word_read(fileh, &opn_timera_total)) {
		return FALSE;
	}
	if (!file_word_read(fileh, &opn_timerb_total)) {
		return FALSE;
	}

	/* OPNWX^ */
	for (i=0; i<14; i++) {
		opn_setb((BYTE)i, opn_reg[i]);
	}

	for (i=0x30; i<0xb4; i++) {
		if ((i & 0x03) != 3) {
			opn_setb((BYTE)i, opn_reg[i]);
		}
	}
	opn_setb(0x28, 0);
	opn_setb(0x28, 1);
	opn_setb(0x28, 2);

	return TRUE;
}
