// ---------------------------------------------------------------------------
//	OPN-ish Sound Generator
//	Copyright (C) cisc 1998, 1999.
// ---------------------------------------------------------------------------
//	$Id: opna.h,v 1.10 1999/09/25 03:15:16 cisc Exp $

#ifndef FM_OPNA_H
#define FM_OPNA_H

#include "fmgen.h"
#include "psg.h"

// ---------------------------------------------------------------------------
//	class OPN/OPNA
//	OPN/OPNA ɗǂ𐶐鉹jbg
//	
//	interface:
//	bool Init(uint clock, uint rate, bool interpolation, const char* path);
//		D̃NXgpOɂȂ炸ĂłƁD
//		OPNA ̏ꍇ͂̊֐ŃYTvǂݍ
//
//		clock:	OPN ̓NbN (OPNA ̏ꍇ͎ۂ 1/2 ̐l^)
//
//		rate:	 PCM ̃[g
//
//		inter.:	`⊮[h (OPNA ̂ݗL)
//				true ɂƁCFM ͉̍{̃[gōs悤
//				ȂDŏIIɐ PCM  rate Ŏw肳ꂽ[gɂȂ
//				悤`⊮
//				
//		path:	YTṽpX(OPNA ̂ݗL)
//				ȗ̓JgfBNgǂݍ
//				̖ɂ '\'  '/' Ȃǂ邱
//
//		Ԃl	ɐ true
//
//	bool LoadRhythmSample(const char* path)
//		(OPNA ONLY)
//		Rhythm TvǂݒD
//		path  Init  path ƓD
//		
//	bool SetRate(uint clock, uint rate, bool interpolation)
//		NbN PCM [gύX
//		 Init QƂ̂ƁD
//	
//	void Mix(Sample* dest, int nsamples)
//		Stereo PCM f[^ nsamples C dest Ŏn܂z
//		(Z)
//		Edest ɂ sample*2 ̗̈悪Kv
//		Ei[` L, R, L, R... ƂȂD
//		E܂ŉZȂ̂ŁC炩ߔz[NAKv
//		ESample  32bit int z肵Ă̂ŁC̊֐ł̓NbsO
//		  sȂD
//		E̊֐͉̃^C}[Ƃ͖łD
//		  Timer ͂܂ Count  GetNextEvent ő삷KvD
//	
//	void Reset()
//		Zbg()
//
//	void SetReg(uint reg, uint data)
//		̃WX^ reg  data 
//	
//	uint GetReg(uint reg)
//		̃WX^ reg ̓eǂݏo
//		ǂݍނƂo郌WX^ PSG, ADPCM ̈ꕔCID(0xff) Ƃ
//	
//	uint ReadStatus()/ReadStatusEx()
//		̃Xe[^XWX^ǂݏo
//		ReadStatusEx ͊gXe[^XWX^̓ǂݏo(OPNA)
//		busy tO̓G~[gĂȂ
//	
//	bool Count(uint32 t)
//		̃^C}[ t [ʕb] i߂D
//		̓Ԃɕω(timer I[o[t[)
//		true Ԃ
//
//	uint32 GetNextEvent()
//		̃^C}[̂ǂ炩I[o[t[܂łɕKv
//		[ʕb]Ԃ
//		^C}[~Ăꍇ ULONG_MAX Ԃc Ǝv
//	
//	void SetVolumeFM(int db)/SetVolumePSG(int db) ...
//		ẻʂ𒲐߂
//		Pʂ͖ 1/2 dBCL͈͂̏ 20 (10dB)
//
#if 0
namespace FM
{
#endif
	//	OPN Base -------------------------------------------------------
	class OPNBase
	{
	public:
		OPNBase();
		
		bool	Init(uint32 c, uint32 rf, uint32 rp);
		virtual void Reset();
		
		bool	Count(int32 us);
		int32	GetNextEvent();
		
		void	SetVolumeFM(int db);
		void	SetVolumePSG(int db);
	
	protected:
		virtual void SetStatus(uint8 bit) = 0;
		virtual void ResetStatus(uint8 bit) = 0;
		void	SetParameter(Channel4* ch, uint addr, uint data);
		void	SetTimerA(uint addr, uint data);
		void	SetTimerB(uint data);
		void	SetTimerControl(uint data);
		void	SetPrescaler(uint p);
		void	RebuildTimeTable();
		
		Channel4* csmch;
		int32	fmvolume;
		
		uint32	clock;
		uint32	rate;
		uint32	psgrate;
		uint8	status;
		uint8	reg27;
	
	private:
		uint8	prescale;
		uint8	reg24[2];
		
		int32	timera;
		int32	timera_count;
		int32	timerb;
		int32	timerb_count;
		int32	timer_count;
		int32	timer_step;

	protected:
		PSG		psg;
	};

	//	YM2203(OPN) ----------------------------------------------------
	class OPN : public OPNBase
	{
	public:
		OPN();
		virtual ~OPN() {}
		
		bool	Init(uint32 c, uint32 r, bool, const char*);
		bool	SetRate(uint32 c, uint32 r, bool);
		
		void	Reset();
		void 	Mix(Sample* buffer, int nsamples);
		void 	SetReg(uint8 addr, uint8 data);
		uint	GetReg(uint8 addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx() { return 0xff; }
		
	private:
		virtual void Intr(bool) {}
		
		void	SetStatus(uint8 bit);
		void	ResetStatus(uint8 bit);
		
		uint16	fnum[3];
		uint16	fnum3[3];
		uint16	fnum2[6];

		Channel4 ch[3];
	};

	//	YM2608(OPNA) ---------------------------------------------------
	class OPNA : public OPNBase
	{
	public:
		OPNA();
		virtual ~OPNA();
		
		bool	Init(uint c, uint r, bool ipflag = false, const char* rhythmpath=0);
		bool	LoadRhythmSample(const char*);
	
		bool	SetRate(uint c, uint r, bool ipflag = false);
		void 	Mix(Sample* buffer, int nsamples);

		void	Reset();
		void 	SetReg(uint addr, uint data);
		uint	GetReg(uint addr);
		uint	ReadStatus() { return status & 0x03; }
		uint	ReadStatusEx();

		void	SetVolumeADPCM(int db);
		void	SetVolumeRhythmTotal(int db);
		void	SetVolumeRhythm(int index, int db);

		uint8*	GetADPCMBuffer() { return adpcmbuf; }
		void	SetChannelMask(uint mask);
		
	private:
		virtual void Intr(bool) {}
	
	private:
		void 	Mix3(Sample* buffer, int nsamples);
		void 	Mix3I(Sample* buffer, int nsamples);
		void 	Mix6(Sample* buffer, int nsamples);
		void 	Mix6I(Sample* buffer, int nsamples);
		
		void	SetStatus(uint8 bit);
		void	ResetStatus(uint8 bit);
		void	UpdateStatus();

		void	DecodeADPCM();
		void	ADPCMMix(Sample* dest, uint count);
		void	RhythmMix(Sample* buffer, uint count);

		void	WriteRAM(uint data);
		uint	ReadRAM();
		int		ReadRAMN();
		int		DecodeADPCMSample(uint);
		
	// `ԗp[N
		int32	mixl, mixr;		
		int32	mixdelta;
		int		mpratio;
		bool	interpolation;
		
	// FM ֌W
		uint8	reg29;
		uint8	reg22;
		uint8	stmask;
		uint8	statusnext;

		uint32	lfocount;
		uint32	lfodcount;
		
		uint	fnum[6];
		uint	fnum3[6];
		
		uint8	pan[6];
		uint8	fnum2[9];

	// ADPCM ֌W
		uint8*	adpcmbuf;		// ADPCM RAM
		uint	startaddr;		// Start address
		uint	stopaddr;		// Stop address
		uint	memaddr;		// ĐAhX
		uint	limitaddr;		// Limit address
		int		adpcmlevel;		// ADPCM 
		int		adpcmvolume;
		int		adpcmvol;
		uint	deltan;			// N
		int		adplc;			// gϊpϐ
		int		adpld;			// gϊpϐl
		uint	adplbase;		// adpld ̌
		int		adpcmx;			// ADPCM p x
		int		adpcmd;			// ADPCM p 
		int		adpcmout;		// ADPCM ̏o
		int		adpcmprev;		// ADPCM Ȍo
		int		apout0;			// out(t-2)+out(t-1)
		int		apout1;			// out(t-1)+out(t)

		uint	adpcmreadbuf;	// ADPCM [hpobt@
		bool	adpcmplay;		// ADPCM Đ
		uint8	granuality;		

		uint8	control1;		// ADPCM Rg[WX^P
		uint8	control2;		// ADPCM Rg[WX^Q
		uint8	adpcmreg[8];	// ADPCM WX^̈ꕔ

	// Y֌W
		uint8	rhythmpan[6];	// Y PAN
		int8	rhythmil[6];	// Ỷ
		int8	rhythmtl;		// YŜ̉
		uint8	rhythmkey;		// ỸL[
		int		rhythmivol[6];	// Ỷω
		int		rhythmtvol;		// YŜ̉ω

		int16*	rhythmsample[6];// YTv
		int		rhythmsize[6];	// YTṽTCY
		int		rhythmpos[6];	// Đ̈ʒu
		uint	rhythmstep[6];	// rhythmptr ̑l
		uint	rhythmrate[6];	// ỸTvO[g
 
		Channel4 ch[6];
	};
#if 0
}
#endif

// ---------------------------------------------------------------------------

inline void OPNBase::RebuildTimeTable()
{
	int p = prescale;
	prescale = -1;
	SetPrescaler(p);
}

inline void OPNBase::SetVolumePSG(int db)
{
	psg.SetVolume(db);
}

#endif // FM_OPNA_H
