// ---------------------------------------------------------------------------
//	PSG-like sound generator
//	Copyright (C) cisc 1997, 1999.
// ---------------------------------------------------------------------------
//	$Id: psg.h,v 1.5 1999/09/25 03:15:17 cisc Exp $

#ifndef PSG_H
#define PSG_H

// ---------------------------------------------------------------------------
//	class PSG
//	PSG ɗǂ𐶐鉹jbg
//	
//	interface:
//	bool SetClock(uint clock, uint rate)
//		D̃NXgpOɂȂ炸ĂłƁD
//		PSG ̃NbN PCM [gݒ肷
//
//		clock:	PSG ̓NbN
//		rate:	 PCM ̃[g
//		retval	ɐ true
//
//	void Mix(Sample* dest, int nsamples)
//		PCM  nsamples C dest Ŏn܂zɉ(Z)
//		܂ŉZȂ̂ŁCŏɔz[NAKv
//	
//	void Reset()
//		Zbg
//
//	void SetReg(uint reg, uint8 data)
//		WX^ reg  data 
//	
//	uint GetReg(uint reg)
//		WX^ reg ̓eǂݏo
//	
//	void SetVolume(int db)
//		ẻʂ𒲐߂
//		Pʂ͖ 1/2 dB
//
class PSG
{
public:
	typedef int32 Sample;
	enum
	{
		noisetablesize = 512,	// gpʂ炵Ȃ猸炵
		toneshift = 24,
		envshift = 22,
		noiseshift = 14,
		oversampling = 2,		//  葬xDȂ猸炷Ƃ
	};

public:
	PSG();
	~PSG();

	void Mix(Sample* dest, int nsamples);
	void SetClock(int32 clock, int32 rate);
	
	void SetVolume(int vol);
	void SetChannelMask(int c);
	
	void Reset();
	void SetReg(uint8 regnum, uint8 data);
	uint8 GetReg(uint8 regnum) { return reg[regnum & 0x0f]; }

protected:
	void MakeNoiseTable();
	void MakeEnvelopTable();

	uint8 reg[16];

	const uint32* envelop;
	uint32 olevel[3];
	uint32 scount[3], speriod[3];
	uint32 ecount, eperiod;
	uint32 ncount, nperiod;
	uint32 tperiodbase;
	uint32 eperiodbase;
	uint32 nperiodbase;
	int volume;
	int mask;

	static uint32 enveloptable[16][64];
	static uint32 noisetable[noisetablesize];
	static int32 EmitTable[32];
};

#endif // PSG_H
