/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ TuCPURg[ ]
 */

#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "subctrl.h"
#include "keyboard.h"
#include "device.h"

 /*
 *	O[o [N
 */
BOOL subhalt_flag;						/* TuHALTtO */
BOOL subbusy_flag;						/* TuBUSYtO */
BOOL subcancel_flag;					/* TuLZtO */
BOOL subattn_flag;						/* TuAeVtO */
BYTE subfast_flag;						/* Tu[h */
BYTE shared_ram[0x80];					/* LRAM */

/*
 *	TuCPURg[
 *	
 */
BOOL subctrl_init(void)
{
	subfast_flag = 0;
	return TRUE;
}

/*
 *	TuCPURg[
 *	N[Abv
 */
void subctrl_cleanup(void)
{
}

/*
 *	TuCPURg[
 *	Zbg
 */
void subctrl_reset(void)
{
	subhalt_flag = FALSE;
	subbusy_flag = TRUE;
	subcancel_flag = FALSE;
	subattn_flag = FALSE;

	memset(shared_ram, 0xff, sizeof(shared_ram));

	/* Tu[hsleepԂɂ΁Arun */
	if (subfast_flag > 0) {
		subfast_flag = 1;
	}
}

/*
 *	TuCPURg[
 *	PoCgǂݏo
 */
BOOL subctrl_readb(WORD addr, BYTE *dat)
{
	BYTE ret;

	/* TuCPU AeV荞݁ABreakL[荞 */
	if (addr == 0xfd04) {
		ret = 0xff;
		/* AeVtO */
		if (subattn_flag) {
			ret &= ~0x01;
			subattn_flag = FALSE;
		}
		/* BreakL[tO */
		if (break_flag) {
			ret &= ~0x02;
		}
		*dat = ret;
		maincpu_firq();
		return TRUE;
	}

	/* TuC^tF[X */
	if (addr == 0xfd05) {
		if (subbusy_flag) {
			*dat = 0xfe;
			return TRUE;
		}
		else {
			*dat = 0x7e;
			return TRUE;
		}
	}
	
	return FALSE;
}

/*
 *	TuCPURg[
 *	PoCg
 */
BOOL subctrl_writeb(WORD addr, BYTE dat)
{
	/* TuRg[ */
	if (addr == 0xfd05) {
		if (dat & 0x80) {
			/* TuHALT */
			subhalt_flag = TRUE;
			subbusy_flag = TRUE;
		}
		else {
			subhalt_flag = FALSE;
			if (subfast_flag > 0) {
				subfast_flag = 1;
			}
		}
		if (dat & 0x40) {
			/* LZIRQ */
			subcancel_flag = TRUE;
		}
		subcpu_irq();
		return TRUE;
	}
	return FALSE;
}

/*
 *	TuCPURg[
 *	Z[u
 */
BOOL subctrl_save(int fileh)
{
	if (!file_bool_write(fileh, subhalt_flag)) {
		return FALSE;
	}

	if (!file_bool_write(fileh, subbusy_flag)) {
		return FALSE;
	}

	if (!file_bool_write(fileh, subcancel_flag)) {
		return FALSE;
	}

	if (!file_bool_write(fileh, subattn_flag)) {
		return FALSE;
	}

	if (!file_byte_write(fileh, subfast_flag)) {
		return FALSE;
	}

	if (!file_write(fileh, shared_ram, 0x80)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	TuCPURg[
 *	[h
 */
BOOL subctrl_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &subhalt_flag)) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &subbusy_flag)) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &subcancel_flag)) {
		return FALSE;
	}

	if (!file_bool_read(fileh, &subattn_flag)) {
		return FALSE;
	}

	if (!file_byte_read(fileh, &subfast_flag)) {
		return FALSE;
	}

	if (!file_read(fileh, shared_ram, 0x80)) {
		return FALSE;
	}

	return TRUE;
}
