/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ TuCPU ]
 */

#include <stdlib.h>
#include <assert.h>
#include <string.h>
#include "xm7.h"
#include "display.h"
#include "subctrl.h"
#include "device.h"
#include "keyboard.h"
#include "multipag.h"

#ifdef _WIN32
#include <crtdbg.h>
#endif

/*
 *	O[o [N
 */
BYTE *vram_c;						/* VRAM(^CvC) $C000 */
BYTE *subrom_c;						/* ROM (^CvC) $2800 */
BYTE *sub_ram;						/* R\[RAM $1380 */
BYTE *sub_io;						/* TuCPU I/O   $0400 */

/*
 *	TuCPU
 *	
 */
BOOL submem_init(void)
{
	/* m(^Cv) */
	vram_c = (BYTE *)malloc(0xc000);
	if (vram_c == NULL) {
		return FALSE;
	}
	subrom_c = (BYTE *)malloc(0x2800);
	if (subrom_c == NULL) {
		return FALSE;
	}

	/* m() */
	sub_ram = (BYTE *)malloc(0x1380);
	if (sub_ram == NULL) {
		return FALSE;
	}
	sub_io = (BYTE *)malloc(0x0400);
	if (sub_io == NULL) {
		return FALSE;
	}

	/* ROMt@Cǂݍ */
	if (!file_load(SUBSYSC_ROM, subrom_c, 0x2800)) {
		return FALSE;
	}

	/* I/O NA */
	memset(sub_io, 0xff, 0x0400);

	return TRUE;
}
	
/*
 *	TuCPU
 *	N[Abv
 */
void submem_cleanup(void)
{
	ASSERT(vram_c);
	ASSERT(subrom_c);
	ASSERT(sub_ram);
	ASSERT(sub_io);

	/* rŎsꍇl */
	if (vram_c) {
		free(vram_c);
	}
	if (subrom_c) {
		free(subrom_c);
	}
	if (sub_ram) {
		free(sub_ram);
	}
	if (sub_io) {
		free(sub_io);
	}
}

/*
 *	TuCPU
 *	Zbg
 */
void submem_reset(void)
{
}

/*
 *	TuCPU
 *	PoCg擾
 */
BYTE submem_readb(WORD addr)
{
	BYTE dat;
	
	/* VRAM(^CvC) */
	if (addr < 0x4000) {
		if (multi_page & 0x01) {
			return 0xff;
		}
		else {
			return vram_c[addr];
		}
	}
	if (addr < 0x8000) {
		if (multi_page & 0x02) {
			return 0xff;
		}
		else {
			return vram_c[addr];
		}
	}
	if (addr < 0xc000) {
		if (multi_page & 0x04) {
			return 0xff;
		}
		else {
			return vram_c[addr];
		}
	}

	/* [NRAM */
	if ((addr >= 0xc000) && (addr < 0xd380)) {
		return sub_ram[addr - 0xc000];
	}

	/* LRAM */
	if ((addr >= 0xd380) && (addr < 0xd400)) {
		ASSERT(!subhalt_flag);
		return shared_ram[(WORD)(addr - 0xd380)];
	}

	/* TuROM(^CvC) */
	if (addr >= 0xd800) {
		return subrom_c[addr - 0xd800];
	}

	/*
	 *	TuI/O
	 */

	/* fBXvC */
	if (display_readb(addr, &dat)) {
		return dat;
	}
	/* L[{[h */
	if (keyboard_readb(addr, &dat)) {
		return dat;
	}

	/* uU[(_~[) */
	if (addr == 0xd403) {
		return 0;
	}

#if defined(_WIN32) && defined(_DEBUG)
	_CrtDbgReport(_CRT_WARN, NULL, (int)NULL, 0, "AhXǂݍ %04x\n", addr);
#endif
	return 0xff;
}

/*
 *	TuCPU
 *	PoCg擾(I/OȂ)
 */
BYTE submem_readbnio(WORD addr)
{
	/* VRAM(^CvC) */
	if (addr < 0xc000) {
		return vram_c[addr - 0x0000];
	}

	/* [NRAM */
	if ((addr >= 0xc000) && (addr < 0xd380)) {
		return sub_ram[addr - 0xc000];
	}

	/* LRAM */
	if ((addr >= 0xd380) && (addr < 0xd400)) {
		ASSERT(!subhalt_flag);
		return shared_ram[(WORD)(addr - 0xd380)];
	}

	/* TuI/O */
	if ((addr >= 0xd400) && (addr < 0xd800)) {
		return sub_io[addr - 0xd400];
	}

	/* TuROM(^CvC) */
	if (addr >= 0xd800) {
		return subrom_c[addr - 0xd800];
	}

	/* ɂ͗Ȃ */
	ASSERT(FALSE);
	return 0;
}

/*
 *	TuCPU
 *	PoCg
 */
void submem_writeb(WORD addr, BYTE dat)
{
	/* VRAM(^CvC) */
	if (addr < 0x4000) {
		if (multi_page & 0x01) {
			return;
		}
		else {
			vram_c[addr] = dat;
			/* tbN֐ */
			vram_setb(addr, dat);
			return;
		}
	}
	if (addr < 0x8000) {
		if (multi_page & 0x02) {
			return;
		}
		else {
			vram_c[addr] = dat;
			/* tbN֐ */
			vram_setb(addr, dat);
			return;
		}
	}
	if (addr < 0xc000) {
		if (multi_page & 0x04) {
			return;
		}
		else {
			vram_c[addr] = dat;
			/* tbN֐ */
			vram_setb(addr, dat);
		}
		return;
	}

	/* [NRAM */
	if ((addr >= 0xc000) && (addr < 0xd380)) {
		sub_ram[addr - 0xc000] = dat;
		return;
	}

	/* LRAM */
	if ((addr >= 0xd380) && (addr < 0xd400)) {
		ASSERT(!subhalt_flag);
		shared_ram[(WORD)(addr - 0xd380)] = dat;
		return;
	}

	/* TuROM(^CvC)݂łȂ */
	if (addr >= 0xd800) {
		/* YAMAUCHIŏANMI荞݃nhŏ */
		/* Thunder Force΍ */
		return;
	}

	/*
	 *	TuI/O
	 */
	if ((addr >= 0xd400) && (addr < 0xd800)) {
		sub_io[addr - 0xd400] = dat;
	}

	/* fBXvC */
	if (display_writeb(addr, dat)) {
		return;
	}
	/* L[{[h */
	if (keyboard_writeb(addr, dat)) {
		return;
	}

	/* T|[gĂȂAhX */
#if defined(_WIN32) && defined(_DEBUG)
	_CrtDbgReport(_CRT_WARN, NULL, (int)NULL, 0, "AhX %04x\n", addr);
#endif
}

/*
 *	TuCPU
 *	Z[u
 */
BOOL submem_save(int fileh)
{
	if (!file_write(fileh, vram_c, 0x6000)) {
		return FALSE;
	}
	if (!file_write(fileh, &vram_c[0x6000], 0x6000)) {
		return FALSE;
	}

#if 0
	if (!file_write(fileh, subrom_c, 0x2800)) {
		return FALSE;
	}
#endif

	if (!file_write(fileh, sub_ram, 0x1380)) {
		return FALSE;
	}

	if (!file_write(fileh, sub_io, 0x400)) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	TuCPU
 *	[h
 */
BOOL submem_load(int fileh, int ver)
{
	/* o[W`FbN */
	if (ver > 1) {
		return FALSE;
	}

	if (!file_read(fileh, vram_c, 0x6000)) {
		return FALSE;
	}
	if (!file_read(fileh, &vram_c[0x6000], 0x6000)) {
		return FALSE;
	}

#if 0
	if (!file_read(fileh, subrom_c, 0x2800)) {
		return FALSE;
	}
#endif

	if (!file_read(fileh, sub_ram, 0x1380)) {
		return FALSE;
	}

	if (!file_read(fileh, sub_io, 0x400)) {
		return FALSE;
	}

	return TRUE;
}
