/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win16 L[{[h ]
 */

#ifdef _WIN16

#include <owl\applicat.h>
#include <owl\framewin.h>
#include <owl\dc.h>
#include <owl\dialog.h>
#include <owl\listbox.h>
#include "xm7.h"
#include "w16.h"
#include "keyboard.h"
#include "gui.h"

/*-[ R[hϊ ]-----------------------------------------------------------*/

/*
 *	Win16 OEMR[hFM7 R[h
 *	106L[{[hpR[hΏƕ\
 */
static BYTE jp106_key_table[] = {
	0x01, 0x5c,							/* BREAK (ESC)*/

	0x3b, 0x5d,							/* F1 */
	0x3c, 0x5e,							/* F2 */
	0x3d, 0x5f,							/* F3 */
	0x3e, 0x60,							/* F4 */
	0x3f, 0x61,							/* F5 */
	0x40, 0x62,							/* F6 */
	0x41, 0x63,							/* F7 */
	0x42, 0x64,							/* F8 */
	0x43, 0x65,							/* F9 */
	0x44, 0x66,							/* F10 */

	0x29, 0x01,							/* ESC (p/Sp) */
	0x02, 0x02,							/* 1 */
	0x03, 0x03,							/* 2 */
	0x04, 0x04,							/* 3 */
	0x05, 0x05,							/* 4 */
	0x06, 0x06,							/* 5 */
	0x07, 0x07,							/* 6 */
	0x08, 0x08,							/* 7 */
	0x09, 0x09,							/* 8 */
	0x0a, 0x0a,							/* 9 */
	0x0b, 0x0b,							/* 0 */
	0x0c, 0x0c,							/* - */
	0x0d, 0x0d,							/* ^ */
	0x7d, 0x0e,							/* \ */
	0x0e, 0x0f,							/* BS */

	0x0f, 0x10,							/* TAB */
	0x10, 0x11,							/* Q */
	0x11, 0x12,							/* W */
	0x12, 0x13,							/* E */
	0x13, 0x14,							/* R */
	0x14, 0x15,							/* T */
	0x15, 0x16,							/* Y */
	0x16, 0x17,							/* U */
	0x17, 0x18,							/* I */
	0x18, 0x19,							/* O */
	0x19, 0x1a,							/* P */
	0x1a, 0x1b,							/* @ */
	0x1b, 0x1c,							/* [ */
	0x1c, 0x1d,							/* CR */

	0x1d, 0x52,							/* CTRL */
	0x1e, 0x1e,							/* A */
	0x1f, 0x1f,							/* S */
	0x20, 0x20,							/* D */
	0x21, 0x21,							/* F */
	0x22, 0x22,							/* G */
	0x23, 0x23,							/* H */
	0x24, 0x24,							/* J */
	0x25, 0x25,							/* K */
	0x26, 0x26,							/* L */
	0x27, 0x27,							/* ; */
	0x28, 0x28,							/* : */
	0x2b, 0x29,							/* ] */

	0x2a, 0x53,							/* SHIFT */
	0x2c, 0x2a,							/* Z */
	0x2d, 0x2b,							/* X */
	0x2e, 0x2c,							/* C */
	0x2f, 0x2d,							/* V */
	0x30, 0x2e,							/* B */
	0x31, 0x2f,							/* N */
	0x32, 0x30,							/* M */
	0x33, 0x31,							/* , */
	0x34, 0x32,							/* . */
	0x35, 0x33,							/* / */
	0x73, 0x34,							/* _ */
	0x36, 0x54,							/* ESHIFT */

	0x3a, 0x55,							/* CAP (CTRL) */
	0x7b, 0x56,							/* GRAPH (ϊ) */
	0x39, 0x57,							/* SPACE (SPACE) */
	0x79, 0x58,							/* SPACE (ϊ) */
	0x70, 0x35,							/* ESPACE (Ђ炪) */
	0x1d+0x80, 0x5a,					/*  (ECTRL) */

	0x52+0x80, 0x48,					/* INS (Insert) */
	0x48+0x80, 0x4d,					/*  */
	0x53+0x80, 0x4b,					/* DEL (Delete) */
	0x4b+0x80, 0x4f,					/*  */
	0x50+0x80, 0x50,					/*  */
	0x4d+0x80, 0x51,					/*  */

	0x47+0x80, 0x49,					/* EL (Home) */
	0x49+0x80, 0x4a,					/* CLS (Page Up) */
	0x4f+0x80, 0x4c,					/* DUP (End) */
	0x51+0x80, 0x4e,					/* HOME (Page Down) */

	0x52, 0x46,							/* Tenkey 0 */
	0x53, 0x32,							/* Tenkey . */
	0x4f, 0x42,							/* Tenkey 1 */
	0x50, 0x43,							/* Tenkey 2 */
	0x51, 0x44,							/* Tenkey 3 */
	0x1c+0x80, 0x45,					/* Tenkey CR */
	0x4b, 0x3e,							/* Tenkey 4 */
	0x4c, 0x3f,							/* Tenkey 5 */
	0x4d, 0x40,							/* Tenkey 6 */
	0x47, 0x3a,							/* Tenkey 7 */
	0x48, 0x3b,							/* Tenkey 8 */
	0x49, 0x3c							/* Tenkey 9 */
};

/*
 *	Win16 OEMR[hFM7 R[h
 *	PC-9801L[{[hpR[hΏƕ\
 */
static BYTE pc98_key_table[] = {
	0x60, 0x5c,							/* BREAK (STOP)*/

	0x62, 0x5d,							/* F1 */
	0x63, 0x5e,							/* F2 */
	0x64, 0x5f,							/* F3 */
	0x65, 0x60,							/* F4 */
	0x66, 0x61,							/* F5 */
	0x67, 0x62,							/* F6 */
	0x68, 0x63,							/* F7 */
	0x69, 0x64,							/* F8 */
	0x6a, 0x65,							/* F9 */
	0x6b, 0x66,							/* F10 */

	0x00, 0x01,							/* ESC */
	0x01, 0x02,							/* 1 */
	0x02, 0x03,							/* 2 */
	0x03, 0x04,							/* 3 */
	0x04, 0x05,							/* 4 */
	0x05, 0x06,							/* 5 */
	0x06, 0x07,							/* 6 */
	0x07, 0x08,							/* 7 */
	0x08, 0x09,							/* 8 */
	0x09, 0x0a,							/* 9 */
	0x0a, 0x0b,							/* 0 */
	0x0b, 0x0c,							/* - */
	0x0c, 0x0d,							/* ^ */
	0x0d, 0x0e,							/* \ */
	0x0e, 0x0f,							/* BS */

	0x0f, 0x10,							/* TAB */
	0x10, 0x11,							/* Q */
	0x11, 0x12,							/* W */
	0x12, 0x13,							/* E */
	0x13, 0x14,							/* R */
	0x14, 0x15,							/* T */
	0x15, 0x16,							/* Y */
	0x16, 0x17,							/* U */
	0x17, 0x18,							/* I */
	0x18, 0x19,							/* O */
	0x19, 0x1a,							/* P */
	0x1a, 0x1b,							/* @ */
	0x1b, 0x1c,							/* [ */
	0x1c, 0x1d,							/* CR */

	0x74, 0x52,							/* CTRL */
	0x1d, 0x1e,							/* A */
	0x1e, 0x1f,							/* S */
	0x1f, 0x20,							/* D */
	0x20, 0x21,							/* F */
	0x21, 0x22,							/* G */
	0x22, 0x23,							/* H */
	0x23, 0x24,							/* J */
	0x24, 0x25,							/* K */
	0x25, 0x26,							/* L */
	0x26, 0x27,							/* ; */
	0x27, 0x28,							/* : */
	0x28, 0x29,							/* ] */

	0x70, 0x53,							/* SHIFT */
	0x29, 0x2a,							/* Z */
	0x2a, 0x2b,							/* X */
	0x2b, 0x2c,							/* C */
	0x2c, 0x2d,							/* V */
	0x2d, 0x2e,							/* B */
	0x2e, 0x2f,							/* N */
	0x2f, 0x30,							/* M */
	0x30, 0x31,							/* , */
	0x31, 0x32,							/* . */
	0x32, 0x33,							/* / */
	0x33, 0x34,							/* _ */
	0x70, 0x54,							/* ESHIFT */

	0x71, 0x55,							/* CAP [Up Only] */
	0x51, 0x56,							/* GRAPH (NFER) */
	0x34, 0x35,							/* SPACE (SPACE) */
	0x72, 0x5a,							/*  (Ji) */

	0x38, 0x48,							/* INS */
	0x3a, 0x4d,							/*  */
	0x39, 0x4b,							/* DEL */
	0x3b, 0x4f,							/*  */
	0x3d, 0x50,							/*  */
	0x3c, 0x51,							/*  */

	0x36, 0x49,							/* EL (ROLL UP) */
	0x37, 0x4a,							/* CLS (ROLL DOWN) */

	0x4e, 0x46,							/* Tenkey 0 */
	0x4f, 0x2e,							/* Tenkey . */
	0x4a, 0x42,							/* Tenkey 1 */
	0x4b, 0x43,							/* Tenkey 2 */
	0x4c, 0x44,							/* Tenkey 3 */
	0x4d, 0x45,							/* Tenkey CR */
	0x46, 0x3e,							/* Tenkey 4 */
	0x47, 0x3f,							/* Tenkey 5 */
	0x48, 0x40,							/* Tenkey 6 */
	0x42, 0x3a,							/* Tenkey 7 */
	0x43, 0x3b,							/* Tenkey 8 */
	0x44, 0x3c							/* Tenkey 9 */
};

/*
 *	Win16 OEMR[hFM-7 R[hϊ
 */
static BYTE win_to_fm7(BYTE oem)
{
	int i;

	switch (pMainWindow->m_nKeyType) {
		// {106
		case 0:
			for (i=0; i<(sizeof(jp106_key_table) / 2); i++) {
				if (oem == jp106_key_table[i * 2]) {
					return jp106_key_table[i * 2 + 1];
				}
			}
			return 0;
		// NEC PC-98
		case 1:
			for (i=0; i<(sizeof(pc98_key_table) / 2); i++) {
				if (oem == pc98_key_table[i * 2]) {
					return pc98_key_table[i * 2 + 1];
				}
			}
			return 0;
		default:
			break;
	}

	// FUJITSU FM-TOWNS
	switch (oem) {
		// BREAK
		case 0x7c:
			return 0x5c;
		// 
		case 0x59:
			return 0x5a;
		// GRAPH()
		case 0x72:
			return 0x56;
		// .(eL[)
		case 0xca:
			return 0x47;
		// EL
		case 0xeb:
			return 0x49;
		// CLS
		case 0xec:
			return 0x4a;
		// DUP
		case 0x6e:
			return 0x4c;
	}

	if (oem <= 0x66) {
		return oem;
	}

	return 0;
}

/*
 *	L[
 */
void TXM7Window::EvKeyDown(UINT nChar, UINT nRepCount, UINT nFlags)
{
	BYTE fm7;

#ifdef KEYDISP
	char buf[128];
	sprintf(buf, "XM7 KeyDown nChar:%04X nFlags:%04X", nChar, nFlags);
	SetWindowText(buf);
#endif

	// s[g`FbN
	if ((m_nFlags & 0x1ff) == (nFlags & 0x1ff)) {
		return;
	}

	// J[\΍
	if (m_nKeyType == 0) {
		if ((nChar >= 0x21) && (nChar <= 0x2e)) {
			nFlags |= 0x100;
		}
	}

	// f[^L
	m_nChar = nChar;
	m_nFlags = nFlags;

	if (nFlags & 0x0100) {
		fm7 = win_to_fm7(nFlags | 0x80);
	}
	else {
		fm7 = win_to_fm7(nFlags);
	}

	if (fm7 != 0) {
		keyboard_make(fm7);
	}

	// 106L[{[h & [/S]́AɃ[XƂɂ
	if ((m_nKeyType == 0) && (nFlags == 0x29)) {
		keyboard_break(fm7);
	}

	// GUIɓ鑀
	if (m_nKeyType == 1) {
		if ((nFlags & 0xff) == 0x35) {
			gui_start();
		}
	}
	else {
		if (nChar == VK_F12) {
			gui_start();
		}
	}
}

/*
 *	L[
 */
void TXM7Window::EvKeyUp(UINT nChar, UINT nRepCount, UINT nFlags)
{
	BYTE fm7;

#ifdef KEYDISP
	char buf[128];
	sprintf(buf, "XM7 KeyUp nChar:%04X nFlags:%04X", nChar, nFlags);
	SetWindowText(buf);
#endif

	// f[^L
	m_nChar = 0;
	m_nFlags = 0xffff;

	if (nFlags & 0x0100) {
		fm7 = win_to_fm7(nFlags | 0x80);
	}
	else {
		fm7 = win_to_fm7(nFlags);
	}

	if (fm7 != 0) {
		// PC98[CAPS]͗O
		if ((m_nKeyType == 1) && (fm7 == 0x55)) {
			keyboard_make(fm7);
			keyboard_break(fm7);
		}
		else {
			keyboard_break(fm7);
		}
	}
}

/*
 *	VXeL[
 */
void TXM7Window::EvSysKeyDown(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	BYTE fm7;

#ifdef KEYDISP
	char buf[128];
	sprintf(buf, "XM7 SysDown nChar:%04X nFlags:%04X", nChar, nFlags);
	SetWindowText(buf);
#endif

	// ALT͗v`FbN
	if (nFlags & 0x2000) {
		TFrameWindow::EvSysKeyDown(nChar, nRepCnt, nFlags);
		return;
	}

	// f[^ϊ
	if (nFlags & 0x0100) {
		fm7 = win_to_fm7(nFlags | 0x80);
	}
	else {
		fm7 = win_to_fm7(nFlags);
	}

	// ϊłȂ΁AʃNX֓n
	if (fm7 == 0) {
		TFrameWindow::EvSysKeyDown(nChar, nRepCnt, nFlags);
		return;
	}

	// ʏL[Ɠ
	EvKeyDown(nChar, nRepCnt, nFlags);
}

/*
 *	VXeL[
 */
void TXM7Window::EvSysKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	BYTE fm7;

#ifdef KEYDISP
	char buf[128];
	sprintf(buf, "XM7 SysUp nChar:%04X nFlags:%04X", nChar, nFlags);
	SetWindowText(buf);
#endif

	// ALT͗v`FbN
	if (nFlags & 0x2000) {
		TFrameWindow::EvSysKeyUp(nChar, nRepCnt, nFlags);
		return;
	}

	// f[^ϊ
	if (nFlags & 0x0100) {
		fm7 = win_to_fm7(nFlags | 0x80);
	}
	else {
		fm7 = win_to_fm7(nFlags);
	}

	// ϊłȂ΁AʃNX֓n
	if (fm7 == 0) {
		TFrameWindow::EvSysKeyUp(nChar, nRepCnt, nFlags);
		return;
	}

	// ʏL[Ɠ
	EvKeyUp(nChar, nRepCnt, nFlags);
}

#endif	/* _WIN16 */
