/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 ]
 */

#ifdef _WIN32
#ifndef _win_h_
#define _win_h_

#include <afxext.h>
#include <mmsystem.h>
#include <ddraw.h>
#include <dinput.h>
#include <dsound.h>
#include "win_view.h"

/*
 *	NX錾
 */
class OPN;

/*-[ AvP[V IuWFNg ]----------------------------------------*/

/*
 *	AvP[V NX
 */
class CXM7App : public CWinApp
{
public :
	CXM7App();							// RXgN^
	virtual BOOL InitInstance();		// AvP[V
};

/*-[ t[EChE ]---------------------------------------------------*/

/*
 *	t[EChE NX
 */
class CXM7Wnd : public CFrameWnd
{
public:
	// S
	CXM7Wnd();							// RXgN^
	virtual BOOL OnCmdMsg(UINT nID, int nCode, void* pExtra,
						  AFX_CMDHANDLERINFO* pHandlerInfo);
										// R}h [eBO
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
										// EChE\z
	afx_msg void OnClose();				// N[Y
	afx_msg void OnDestroy();			// EChEj
	afx_msg void OnActivate(UINT nState, CWnd *pWndOther, BOOL bMinimized);
										// ANeBuEANeBu
	afx_msg void OnEnterMenuLoop(BOOL bTrackFlag);
										// j[[vɓ
	afx_msg LONG OnEnterSizeMove(UINT wParam, LONG lParam);
										// ړ[hɓ
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
										// VXeR}hs

	// Filej[
	afx_msg void OnOpen();				// File-Open
	afx_msg void OnSave();				// File-Save
	afx_msg void OnSaveAs();			// File-Save As
	afx_msg void OnReset();				// File-Reset
	afx_msg void OnBasBoot();			// File-BASIC Mode
	afx_msg void OnBasBootUI(CCmdUI *pCmdUI);
	afx_msg void OnDosBoot();			// File-DOS Mode
	afx_msg void OnDosBootUI(CCmdUI *pCmdUI);
	afx_msg void OnExit();				// File-Exit

	// Drivej[
	afx_msg void OnDrv0Open();			// Drive0-Open
	afx_msg void OnDrv1Open();			// Drive1-Open
	afx_msg void OnDrvBoth();			// Drive-Open Both Drives
	afx_msg void OnDrv0Eject();			// Drive0-Eject
	afx_msg void OnDrv0Write();			// Drive0-Write Protect
	afx_msg void OnDrv0WriteUI(CCmdUI *pCmdUI);
	afx_msg void OnDrv1Eject();			// Drive1-Eject
	afx_msg void OnDrv1Write();			// Drive1-Write Protect
	afx_msg void OnDrv1WriteUI(CCmdUI *pCmdUI);

	// Tapej[
	afx_msg void OnTapeOpen();			// Tape-Open
	afx_msg void OnTapeEject();			// Tape-Eject
	afx_msg void OnTapeRew();			// Tape-Rew
	afx_msg void OnTapeRewUI(CCmdUI *pCmdUI);
	afx_msg void OnTapeFF();			// Tape-FF
	afx_msg void OnTapeFFUI(CCmdUI *pCmdUI);
	afx_msg void OnTapeRec();			// Tape-Rec
	afx_msg void OnTapeRecUI(CCmdUI *pCmdUI);

	// Viewj[
	afx_msg void OnRegMain();			// View-Register-Main
	afx_msg void OnRegMainUI(CCmdUI *pCmdUI);
	afx_msg void OnRegSub();			// View-Register-Sub
	afx_msg void OnRegSubUI(CCmdUI *pCmdUI);
	afx_msg void OnDisMain();			// View-DisAssemble-Main
	afx_msg void OnDisMainUI(CCmdUI *pCmdUI);
	afx_msg void OnDisSub();			// View-DisAssemble-Sub
	afx_msg void OnDisSubUI(CCmdUI *pCmdUI);
	afx_msg void OnDumpMain();			// View-Dump-Main
	afx_msg void OnDumpMainUI(CCmdUI *pCmdUI);
	afx_msg void OnDumpSub();			// View-Dump-Sub
	afx_msg void OnDumpSubUI(CCmdUI *pCmdUI);
	afx_msg void OnIntMain();			// View-Int-Main
	afx_msg void OnIntMainUI(CCmdUI *pCmdUI);
	afx_msg void OnIntSub();			// View-Int-Sub
	afx_msg void OnIntSubUI(CCmdUI *pCmdUI);
	afx_msg void OnBreakp();			// View-Break Point
	afx_msg void OnBreakpUI(CCmdUI *pCmdUI);
	afx_msg void OnBASICROM();			// View-BASIC ROM
	afx_msg void OnBASICROMUI(CCmdUI *pCmdUI);
	afx_msg void OnTTLPal();			// View-Digital Palette
	afx_msg void OnTTLPalUI(CCmdUI *pCmdUI);
	afx_msg void OnMulti();				// View-Multi Page
	afx_msg void OnMultiUI(CCmdUI *pCmdUI);
	afx_msg void OnKnj();				// View-Kanji ROM
	afx_msg void OnKnjUI(CCmdUI *pCmdUI);
	afx_msg void OnFDC();				// View-FDC
	afx_msg void OnFDCUI(CCmdUI *pCmdUI);
	afx_msg void OnTape();				// View-Casette Tape
	afx_msg void OnTapeUI(CCmdUI *pCmdUI);
	afx_msg void OnLP();				// View-Line Printer
	afx_msg void OnLPUI(CCmdUI *pCmdUI);
	afx_msg void OnOPN();				// View-OPN
	afx_msg void OnOPNUI(CCmdUI *pCmdUI);
	afx_msg void OnSubCtrl();			// View-Sub Control
	afx_msg void OnSubCtrlUI(CCmdUI *pCmdUI);
	afx_msg void OnKbd();				// View-Keyboard
	afx_msg void OnKbdUI(CCmdUI *pCmdUI);
	afx_msg void OnCRT();				// View-CRT Register
	afx_msg void OnCRTUI(CCmdUI *pCmdUI);
	afx_msg void OnRefresh();			// View-Refresh
	afx_msg void OnSync();				// View-Sync
	afx_msg void OnSyncUI(CCmdUI *pCmdUI);
	afx_msg void OnFullScreen();		// View-Full Screen
	afx_msg void OnFullScreenUI(CCmdUI *pCmdUI);

	// Debugj[
	afx_msg void OnRun();				// Debug-Run
	afx_msg void OnRunUI(CCmdUI *pCmdUI);
	afx_msg void OnBreak();				// Debug-Break
	afx_msg void OnBreakUI(CCmdUI *pCmdUI);
	afx_msg void OnTrace();				// Debug-Trace
	afx_msg void OnTraceUI(CCmdUI *pCmdUI);
	afx_msg void OnJumpMain();			// Debug-Jump-Main
	afx_msg void OnJumpSub();			// Debug-Jump-Sub

	// Toolsj[
	afx_msg void OnOption();			// Tools-Option
	afx_msg void OnCapture();			// Tools-Capture Screen
	afx_msg void OnMakeDisk();			// Tools-Make Blank Disk
	afx_msg void OnMakeTape();			// Tools-Make Blank Tape
	afx_msg void OnVFDtoD77();			// Tools-Convert VFD to D77
	afx_msg void On2DtoD77();			// Tools-Convert 2D to D77
	afx_msg void OnVTPtoT77();			// Tools-Convert VTP to T77

	// Windowj[
	afx_msg void OnViewAll();			// Window-View All
	afx_msg void OnCloseAll();			// Window-Close All
	afx_msg void OnIconic();			// Window-Iconic
	afx_msg void OnRestore();			// Window-Restore
	afx_msg void OnArrangeIcon();		// Window-Arrange Icon

	// Helpj[
	afx_msg void OnAbout();				// Help-About

	// `ChEChEǗ
	void UpWndMenu();					// EChEj[XV
	CXM7RegWnd *m_pRegMainWnd;			// CWX^ EChE
	CXM7RegWnd *m_pRegSubWnd;			// TuWX^ EChE
	CXM7DisWnd *m_pDisMainWnd;			// CtAZu EChE
	CXM7DisWnd *m_pDisSubWnd;			// TutAZu EChE
	CXM7DumpWnd *m_pDumpMainWnd;		// C_v EChE
	CXM7DumpWnd *m_pDumpSubWnd;			// Tu_v EChE
	CXM7IntWnd *m_pIntMainWnd;			// C荞 EChE
	CXM7IntWnd *m_pIntSubWnd;			// Tu荞 EChE
	CXM7BreakWnd *m_pBreakWnd;			// u[N|Cg EChE
	CXM7VerWnd *m_pVerWnd;				// ROMo[W EChE
	CXM7TTLPalWnd *m_pTTLPalWnd;		// TTLpbg EChE
	CXM7MultiWnd *m_pMultiWnd;			// }`y[W EChE
	CXM7FDCWnd *m_pFDCWnd;				// FDC EChE
	CXM7KnjWnd *m_pKnjWnd;				// ROM EChE
	CXM7TapeWnd *m_pTapeWnd;			// JZbge[v EChE
	CXM7LPWnd *m_pLPWnd;				// Cv^ EChE
	CXM7OPNWnd *m_pOPNWnd;				// OPN EChE
	CXM7SubWnd *m_pSubWnd;				// TuCPURg[ EChE
	CXM7KbdWnd *m_pKbdWnd;				// L[{[h EChE
	CXM7CRTWnd *m_pCRTWnd;				// CRTWX^ EChE
	CWnd** m_ViewWndList[32];			// r[EChEXg
	CWnd* m_ActiveWndList[32];			// EChEXg(Windowj[p)

	// t[EChE
	BOOL m_bMenuFlag;					// j[stO

	// `
	afx_msg void OnPaint();				// `
	afx_msg BOOL OnEraseBkgnd(CDC *pDC);// wi
	BYTE m_Palette[8];					// pbgC[W
	BOOL m_bFullDraw;					// Sʕ`tO
	int m_nFirstLine;					// `JnC
	int m_nLastLine;					// `IC
	BOOL m_bPalFlag;					// pbgύXtO

	// XPW[
	afx_msg LONG MainLoop(UINT wParam, LONG lParam);
										// C[v
	static void CALLBACK TimerFunc(UINT wTimerID, UINT wMsg, DWORD dwUser,
			DWORD dw1, DWORD dw2);		// }`fBA^C}[
	DWORD m_dwTimerCount;				// ^C}[ԊǗ

	// TEh
	void PlaySnd();						// TEhtJn
	void StopSnd();						// TEht~
	OPN *m_pOPN;						// OPNfoCX
	BOOL m_bSndOPN;						// OPNLtO
	BOOL m_bSndPSG;						// PSGLtO
	BOOL m_bSndBEEP;					// BEEPLtO

	// L[{[hEWCXeBbN
	BYTE m_KbdMap[256];					// L[{[h}bv
	BYTE m_joydat[2];					// WCXeBbNf[^

private:
	// t[EChE
	void ParseCommandLine();			// R}hC
	void OnDrvOpen(UINT drive);			// fBXNI[v
	void OnDrvWrite(UINT drive);		// CgveNg
	void OnDrvWriteUI(UINT drive, CCmdUI *pCmdUI);
	void UpDriveMenu(UINT drive);		// hCuj[XV
	void UpTapeMenu();					// e[vj[XV
	CString m_VMFile;					// VMt@Cl[
	BOOL m_bActive;						// ANeBx[gtO
	BOOL m_bClose;						// N[YvtO
	UINT m_nErrorCode;					// G[R[h
	BOOL m_bMouseCursor;				// }EXJ[\tO

	// ݒ
	void LoadConfig();					// ݒ胍[h
	void SaveConfig();					// ݒZ[u

	// `
	void OnDraw(CDC *pDC);				// `
	void UpdateCaption();				// LvVXV
	void UpdateBars();					// Rg[o[XV
	CToolBar m_ToolBar;					// c[o[
	CStatusBar m_StatusBar;				// Xe[^Xo[
	UINT m_nDrawCount;					// `JE^
	DWORD m_dwDrawTime;					// t[[gǗ
	UINT m_nFrameRate;					// t[[g
	BOOL m_bSyncFlag;					// EChEtO
	BOOL m_bCaptionFlag;				// LvVXVv

	// XPW[
	void InitSch();						// XPW[
	BOOL SelectSch();					// XPW[I
	void CleanSch();					// XPW[I
	void ProcessVM();					// 10mss
	UINT m_nNMICount;					// NMIJE^
	UINT m_nTimerID;					// ^C}[ID

	// GDI(4bpp)
	void InitGDI4();					// GDI(4bpp)
	BOOL SelectGDI4();					// GDI(4bpp)I
	void CleanGDI4();					// GDI(4bpp)I
	void RenderGDI4(int first, int end);// GDI(4bpp)_O
	void DrawGDI4(CDC *pDC);			// GDI(4bpp)`
	BYTE *m_pBits4;						// rbg}bvf[^
	HBITMAP m_hBitmap4;					// rbg}bvnh

	// DirectDraw(8bpp)
	void InitDD8();						// DirectDraw(8bpp)
	BOOL SelectDD8();					// DirectDraw(8bpp)I
	void CleanDD8();					// DirectDraw(8bpp)I
	void RenderDD8(LPVOID lpSurface, LONG lPitch, int first, int end);
										// DirectDraw(8bpp)_O
	void DrawDD8();						// DirectDraw(8bpp)`
	LPDIRECTDRAW2 m_lpdd2;				// IDirectDraw2IuWFNg
	LPDIRECTDRAWSURFACE m_lpdds[2];		// IDirectDrawSurface3
	LPDIRECTDRAWPALETTE m_lpddp;		// IDirectDrawPalette
	LPDIRECTDRAWCLIPPER m_lpddc;		// IDirectDrawClipper
	CRect m_ddrect;						// EChERect

	// L[{[hEWCXeBbN
	void InitKbd();						// L[{[h
	BOOL SelectKbd();					// L[{[hI
	void CleanKbd();					// L[{[hI
	BYTE ConvKbd(BYTE);					// L[{[hf[^ϊ
	void PollKbd();						// L[{[h |[O
	void PollJoy();						// WCXeBbN |[O
	LPDIRECTINPUT m_lpdi;				// DirectInputIuWFNg
	LPDIRECTINPUTDEVICE m_lpkbd;		// DirectInputDevice(L[{[h)
	BOOL m_bKbd98;						// PC-98L[{[h
	BOOL m_bKbdReal;					// ^A^CL[XL
	BOOL m_bKbdCap;						// CAP-CTRLւ
	DWORD m_dwJoyTime;					// WCXeBbN擾
	DWORD m_dwJoyBlank;					// WCXeBbNPoll
	BOOL m_bJoySwap;					// WCXeBbN{^

	// TEh
	void InitSnd();						// TEh
	BOOL SelectSnd(UINT rate, UINT tick, UINT ms);
										// TEhI
	void CleanSnd();					// TEhI
	void ProcessSnd(BOOL zeroflag);		// TEh莞
	void AddSnd(BOOL flag, BOOL zeroflag);
										// TEhTu
	void BeepSnd(int *buf, int samples);// BEEP
	LPDIRECTSOUND m_lpds;				// DirectSoundIuWFNg
	LPDIRECTSOUNDBUFFER m_lpdsp;		// DirectSoundBuffer(vC})
	LPDIRECTSOUNDBUFFER m_lpdsb;		// DirectSoundBuffer(ZJ_)
	UINT m_sndrate;						// TvO[g
	UINT m_sndtick;						// ̃obt@t(ms)
	UINT m_sndms;						// obt@ǉԊu(ms)
	UINT m_sndcount;					// obt@ǉJE^
	UINT m_sndsize;						// obt@TCY
	BOOL m_sndbank;						// oNtO
	WORD *m_lpsbuf;						// TEh쐬obt@
	DWORD *m_lpstmp;					// TEhꎞobt@
	UINT m_beepcount;					// BEEPJE^

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ O[oϐ ]-------------------------------------------------------*/

extern CXM7Wnd *pMainWnd;

#endif	/* _win_h_ */
#endif	/* _WIN32 */
