/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 C ]
 */

#ifdef _WIN32

#include <afxwin.h>
#include <afxext.h>
#include <imm.h>
#include "xm7.h"
#include "win_view.h"
#include "win.h"
#include "resource.h"
#include "fdc.h"
#include "multipag.h"
#include "tapelp.h"

/*-[ O[o ]-----------------------------------------------------------*/

/*
 *	AvP[VIuWFNg 
 */
CXM7App XM7App;
CXM7Wnd *pMainWnd;

/*-[ AvP[V IuWFNg ]----------------------------------------*/

/*
 *	RXgN^
 */
CXM7App::CXM7App() : CWinApp()
{
}

/*
 *	AvP[V CX^X
 */
BOOL CXM7App::InitInstance()
{
	// WXgGgݒ
	SetRegistryKey("PI");

	// CEChE쐬
	m_pMainWnd = (CWnd*)new CXM7Wnd;
	m_pMainWnd->ShowWindow(m_nCmdShow);
	m_pMainWnd->UpdateWindow();

	return TRUE;
}

/*-[ t[EChE ]---------------------------------------------------*/

/*
 *	bZ[W }bv
 */
BEGIN_MESSAGE_MAP(CXM7Wnd, CFrameWnd)
	// S
	ON_WM_CREATE()
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_WM_ACTIVATE()
	ON_WM_ENTERMENULOOP()
	ON_MESSAGE(WM_ENTERSIZEMOVE, OnEnterSizeMove)
	ON_WM_SYSCOMMAND()
	ON_MESSAGE(WM_USER, MainLoop)

	// `
	ON_WM_ERASEBKGND()
	ON_WM_PAINT()

	// Filej[
	ON_COMMAND(IDM_OPENSTATE, OnOpen)
	ON_COMMAND(IDM_SAVESTATE, OnSave)
	ON_COMMAND(IDM_SAVEASSTATE, OnSaveAs)
	ON_COMMAND(IDM_RESET, OnReset)
	ON_COMMAND(IDM_BASBOOT, OnBasBoot)
	ON_UPDATE_COMMAND_UI(IDM_BASBOOT, OnBasBootUI)
	ON_COMMAND(IDM_DOSBOOT, OnDosBoot)
	ON_UPDATE_COMMAND_UI(IDM_DOSBOOT, OnDosBootUI)
	ON_COMMAND(IDM_EXIT, OnExit)

	// Drivej[
	ON_COMMAND(IDM_DRV0OPEN, OnDrv0Open)
	ON_COMMAND(IDM_DRV1OPEN, OnDrv1Open)
	ON_COMMAND(IDM_DRVBOTH, OnDrvBoth)
	ON_COMMAND(IDM_DRV0EJECT, OnDrv0Eject)
	ON_COMMAND(IDM_DRV1EJECT, OnDrv1Eject)
	ON_COMMAND(IDM_DRV0WRITE, OnDrv0Write)
	ON_UPDATE_COMMAND_UI(IDM_DRV0WRITE, OnDrv0WriteUI)
	ON_COMMAND(IDM_DRV1WRITE, OnDrv1Write)
	ON_UPDATE_COMMAND_UI(IDM_DRV1WRITE, OnDrv1WriteUI)

	// Tapej[
	ON_COMMAND(IDM_TAPEOPEN, OnTapeOpen)
	ON_COMMAND(IDM_TAPEEJECT, OnTapeEject)
	ON_COMMAND(IDM_TAPEREW, OnTapeRew)
	ON_UPDATE_COMMAND_UI(IDM_TAPEREW, OnTapeRewUI)
	ON_COMMAND(IDM_TAPEFF, OnTapeFF)
	ON_UPDATE_COMMAND_UI(IDM_TAPEFF, OnTapeFFUI)
	ON_COMMAND(IDM_TAPEREC, OnTapeRec)
	ON_UPDATE_COMMAND_UI(IDM_TAPEREC, OnTapeRecUI)

	// Viewj[
	ON_COMMAND(IDM_REGMAIN, OnRegMain)
	ON_UPDATE_COMMAND_UI(IDM_REGMAIN, OnRegMainUI)
	ON_COMMAND(IDM_REGSUB, OnRegSub)
	ON_UPDATE_COMMAND_UI(IDM_REGSUB, OnRegSubUI)
	ON_COMMAND(IDM_DISMAIN, OnDisMain)
	ON_UPDATE_COMMAND_UI(IDM_DISMAIN, OnDisMainUI)
	ON_COMMAND(IDM_DISSUB, OnDisSub)
	ON_UPDATE_COMMAND_UI(IDM_DISSUB, OnDisSubUI)
	ON_COMMAND(IDM_DUMPMAIN, OnDumpMain)
	ON_UPDATE_COMMAND_UI(IDM_DUMPMAIN, OnDumpMainUI)
	ON_COMMAND(IDM_DUMPSUB, OnDumpSub)
	ON_UPDATE_COMMAND_UI(IDM_DUMPSUB, OnDumpSubUI)
	ON_COMMAND(IDM_INTMAIN, OnIntMain)
	ON_UPDATE_COMMAND_UI(IDM_INTMAIN, OnIntMainUI)
	ON_COMMAND(IDM_INTSUB, OnIntSub)
	ON_UPDATE_COMMAND_UI(IDM_INTSUB, OnIntSubUI)
	ON_COMMAND(IDM_BREAKP, OnBreakp)
	ON_UPDATE_COMMAND_UI(IDM_BREAKP, OnBreakpUI)
	ON_COMMAND(IDM_ROMVER, OnBASICROM)
	ON_UPDATE_COMMAND_UI(IDM_ROMVER, OnBASICROMUI)
	ON_COMMAND(IDM_TTLPALET, OnTTLPal)
	ON_UPDATE_COMMAND_UI(IDM_TTLPALET, OnTTLPalUI)
	ON_COMMAND(IDM_MULTI, OnMulti)
	ON_UPDATE_COMMAND_UI(IDM_MULTI, OnMultiUI)
	ON_COMMAND(IDM_FDC, OnFDC)
	ON_UPDATE_COMMAND_UI(IDM_FDC, OnFDCUI)
	ON_COMMAND(IDM_KANJI, OnKnj)
	ON_UPDATE_COMMAND_UI(IDM_KANJI, OnKnjUI)
	ON_COMMAND(IDM_TAPE, OnTape)
	ON_UPDATE_COMMAND_UI(IDM_TAPE, OnTapeUI)
	ON_COMMAND(IDM_LP, OnLP)
	ON_UPDATE_COMMAND_UI(IDM_LP, OnLPUI)
	ON_COMMAND(IDM_OPN, OnOPN)
	ON_UPDATE_COMMAND_UI(IDM_OPN, OnOPNUI)
	ON_COMMAND(IDM_SUBCTRL, OnSubCtrl)
	ON_UPDATE_COMMAND_UI(IDM_SUBCTRL, OnSubCtrlUI)
	ON_COMMAND(IDM_KEYBOARD, OnKbd)
	ON_UPDATE_COMMAND_UI(IDM_KEYBOARD, OnKbdUI)
	ON_COMMAND(IDM_CRT, OnCRT)
	ON_UPDATE_COMMAND_UI(IDM_CRT, OnCRTUI)
	ON_COMMAND(IDM_REFRESH, OnRefresh)
	ON_COMMAND(IDM_SYNC, OnSync)
	ON_UPDATE_COMMAND_UI(IDM_SYNC, OnSyncUI)
	ON_COMMAND(IDM_FULLSCREEN, OnFullScreen)
	ON_UPDATE_COMMAND_UI(IDM_FULLSCREEN, OnFullScreenUI)

	// Debugj[
	ON_COMMAND(IDM_RUN, OnRun)
	ON_UPDATE_COMMAND_UI(IDM_RUN, OnRunUI)
	ON_COMMAND(IDM_BREAK, OnBreak)
	ON_UPDATE_COMMAND_UI(IDM_BREAK, OnBreakUI)
	ON_COMMAND(IDM_STEPIN, OnTrace)
	ON_UPDATE_COMMAND_UI(IDM_STEPIN, OnTraceUI)
	ON_COMMAND(IDM_JUMPMAIN, OnJumpMain)
	ON_COMMAND(IDM_JUMPSUB, OnJumpSub)

	// Toolsj[
	ON_COMMAND(IDM_OPTION, OnOption)
	ON_COMMAND(IDM_CAPTURE, OnCapture)
	ON_COMMAND(IDM_MAKEDISK, OnMakeDisk)
	ON_COMMAND(IDM_MAKETAPE, OnMakeTape)
	ON_COMMAND(IDM_VFD2D77, OnVFDtoD77)
	ON_COMMAND(IDM_2D2D77, On2DtoD77)
	ON_COMMAND(IDM_VTP2T77, OnVTPtoT77)

	// Windowj[
	ON_COMMAND(IDM_VIEW, OnViewAll)
	ON_COMMAND(IDM_CLOSE, OnCloseAll)
	ON_COMMAND(IDM_ICONIC, OnIconic)
	ON_COMMAND(IDM_RESTORE, OnRestore)
	ON_COMMAND(IDM_ARRANGEICON, OnArrangeIcon)

	// Helpj[
	ON_COMMAND(IDM_ABOUT, OnAbout)
END_MESSAGE_MAP()

/*
 *	\z
 */
CXM7Wnd::CXM7Wnd() : CFrameWnd()
{
	CRect crect;
	CRect wrect;
	int i;
	BOOL flag;
	CSize size;

	// tOTRUE
	flag = TRUE;

	// EChE쐬
	Create(NULL, "XM7",
		WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_BORDER | WS_MINIMIZEBOX |
		WS_CLIPCHILDREN,
		rectDefault, NULL, MAKEINTRESOURCE(IDR_MAINMENU), 0, NULL);
	LoadAccelTable(MAKEINTRESOURCE(IDR_MAINACCEL));
	pMainWnd = this;

	// NCAgTCY640~400hbgɐݒ
	GetWindowRect(&wrect);
	GetClientRect(&crect);
	size = m_StatusBar.CalcFixedLayout(FALSE, TRUE);
	wrect.right -= (crect.right - crect.left);
	wrect.right += 640;
	wrect.bottom -= (crect.bottom - crect.top);
	wrect.bottom += 400 + size.cy;
	MoveWindow(&wrect, FALSE);

	// ACRݒ
	SetIcon(AfxGetApp()->LoadIcon(MAKEINTRESOURCE(IDI_XM7ICON)), TRUE);
	SetIcon(AfxGetApp()->LoadIcon(MAKEINTRESOURCE(IDI_XM7ICON)), FALSE);

	// r[Xg
	memset(m_ViewWndList, 0, sizeof(m_ViewWndList));
	memset(m_ActiveWndList, 0, sizeof(m_ActiveWndList));
	m_ViewWndList[0] = (CWnd**)&m_pRegMainWnd;
	m_ViewWndList[1] = (CWnd**)&m_pRegSubWnd;
	m_ViewWndList[2] = (CWnd**)&m_pDisMainWnd;
	m_ViewWndList[3] = (CWnd**)&m_pDisSubWnd;
	m_ViewWndList[4] = (CWnd**)&m_pDumpMainWnd;
	m_ViewWndList[5] = (CWnd**)&m_pDumpSubWnd;
	m_ViewWndList[6] = (CWnd**)&m_pIntMainWnd;
	m_ViewWndList[7] = (CWnd**)&m_pIntSubWnd;
	m_ViewWndList[8] = (CWnd**)&m_pBreakWnd;
	m_ViewWndList[9] = (CWnd**)&m_pVerWnd;
	m_ViewWndList[10] = (CWnd**)&m_pTTLPalWnd;
	m_ViewWndList[11] = (CWnd**)&m_pMultiWnd;
	m_ViewWndList[12] = (CWnd**)&m_pFDCWnd;
	m_ViewWndList[13] = (CWnd**)&m_pKnjWnd;
	m_ViewWndList[14] = (CWnd**)&m_pTapeWnd;
	m_ViewWndList[15] = (CWnd**)&m_pLPWnd;
	m_ViewWndList[16] = (CWnd**)&m_pOPNWnd;
	m_ViewWndList[17] = (CWnd**)&m_pSubWnd;
	m_ViewWndList[18] = (CWnd**)&m_pKbdWnd;
	m_ViewWndList[19] = (CWnd**)&m_pCRTWnd;

	// qEChEtO NA
	for (i=0; i<sizeof(m_ViewWndList)/sizeof(CWnd**); i++) {
		if (m_ViewWndList[i]) {
			*m_ViewWndList[i] = NULL;
		}
	}

	// IME OFF
	::ImmAssociateContext(m_hWnd, NULL);

	// ̑[N(EChE)
	m_bActive = TRUE;
	m_bClose = FALSE;

	// ̑[N(EChESʁA`)
	m_nErrorCode = 0;
	m_nFrameRate = 60;
	m_nDrawCount = 0;
	m_dwDrawTime = 0;
	m_bSyncFlag = TRUE;
	m_bCaptionFlag = FALSE;
	m_bMenuFlag = FALSE;
	m_bMouseCursor = TRUE;
	m_bFullDraw = TRUE;
	m_VMFile = "";

	// R|[lg
	InitGDI4();
	InitDD8();
	InitKbd();
	InitSnd();
	InitSch();

	// ݒǂݍ
	LoadConfig();

	// VXe
	if (!system_init()) {
		m_nErrorCode = 1;
		PostMessage(WM_USER, 0, 0);
		return;
	}

	// R|[lgI
	if (!SelectGDI4()) {
		flag = FALSE;
	}
	if (!SelectKbd()) {
		flag = FALSE;
	}
	if (!SelectSnd(m_sndrate, m_sndtick, 1)) {
		flag = FALSE;
	}
	if (!SelectSch()) {
		flag = FALSE;
	}

	// 󋵃`FbN
	if (!flag) {
		m_nErrorCode = 2;
		PostMessage(WM_USER, 0, 0);
		return;
	}

	// R}hC
	ParseCommandLine();

	// j[
	UpDriveMenu(0);
	UpDriveMenu(1);
	UpTapeMenu();

	// ZbgAVMX^[g
	OnReset();
	OnRun();
	PostMessage(WM_USER, 0, 0);
}

/*
 *	EChE쐬
 */
 int CXM7Wnd::OnCreate(LPCREATESTRUCT lpCreateStruct)
{
	CDC *pDC;
	TEXTMETRIC tm;
	LONG cx;
	static UINT nIndicators[] = {
		ID_SEPARATOR,		// 0:tCoCeLXg
		ID_SEPARATOR,		// 1:hCu1
		ID_SEPARATOR,		// 2:hCu0
		ID_SEPARATOR,		// 3:e[v
		ID_SEPARATOR,		// 4:Zp[^
		ID_SEPARATOR,		// 5:CAP
		ID_SEPARATOR,		// 6:
		ID_SEPARATOR,		// 7:INS
	};

	// {NX
	if (CFrameWnd::OnCreate(lpCreateStruct) == -1) {
		return -1;
	}

	// Xe[^Xo[쐬AeLXggbN𓾂
	m_StatusBar.Create(this, WS_CHILD | WS_VISIBLE | CBRS_BOTTOM | CBRS_BORDER_3D);
	pDC = m_StatusBar.GetDC();
	pDC = GetDC();
	pDC->GetTextMetrics(&tm);
	m_StatusBar.ReleaseDC(pDC);
	ReleaseDC(pDC);
	cx = tm.tmAveCharWidth;

	// 8̃yC쐬
	m_StatusBar.SetIndicators(nIndicators, sizeof(nIndicators) / sizeof(UINT));
	m_StatusBar.SetPaneInfo(1, ID_SEPARATOR, 0, cx * 5);
	m_StatusBar.SetPaneInfo(2, ID_SEPARATOR, 0, cx * 5);
	m_StatusBar.SetPaneInfo(3, ID_SEPARATOR, 0, cx * 4);
	m_StatusBar.SetPaneInfo(4, ID_SEPARATOR, SBPS_NOBORDERS | SBPS_DISABLED, cx);
	m_StatusBar.SetPaneInfo(5, ID_SEPARATOR, 0, cx * 3);
	m_StatusBar.SetPaneInfo(6, ID_SEPARATOR, 0, cx * 3);
	m_StatusBar.SetPaneInfo(7, ID_SEPARATOR, 0, cx * 3);

	return 0;
 }

/*
 *	R}hC
 */
void CXM7Wnd::ParseCommandLine()
{
	if (__argc >= 2) {
		fdc_setdisk(0, __argv[1]);
	}

	if (__argc >= 3) {
		fdc_setdisk(1, __argv[2]);
	}
	else {
		if ((fdc_ready[0] == FDC_TYPE_D77) && (fdc_medias[0] >= 2)) {
			fdc_setdisk(1, __argv[1]);
			fdc_setmedia(1, 1);
		}
	}
}

/*
 *	EChEN[Y
 */
void CXM7Wnd::OnClose()
{
	// Q񗈂̂Œ
	if (!m_bClose) {
		m_bClose = TRUE;
		return;
	}

	// _~[\(^XNo[΍)
	if (m_lpddc) {
		OnFullScreen();
	}
	ShowWindow(SW_HIDE);

	// WM_DESTROYo
	DestroyWindow();
}

/*
 *	EChEj
 */
void CXM7Wnd::OnDestroy()
{
	// ꉞAtO
	m_bClose = TRUE;
	run_flag = FALSE;

	// VXeI
	system_cleanup();

	// R|[lg̃N[Abv
	CleanSch();
	CleanSnd();
	CleanKbd();
	CleanDD8();
	CleanGDI4();

	// ݒ菑
	SaveConfig();

	// {NX
	CFrameWnd::OnDestroy();
}

/*
 *	ANeBuԕύX
 */
void CXM7Wnd::OnActivate(UINT nState, CWnd *pWndOther, BOOL bMinimized)
{
	// ŏĂȂāAANeBu̎sł
	if (bMinimized) {
		m_bActive = FALSE;
	}
	else {
		if (nState == WA_INACTIVE) {
			m_bActive = FALSE;
		}
		else {
			m_bActive = TRUE;
		}
	}

	// {NX
	CFrameWnd::OnActivate(nState, pWndOther, bMinimized);
}

/*
 *	j[[vɓ
 */
void CXM7Wnd::OnEnterMenuLoop(BOOL bTrackFlag)
{
	// TEh~
	StopSnd();

	// Sʃ[hȂ}EXJ[\ONAj[o[`
	if (m_lpddc) {
		DrawMenuBar();
		m_lpdds[0]->SetClipper(m_lpddc);
		if (!m_bMouseCursor) {
			::ShowCursor(TRUE);
			m_bMouseCursor = TRUE;
		}
	}

	// tOグ
	m_bMenuFlag = TRUE;

	// {NX
	CFrameWnd::OnEnterMenuLoop(bTrackFlag);
}

/*
 *	ړ[vɓ
 */
LONG CXM7Wnd::OnEnterSizeMove(UINT wParam, LONG lParam)
{
	// TEh~
	StopSnd();

	// tOグ
	m_bMenuFlag = TRUE;

	return 0;
}

/*
 *	VXeR}hs
 */
void CXM7Wnd::OnSysCommand(UINT nID, LPARAM lParam)
{
	// TEh~
	StopSnd();

	// tOグ
	m_bMenuFlag = TRUE;

	// {NX
	CFrameWnd::OnSysCommand(nID, lParam);
}

/*-[ t[EChE R}h ]--------------------------------------*/

/*
 *	File-Open
 *	VMXe[gt@CJ
 */
void CXM7Wnd::OnOpen()
{
	CFileDialog dlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_FILEMUSTEXIST,
		"XM7 State Files (*.XM7)|*.XM7|All Files (*.*)|*.*||", this);

	// _CAO{bNXs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// t@C荞
	m_VMFile = dlg.GetPathName();

	// [h
	AfxGetApp()->BeginWaitCursor();
	if (!system_load((char*)(LPCTSTR)m_VMFile)) {
		AfxGetApp()->EndWaitCursor();
		MessageBox("Load Error", NULL, MB_ICONSTOP | MB_OK);
	}
	else {
		AfxGetApp()->EndWaitCursor();
	}

	// ĕ`𖾎IɎw
	m_bCaptionFlag = TRUE;
	m_bFullDraw = TRUE;

	// }`y[W𗘗păpbgݒ
	multipag_writeb(0xfd37, multi_page);

	// j[XV
	UpDriveMenu(0);
	UpDriveMenu(1);
	UpTapeMenu();
}

/*
 *	File-Save
 *	VMXe[gt@Cۑ
 */
void CXM7Wnd::OnSave()
{
	// t@Co^ĂȂ΁AOZ[u
	if (m_VMFile == "") {
		OnSaveAs();
		return;
	}

	// Z[u{
	AfxGetApp()->BeginWaitCursor();
	if (!system_save((char*)(LPCTSTR)m_VMFile)) {
		AfxGetApp()->EndWaitCursor();
		MessageBox("Save Error", NULL, MB_ICONSTOP | MB_OK);
	}
	else {
		AfxGetApp()->EndWaitCursor();
	}
}

/*
 *	File-Save As
 *	VMXe[gt@C𖼑Oĕۑ
 */
void CXM7Wnd::OnSaveAs()
{
	CFileDialog dlg(FALSE, ".XM7", NULL, OFN_OVERWRITEPROMPT | OFN_HIDEREADONLY,
		"XM7 State Files (*.XM7)|*.XM7|All Files (*.*)|*.*||", this);

	// _CAO{bNXs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// t@C荞
	m_VMFile = dlg.GetPathName();

	// Z[u{
	AfxGetApp()->BeginWaitCursor();
	if (!system_save((char*)(LPCTSTR)m_VMFile)) {
		AfxGetApp()->EndWaitCursor();
		MessageBox("Save Error", NULL, MB_ICONSTOP | MB_OK);
	}
	else {
		AfxGetApp()->EndWaitCursor();
	}
}

/*
 *	File-Reset
 *	Zbg
 */
void CXM7Wnd::OnReset()
{
	// TEhItAtOグ
	StopSnd();
	m_bMenuFlag = TRUE;

	// Zbg
	system_reset();

	// ʂ߁A\tbV
	memset(vram_c, 0, 0xc000);

	// \tbV
	Invalidate(FALSE);
	OnRefresh();
}

/*
 *	File-BASIC Mode
 */
void CXM7Wnd::OnBasBoot()
{
	boot_mode = BOOT_BASIC;
	OnReset();
}

/*
 *	File-BASIC Mode(UI)
 */
void CXM7Wnd::OnBasBootUI(CCmdUI *pCmdUI)
{
	if (boot_mode == BOOT_BASIC) {
		pCmdUI->SetRadio(TRUE);
	}
	else {
		pCmdUI->SetRadio(FALSE);
	}
}

/*
 *	File-DOS Mode
 */
void CXM7Wnd::OnDosBoot()
{
	boot_mode = BOOT_DOS;
	OnReset();
}

/*
 *	File-DOS Mode(UI)
 */
void CXM7Wnd::OnDosBootUI(CCmdUI *pCmdUI)
{
	if (boot_mode == BOOT_DOS) {
		pCmdUI->SetRadio(TRUE);
	}
	else {
		pCmdUI->SetRadio(FALSE);
	}
}

/*
 *	File-Exit
 *	EChEN[Y
 */
void CXM7Wnd::OnExit()
{
	PostMessage(WM_CLOSE, 0, 0);
}

/*
 *	hCuj[XV
 */
void CXM7Wnd::UpDriveMenu(UINT drive)
{
	CMenu *pTopMenu;
	CMenu *pMenu;
	int nID;
	int i;

	// LvVĕ`vo
	m_bCaptionFlag = TRUE;

	// Drivej[𓾂
	pTopMenu = GetMenu();
	if (drive == 0) {
		nID = IDM_DRV0OPEN;
	}
	else {
		nID = IDM_DRV1OPEN;
	}
	for (i=(pTopMenu->GetMenuItemCount()-1); i>=0; i--) {
		pMenu = pTopMenu->GetSubMenu(i);
		if ( (int)pMenu->GetMenuItemID(0) == nID) {
			break;
		}
	}

	// j[ŏ̂QcĂׂč폜
	for (i=(pMenu->GetMenuItemCount()-1); i>1; i--) {
		pMenu->DeleteMenu(i, MF_BYPOSITION);
	}

	// NOT READYȂI
	if (fdc_ready[drive] == FDC_TYPE_NOTREADY) {
		return;
	}

	// Eject+Zp[^+Write Protect+Zp[^
	if (drive == 0) {
		pMenu->AppendMenu(MF_STRING, IDM_DRV0EJECT, "&Eject");
		pMenu->AppendMenu(MF_SEPARATOR);
		pMenu->AppendMenu(MF_STRING, IDM_DRV0WRITE, "&Write Protect");
	}
	else {
		pMenu->AppendMenu(MF_STRING, IDM_DRV1EJECT, "&Eject");
		pMenu->AppendMenu(MF_SEPARATOR);
		pMenu->AppendMenu(MF_STRING, IDM_DRV1WRITE, "&Write Protect");
	}
	pMenu->AppendMenu(MF_SEPARATOR);

	// ID
	if (drive == 0) {
		nID = IDM_DRV000;
	}
	else {
		nID = IDM_DRV100;
	}

	if (fdc_ready[drive] == FDC_TYPE_2D) {
		// 2Dt@C̏ꍇ
		pMenu->AppendMenu(MF_STRING, nID, "2D Disk");
	}
	else {
		// D77t@C̏ꍇ
		for (i=0; i<fdc_medias[drive]; i++) {
			pMenu->AppendMenu(MF_STRING, nID, fdc_name[drive][i]);
			nID++;
		}
	}
}

/*
 *	Drive-Open
 *	fBXNt@Cǂݍ݋
 */
void CXM7Wnd::OnDrvOpen(UINT drive)
{
	int cnt;
	CString str;
	CFileDialog dlg(TRUE,
					NULL,
					NULL,
					OFN_HIDEREADONLY | OFN_FILEMUSTEXIST,
"FM-7/77 Disk Image Files (*.D77)|*.D77|\
320KB Disk Image Files (*.2D)|*.2D|\
All Files (*.*)|*.*||");

	// assert
	ASSERT((drive == 0) || (drive == 1));

	// _CAO{bNXs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// fBXNZbg
	str = dlg.GetPathName();
	cnt = fdc_setdisk((int)drive, (char*)((LPCTSTR)str));
	if (cnt == 0) {
		MessageBox("Disk Mount Error", NULL, MB_ICONSTOP | MB_OK);
		fdc_setdisk((int)drive, NULL);
	}

	// j[XV
	UpDriveMenu(drive);
	return;
}

/*
 *	Drive0-Open
 *	fBXNt@Cǂݍ
 */
void CXM7Wnd::OnDrv0Open()
{
	OnDrvOpen(0);
}

/*
 *	Drive1-Open
 *	fBXNt@Cǂݍ
 */
void CXM7Wnd::OnDrv1Open()
{
	OnDrvOpen(1);
}

/*
 *	Drive-Open Both Drives
 *	fBXNt@Cǂݍ
 */
void CXM7Wnd::OnDrvBoth()
{
	int cnt;
	CString str;
	CFileDialog dlg(TRUE,
					NULL,
					NULL,
					OFN_HIDEREADONLY | OFN_FILEMUSTEXIST,
"FM-7/77 Disk Image Files (*.D77)|*.D77|\
320KB Disk Image Files (*.2D)|*.2D|\
All Files (*.*)|*.*||");

	// _CAO{bNXs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// fBXNZbg(hCuO)
	str = dlg.GetPathName();
	cnt = fdc_setdisk(0, (char*)((LPCTSTR)str));
	if (cnt == 0) {
		MessageBox("Disk Mount Error", NULL, MB_ICONSTOP | MB_OK);
		fdc_setdisk(0, NULL);
	}

	// Qȏ゠΁AhCuPɃZbg
	if ((fdc_ready[0] == FDC_TYPE_D77) && (fdc_medias[0] >= 2)) {
		fdc_setdisk(1, (char*)((LPCTSTR)str));
		fdc_setmedia(1, 1);
	}
	else {
		// hCuP͎O
		fdc_setdisk(1, NULL);
	}

	// j[XV
	UpDriveMenu(0);
	UpDriveMenu(1);
	return;
}

/*
 *	Drive0-Eject
 *	fBXNt@CO
 */
void CXM7Wnd::OnDrv0Eject()
{
	fdc_setdisk(0, NULL);

	// j[XV
	UpDriveMenu(0);
}

/*
 *	Drive1-Eject
 *	fBXNt@CO
 */
void CXM7Wnd::OnDrv1Eject()
{
	fdc_setdisk(1, NULL);

	// j[XV
	UpDriveMenu(1);
}

 /*
 *	Drive-Write Protect
 *	CgveNgݒ苤
 */
void CXM7Wnd::OnDrvWrite(UINT drive)
{
	if (fdc_writep[drive]) {
		fdc_setwritep(drive, FALSE);
	}
	else {
		fdc_setwritep(drive, TRUE);
	}
}

/*
 *	Drive0-Write Protect
 *	CgveNgݒ
 */
void CXM7Wnd::OnDrv0Write()
{
	OnDrvWrite(0);
}

/*
 *	Drive1-Write Protect
 *	CgveNgݒ
 */
void CXM7Wnd::OnDrv1Write()
{
	OnDrvWrite(1);
}

/*
 *	Drvive-Write Protect
 *	CgveNgݒUI
 */
void CXM7Wnd::OnDrvWriteUI(UINT drive, CCmdUI *pCmdUI)
{
	// D77̂
	if (fdc_ready[drive] != FDC_TYPE_D77) {
		pCmdUI->Enable(FALSE);
		return;
	}

	// t@C݉̂
	if (fdc_fwritep[drive]) {
		pCmdUI->Enable(FALSE);
		return;
	}

	// Zbg
	pCmdUI->Enable(TRUE);
	if (fdc_writep[drive]) {
		pCmdUI->SetCheck(TRUE);
	}
	else {
		pCmdUI->SetCheck(FALSE);
	}
}

/*
 *	Drive0-Write Protect
 *	CgveNgݒUI
 */
void CXM7Wnd::OnDrv0WriteUI(CCmdUI *pCmdUI)
{
	OnDrvWriteUI(0, pCmdUI);
}

/*
 *	Drive1-Write Protect
 *	CgveNgݒUI
 */
void CXM7Wnd::OnDrv1WriteUI(CCmdUI *pCmdUI)
{
	OnDrvWriteUI(1, pCmdUI);
}

/*
 *	e[vj[XV
 */
void CXM7Wnd::UpTapeMenu()
{
	CMenu *pTopMenu;
	CMenu *pMenu;
	int i;

	// LvVĕ`vo
	m_bCaptionFlag = TRUE;

	// Tapej[𓾂
	pTopMenu = GetMenu();
	for (i=(pTopMenu->GetMenuItemCount()-1); i>=0; i--) {
		pMenu = pTopMenu->GetSubMenu(i);
		if ( (int)pMenu->GetMenuItemID(0) == IDM_TAPEOPEN) {
			break;
		}
	}

	// j[ŏcĂׂč폜
	for (i=(pMenu->GetMenuItemCount()-1); i>0; i--) {
		pMenu->DeleteMenu(i, MF_BYPOSITION);
	}

	// NOT READYȂI
	if (tape_fileh == -1) {
		return;
	}

	// e[v}EgĂꍇ
	pMenu->AppendMenu(MF_STRING, IDM_TAPEEJECT, "&Eject");
	pMenu->AppendMenu(MF_STRING, IDM_TAPEREW, "&REW");
	pMenu->AppendMenu(MF_STRING, IDM_TAPEFF, "&FF");
	pMenu->AppendMenu(MF_SEPARATOR);
	pMenu->AppendMenu(MF_STRING, IDM_TAPEREC, "&REC");
}

/*
 *	Tape-Open
 *	t@Cݒ
 */
void CXM7Wnd::OnTapeOpen()
{
	CString str;
	CFileDialog dlg(TRUE,
					NULL,
					NULL,
					OFN_HIDEREADONLY | OFN_FILEMUSTEXIST,
"FM-7/77 Tape Image Files (*.T77)|*.T77|\
All Files (*.*)|*.*||");

	// tOZbg
	m_bCaptionFlag = TRUE;

	// _CAO{bNXs
	if (dlg.DoModal() != IDOK) {
		return;
	}

	// e[vZbg
	str = dlg.GetPathName();
	tape_setfile((char*)(LPCTSTR)str);
	if (tape_fileh == -1) {
		MessageBox("Tape Mount Error", NULL, MB_ICONSTOP | MB_OK);
	}

	// j[XV
	UpTapeMenu();
}

/*
 *	Tape-Eject
 *	O
 */
void CXM7Wnd::OnTapeEject()
{
	// e[vO
	tape_setfile(NULL);

	// j[XV
	UpTapeMenu();
}

/*
 *	Tape-REW
 *	߂
 */
void CXM7Wnd::OnTapeRew()
{
	BeginWaitCursor();
	tape_rew();
	EndWaitCursor();
}

/*
 *	Tape-REW
 *	߂UI
 */
void CXM7Wnd::OnTapeRewUI(CCmdUI *pCmdUI)
{
	if (tape_fileh == -1) {
		pCmdUI->Enable(FALSE);
	}
	else {
		pCmdUI->Enable(TRUE);
	}
}

/*
 *	Tape-FF
 *	
 */
void CXM7Wnd::OnTapeFF()
{
	BeginWaitCursor();
	tape_ff();
	EndWaitCursor();
}

/*
 *	Tape-FF
 *	UI
 */
void CXM7Wnd::OnTapeFFUI(CCmdUI *pCmdUI)
{
	if (tape_fileh == -1) {
		pCmdUI->Enable(FALSE);
	}
	else {
		pCmdUI->Enable(TRUE);
	}
}

/*
 *	Tape-REC
 *	^ݒ
 */
void CXM7Wnd::OnTapeRec()
{
	if (tape_rec) {
		tape_setrec(FALSE);
	}
	else {
		tape_setrec(TRUE);
	}
}

/*
 *	Tape-REC
 *	^ݒUI
 */
void CXM7Wnd::OnTapeRecUI(CCmdUI *pCmdUI)
{
	if (tape_fileh == -1) {
		pCmdUI->Enable(FALSE);
		pCmdUI->SetCheck(FALSE);
		return;
	}

	pCmdUI->Enable(TRUE);
	pCmdUI->SetCheck(tape_rec);
}

/*
 *	View-Register-Main
 *	WX^EChE(C)\
 */
void CXM7Wnd::OnRegMain()
{
	if (m_pRegMainWnd != NULL) {
		m_pRegMainWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pRegMainWnd = new CXM7RegWnd((CWnd**)&m_pRegMainWnd, (CWnd*)this, MAINCPU);
}

/*
 *	View-Register-Main
 *	WX^EChE(C)UI
 */
void CXM7Wnd::OnRegMainUI(CCmdUI *pCmdUI)
{
	if (m_pRegMainWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Register-Sub
 *	WX^EChE(Tu)\
 */
void CXM7Wnd::OnRegSub()
{
	if (m_pRegSubWnd != NULL) {
		m_pRegSubWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pRegSubWnd = new CXM7RegWnd((CWnd**)&m_pRegSubWnd, (CWnd*)this, SUBCPU);
}

/*
 *	View-Register-Sub
 *	WX^EChE(Tu)UI
 */
void CXM7Wnd::OnRegSubUI(CCmdUI *pCmdUI)
{
	if (m_pRegSubWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-DisAssemble-Main
 *	tAZuEChE(C)\
 */
void CXM7Wnd::OnDisMain()
{
	if (m_pDisMainWnd != NULL) {
		m_pDisMainWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pDisMainWnd = new CXM7DisWnd((CWnd**)&m_pDisMainWnd, (CWnd*)this, MAINCPU);
}

/*
 *	View-DisAssemble-Main
 *	tAZuEChE(C)UI
 */
void CXM7Wnd::OnDisMainUI(CCmdUI *pCmdUI)
{
	if (m_pDisMainWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-DisAssemble-Sub
 *	tAZuEChE(Tu)\
 */
void CXM7Wnd::OnDisSub()
{
	if (m_pDisSubWnd != NULL) {
		m_pDisSubWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pDisSubWnd = new CXM7DisWnd((CWnd**)&m_pDisSubWnd, (CWnd*)this, SUBCPU);
}

/*
 *	View-DisAssemble-Sub
 *	tAZuEChE(Tu)UI
 */
void CXM7Wnd::OnDisSubUI(CCmdUI *pCmdUI)
{
	if (m_pDisSubWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Dump-Main
 *	_vEChE(C)\
 */
void CXM7Wnd::OnDumpMain()
{
	if (m_pDumpMainWnd != NULL) {
		m_pDumpMainWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pDumpMainWnd = new CXM7DumpWnd((CWnd**)&m_pDumpMainWnd, (CWnd*)this, MAINCPU);
}

/*
 *	View-Dump-Main
 *	_vEChE(C)UI
 */
void CXM7Wnd::OnDumpMainUI(CCmdUI *pCmdUI)
{
	if (m_pDumpMainWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Dump-Sub
 *	_vEChE(Tu)\
 */
void CXM7Wnd::OnDumpSub()
{
	if (m_pDumpSubWnd != NULL) {
		m_pDumpSubWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pDumpSubWnd = new CXM7DumpWnd((CWnd**)&m_pDumpSubWnd, (CWnd*)this, SUBCPU);
}

/*
 *	View-Dump-Sub
 *	_vEChE(Sub)UI
 */
void CXM7Wnd::OnDumpSubUI(CCmdUI *pCmdUI)
{
	if (m_pDumpSubWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Int-Main
 *	荞݃EChE(C)\
 */
void CXM7Wnd::OnIntMain()
{
	if (m_pIntMainWnd != NULL) {
		m_pIntMainWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pIntMainWnd = new CXM7IntWnd((CWnd**)&m_pIntMainWnd, (CWnd*)this, MAINCPU);
}

/*
 *	View-Int-Main
 *	荞݃EChE(C)UI
 */
void CXM7Wnd::OnIntMainUI(CCmdUI *pCmdUI)
{
	if (m_pIntMainWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Int-Sub
 *	荞݃EChE(Tu)\
 */
void CXM7Wnd::OnIntSub()
{
	if (m_pIntSubWnd != NULL) {
		m_pIntSubWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pIntSubWnd = new CXM7IntWnd((CWnd**)&m_pIntSubWnd, (CWnd*)this, SUBCPU);
}

/*
 *	View-Int-Sub
 *	荞݃EChE(Sub)UI
 */
void CXM7Wnd::OnIntSubUI(CCmdUI *pCmdUI)
{
	if (m_pIntSubWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Break Point
 *	u[N|CgEChE\
 */
void CXM7Wnd::OnBreakp()
{
	if (m_pBreakWnd != NULL) {
		m_pBreakWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pBreakWnd = new CXM7BreakWnd((CWnd**)&m_pBreakWnd, (CWnd*)this);
}

/*
 *	View-Break Point
 *	u[N|CgEChEUI
 */
void CXM7Wnd::OnBreakpUI(CCmdUI *pCmdUI)
{
	if (m_pBreakWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-BASIC ROM
 *	BASIC ROMEChE\
 */
void CXM7Wnd::OnBASICROM()
{
	if (m_pVerWnd != NULL) {
		m_pVerWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pVerWnd = new CXM7VerWnd((CWnd**)&m_pVerWnd, (CWnd*)this);
}

/*
 *	View-BASIC ROM
 *	BASIC ROMEChEUI
 */
void CXM7Wnd::OnBASICROMUI(CCmdUI *pCmdUI)
{
	if (m_pVerWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-TTL Palette
 *	TTLpbgEChE\
 */
void CXM7Wnd::OnTTLPal()
{
	if (m_pTTLPalWnd != NULL) {
		m_pTTLPalWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pTTLPalWnd = new CXM7TTLPalWnd((CWnd**)&m_pTTLPalWnd, (CWnd*)this);
}

/*
 *	View-TTL Palette
 *	TTLpbgEChEUI
 */
void CXM7Wnd::OnTTLPalUI(CCmdUI *pCmdUI)
{
	if (m_pTTLPalWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Multi Page
 *	}`y[WEChE\
 */
void CXM7Wnd::OnMulti()
{
	if (m_pMultiWnd != NULL) {
		m_pMultiWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pMultiWnd = new CXM7MultiWnd((CWnd**)&m_pMultiWnd, (CWnd*)this);
}

/*
 *	View-Multi Page
 *	}`y[WEChEUI
 */
void CXM7Wnd::OnMultiUI(CCmdUI *pCmdUI)
{
	if (m_pMultiWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-FDC
 *	FDCEChE\
 */
void CXM7Wnd::OnFDC()
{
	if (m_pFDCWnd != NULL) {
		m_pFDCWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pFDCWnd = new CXM7FDCWnd((CWnd**)&m_pFDCWnd, (CWnd*)this);
}

/*
 *	View-FDC
 *	FDCEChEUI
 */
void CXM7Wnd::OnFDCUI(CCmdUI *pCmdUI)
{
	if (m_pFDCWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Kanji
 *	ROMEChE\
 */
void CXM7Wnd::OnKnj()
{
	if (m_pKnjWnd != NULL) {
		m_pKnjWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pKnjWnd = new CXM7KnjWnd((CWnd**)&m_pKnjWnd, (CWnd*)this);
}

/*
 *	View-Kanji ROM
 *	ROMEChEUI
 */
void CXM7Wnd::OnKnjUI(CCmdUI *pCmdUI)
{
	if (m_pKnjWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Casette Tape
 *	JZbge[vEChE\
 */
void CXM7Wnd::OnTape()
{
	if (m_pTapeWnd != NULL) {
		m_pTapeWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pTapeWnd = new CXM7TapeWnd((CWnd**)&m_pTapeWnd, (CWnd*)this);
}

/*
 *	View-Casette Tape
 *	JZbge[vEChEUI
 */
void CXM7Wnd::OnTapeUI(CCmdUI *pCmdUI)
{
	if (m_pTapeWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Line Printer
 *	Cv^EChE\
 */
void CXM7Wnd::OnLP()
{
	if (m_pLPWnd != NULL) {
		m_pLPWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pLPWnd = new CXM7LPWnd((CWnd**)&m_pLPWnd, (CWnd*)this);
}

/*
 *	View-Line Printer
 *	Cv^EChEUI
 */
void CXM7Wnd::OnLPUI(CCmdUI *pCmdUI)
{
	if (m_pLPWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-OPN
 *	OPNEChE\
 */
void CXM7Wnd::OnOPN()
{
	if (m_pOPNWnd != NULL) {
		m_pOPNWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pOPNWnd = new CXM7OPNWnd((CWnd**)&m_pOPNWnd, (CWnd*)this);
}

/*
 *	View-OPN
 *	OPNEChEUI
 */
void CXM7Wnd::OnOPNUI(CCmdUI *pCmdUI)
{
	if (m_pOPNWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Sub Control
 *	TuCPURg[EChE\
 */
void CXM7Wnd::OnSubCtrl()
{
	if (m_pSubWnd != NULL) {
		m_pSubWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pSubWnd = new CXM7SubWnd((CWnd**)&m_pSubWnd, (CWnd*)this);
}

/*
 *	View-Sub Control
 *	TuCPURg[EChEUI
 */
void CXM7Wnd::OnSubCtrlUI(CCmdUI *pCmdUI)
{
	if (m_pSubWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Keyboard
 *	L[{[hEChE\
 */
void CXM7Wnd::OnKbd()
{
	if (m_pKbdWnd != NULL) {
		m_pKbdWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pKbdWnd = new CXM7KbdWnd((CWnd**)&m_pKbdWnd, (CWnd*)this);
}

/*
 *	View-Keyboard
 *	L[{[hEChEUI
 */
void CXM7Wnd::OnKbdUI(CCmdUI *pCmdUI)
{
	if (m_pKbdWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-CRT
 *	CRTWX^EChE\
 */
void CXM7Wnd::OnCRT()
{
	if (m_pCRTWnd != NULL) {
		m_pCRTWnd->PostMessage(WM_CLOSE, 0, 0);
		return;
	}

	m_pCRTWnd = new CXM7CRTWnd((CWnd**)&m_pCRTWnd, (CWnd*)this);
}

/*
 *	View-CRT Register
 *	CRTWX^EChEUI
 */
void CXM7Wnd::OnCRTUI(CCmdUI *pCmdUI)
{
	if (m_pCRTWnd) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Refresh
 *	r[EChEXV
 */
void CXM7Wnd::OnRefresh()
{
	int i;
	CXM7ViewWnd *pViewWnd;

	 // tAZuEChÉAPCƓ
	if (m_pDisMainWnd) {
		m_pDisMainWnd->SetAddr(maincpu.pc);
	}
	if (m_pDisSubWnd) {
		m_pDisSubWnd->SetAddr(subcpu.pc);
	}

	// Xe[^Xĕ`
	for (i=0; i<sizeof(m_ViewWndList)/sizeof(CWnd**); i++) {
		if (m_ViewWndList[i]) {
			if (*m_ViewWndList[i]) {
				pViewWnd = (CXM7ViewWnd*)*m_ViewWndList[i];
				pViewWnd->Invalidate(FALSE);
			}
		}
	}
}

/*
 *	View-Sync
 *	
 */
void CXM7Wnd::OnSync()
{
	m_bSyncFlag = !m_bSyncFlag;
}

/*
 *	View-Sync
 *	UI
 */
void CXM7Wnd::OnSyncUI(CCmdUI *pCmdUI)
{
	if (m_bSyncFlag) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	View-Full Screen
 *	tXN[
 */
void CXM7Wnd::OnFullScreen()
{
	// TEhItAtOグ
	StopSnd();
	m_bMenuFlag = TRUE;

	 if (!m_lpddc) {
		// tXN[
		CleanGDI4();
		if (!SelectDD8()) {
			// tXN[s
			CleanDD8();
			SelectGDI4();
		}
	}
	else {
		// EChE
		CleanDD8();
		if (!SelectGDI4()) {
			// EChEs
			CleanGDI4();
			SelectDD8();
		}
	}
}

/*
 *	View-Full Screen
 *	tXN[UI
 */
void CXM7Wnd::OnFullScreenUI(CCmdUI *pCmdUI)
{
	if (m_lpddc) {
		pCmdUI->SetCheck(1);
	}
	else {
		pCmdUI->SetCheck(0);
	}
}

/*
 *	Debug-Run
 *	
 */
void CXM7Wnd::OnRun()
{
	run_flag = TRUE;
}

/*
 *	Debug-Run
 *	(UI)
 */
void CXM7Wnd::OnRunUI(CCmdUI *pCmdUI)
{
	if (!run_flag) {
		pCmdUI->Enable(TRUE);
	}
	else {
		pCmdUI->Enable(FALSE);
	}
}

/*
 *	Debug-Break
 *	u[N
 */
void CXM7Wnd::OnBreak()
{
	run_flag = FALSE;
}

/*
 *	Debug-Break
 *	u[N(UI)
 */
void CXM7Wnd::OnBreakUI(CCmdUI *pCmdUI)
{
	if (run_flag) {
		pCmdUI->Enable(TRUE);
	}
	else {
		pCmdUI->Enable(FALSE);
	}
}

/*
 *	Debug-Trace
 *	g[X
 */
void CXM7Wnd::OnTrace()
{
	// TEhItAtOグ
	StopSnd();
	m_bMenuFlag = TRUE;

	// g[X
	debug_trace();

	// \tbV
	Invalidate(FALSE);
	OnRefresh();
}

/*
 *	Debug-Trace
 *	g[X(UI)
 */
void CXM7Wnd::OnTraceUI(CCmdUI *pCmdUI)
{
	if (!run_flag) {
		pCmdUI->Enable(TRUE);
	}
	else {
		pCmdUI->Enable(FALSE);
	}
}

/*
 *	Debug-Jump-Main
 *	CCPUWv
 */
void CXM7Wnd::OnJumpMain()
{
	WORD pc;
	CXM7AddrDlg dlg(this, &pc);

	pc = maincpu.pc;
	if (dlg.DoModal() == IDOK) {
		maincpu.pc = pc;
	}
}

/*
 *	Debug-Jump-Sub
 *	TuCPUWv
 */
void CXM7Wnd::OnJumpSub()
{
	WORD pc;
	CXM7AddrDlg dlg(this, &pc);

	pc = subcpu.pc;
	if (dlg.DoModal() == IDOK) {
		subcpu.pc = pc;
	}
}

/*
 *	Window-View All Window
 *	qEChEׂĕ\
 */
void CXM7Wnd::OnViewAll(void)
{
	if (!m_pRegMainWnd) {
		OnRegMain();
	}
	if (!m_pRegSubWnd) {
		OnRegSub();
	}
	if (!m_pDisMainWnd) {
		OnDisMain();
	}
	if (!m_pDisSubWnd) {
		OnDisSub();
	}
	if (!m_pDumpMainWnd) {
		OnDumpMain();
	}
	if (!m_pDumpSubWnd) {
		OnDumpSub();
	}
	if (!m_pIntMainWnd) {
		OnIntMain();
	}
	if (!m_pIntSubWnd) {
		OnIntSub();
	}
	if (!m_pBreakWnd) {
		OnBreakp();
	}

	if (!m_pVerWnd) {
		OnBASICROM();
	}
	if (!m_pTTLPalWnd) {
		OnTTLPal();
	}
	if (!m_pMultiWnd) {
		OnMulti();
	}
	if (!m_pFDCWnd) {
		OnFDC();
	}
	if (!m_pKnjWnd) {
		OnKnj();
	}
	if (!m_pTapeWnd) {
		OnTape();
	}
	if (!m_pLPWnd) {
		OnLP();
	}
	if (!m_pOPNWnd) {
		OnOPN();
	}

	if (!m_pSubWnd) {
		OnSubCtrl();
	}
	if (!m_pKbdWnd) {
		OnKbd();
	}
	if (!m_pCRTWnd) {
		OnCRT();
	}
}

/*
 *	Window-Close All Window
 *	qEChEׂĕ
 */
void CXM7Wnd::OnCloseAll(void)
{
	int i;

	for (i=0; i<(sizeof(m_ViewWndList)/sizeof(CWnd**)); i++) {
		if (m_ViewWndList[i]) {
			if (*m_ViewWndList[i]) {
				(CWnd*)(*m_ViewWndList[i])->PostMessage(WM_CLOSE, 0, 0);
			}
		}
	}
}

/*
 *	Window-Iconic All Window
 *	qEChEׂčŏ
 */
void CXM7Wnd::OnIconic(void)
{
	int i;

	for (i=0; i<(sizeof(m_ViewWndList)/sizeof(CWnd**)); i++) {
		if (m_ViewWndList[i]) {
			if (*m_ViewWndList[i]) {
				(CWnd*)(*m_ViewWndList[i])->ShowWindow(SW_MINIMIZE);
			}
		}
	}
}

/*
 *	Window-Restore All Window
 *	qEChEׂĒʏ\
 */
void CXM7Wnd::OnRestore(void)
{
	int i;

	for (i=0; i<(sizeof(m_ViewWndList)/sizeof(CWnd**)); i++) {
		if (m_ViewWndList[i]) {
			if (*m_ViewWndList[i]) {
				(CWnd*)(*m_ViewWndList[i])->ShowWindow(SW_RESTORE);
			}
		}
	}
}

/*
 *	Window-Arrange Icon
 *	ACRꂽqEChE𐮗
 */
void CXM7Wnd::OnArrangeIcon()
{
	ArrangeIconicWindows();
}

/*
 *	Help-About
 *	o[W_CAO
 */
void CXM7Wnd::OnAbout()
{
	CDialog dlg(MAKEINTRESOURCE(IDD_ABOUTDLG), this);

	// [__CAO{bNXs
	dlg.DoModal();
}

/*
 *	EChEj[XV
 */
void CXM7Wnd::UpWndMenu()
{
	CMenu *pTopMenu;
	CMenu *pMenu;
	CString TitleStr;
	CString NumStr;
	int i;
	int j;
	int nID;

	// ANeBuEChEXgNA
	memset(m_ActiveWndList, 0, sizeof(m_ActiveWndList));

	// Drivej[𓾂
	pTopMenu = GetMenu();
	for (i=(pTopMenu->GetMenuItemCount()-1); i>=0; i--) {
		pMenu = pTopMenu->GetSubMenu(i);
		if ( (int)pMenu->GetMenuItemID(0) == IDM_VIEW) {
			break;
		}
	}

	// j[ŏ̂UcĂׂč폜
	for (i=(pMenu->GetMenuItemCount()-1); i>5; i--) {
		pMenu->DeleteMenu(i, MF_BYPOSITION);
	}

	// 莝̃EChE邩`FbN
	for (i=0; i<sizeof(m_ViewWndList)/sizeof(CWnd**); i++) {
		if (m_ViewWndList[i]) {
			if (*m_ViewWndList[i] != NULL) {
				break;
			}
		}
	}
	if (i == sizeof(m_ViewWndList)/sizeof(CWnd**)) {
		return;
	}

	// Zp[^ǉ
	pMenu->AppendMenu(MF_SEPARATOR);
	nID = IDM_WND000;
	j = 1;

	// ēx[v
	for (i=0; i<sizeof(m_ViewWndList)/sizeof(CWnd**); i++) {
		if (m_ViewWndList[i]) {
			if (*m_ViewWndList[i] != NULL) {
				NumStr.Format("%d ", j);
				(*m_ViewWndList[i])->GetWindowText(TitleStr);
				NumStr += TitleStr;
				pMenu->AppendMenu(MF_STRING, nID, NumStr);
				m_ActiveWndList[j - 1] = *m_ViewWndList[i];
				nID++;
				j++;
			}
		}
	}
}

/*
 *	R}h[eBO g
 */
BOOL CXM7Wnd::OnCmdMsg(UINT nID, int nCode, void* pExtra,
							AFX_CMDHANDLERINFO* pHandlerInfo)
{
	int drive;
	int index;
	CCmdUI *pCmdUI;

	// nh`FbN
	if (pHandlerInfo != NULL) {
		return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
	}

	// nID`FbN
	if ((nID >= IDM_DRV000) && (nID < (IDM_DRV000+32))) {
		drive = (nID - IDM_DRV000) / 16;
		index = (nID - IDM_DRV000) % 16;
		if (nCode == CN_UPDATE_COMMAND_UI) {
			pCmdUI = (CCmdUI*)pExtra;
			pCmdUI->Enable(TRUE);
			if (fdc_media[drive] == index) {
				pCmdUI->SetCheck(TRUE);
			}
			else {
				pCmdUI->SetCheck(FALSE);
			}
			return TRUE;
		}
		if (nCode == CN_COMMAND) {
			fdc_setmedia(drive, index);
			return TRUE;
		}
	}

	if ((nID >= IDM_WND000) && (nID < (IDM_WND000+32))) {
		if (nCode == CN_UPDATE_COMMAND_UI) {
			pCmdUI = (CCmdUI*)pExtra;
			pCmdUI->Enable(TRUE);
			return TRUE;
		}
		if (nCode == CN_COMMAND) {
			if (m_ActiveWndList[nID - IDM_WND000]) {
				m_ActiveWndList[nID - IDM_WND000]->ShowWindow(SW_RESTORE);
				m_ActiveWndList[nID - IDM_WND000]->SetWindowPos(&wndTop,
					0, 0, 128, 128, SWP_NOMOVE | SWP_NOSIZE);
			}
			return TRUE;
		}
	}

	return CFrameWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

#endif	/* _WIN32 */
