/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 XPW[ ]
 */

#ifdef _WIN32

#include <afxwin.h>
#include "xm7.h"
#include "win.h"
#include "mainetc.h"
#include "subctrl.h"
#include "resource.h"

/*
 *	XPW[
 *	
 */
void CXM7Wnd::InitSch()
{
	// o
	m_nTimerID = 0;
	ASSERT(!run_flag);
}

/*
 *	XPW[
 *	I
 */
BOOL CXM7Wnd::SelectSch()
{
	ASSERT(!run_flag);

	// }`fBA^C}[N
	m_nTimerID = timeSetEvent(10, 10, TimerFunc, (DWORD)this, TIME_PERIODIC);
	if (m_nTimerID == NULL) {
		return FALSE;
	}

	return TRUE;
}

/*
 *	XPW[
 *	N[Abv
 */
void CXM7Wnd::CleanSch()
{
	ASSERT(!run_flag);

	// ^C}[
	if (m_nTimerID) {
		timeKillEvent(m_nTimerID);
		m_nTimerID = 0;
	}
}

/*
 *	XPW[
 *	10mss
 */
void CXM7Wnd::ProcessVM()
{
	int i;
	int j;
	WORD step;

	// I`FbN
	if (stopreq_flag) {
		debug_stopbreak();
		stopreq_flag = FALSE;
		run_flag = FALSE;
		OnRefresh();
		Invalidate(FALSE);
		return;
	}

	// foCX|[O
	PollKbd();
	PollJoy();

	// 荞ݏ
	m_nNMICount++;
	if (m_nNMICount & 1) {
		subcpu_nmi();
	}
	mainetc_timer();

	if (debug_runbreak()) {
		// siej
		step = 0;
		for (j=0; j<10; j++) {
			ProcessSnd(FALSE);
			step += ((cpu_speed / 10) + 1);
			while (maincpu.total < step) {
				maincpu_exec();
				if (!subhalt_flag) {
					subcpu_exec();
				}
				if (debug_chkbreak()) {
					stopreq_flag = TRUE;
				}
				if (stopreq_flag) {
					return;
				}
			}
		}
	}
	else {
		// si}j
		step = 0;
		for (j=0; j<10; j++) {
			ProcessSnd(FALSE);
			step += ((cpu_speed / 10) + 1);
			while (maincpu.total < step) {
				for (i=0; i<512; i++) {
					maincpu_exec();
					if (!subhalt_flag) {
						subcpu_exec();
					}
				}
			}
		}
	}

	// CPUx␳
	maincpu.total -= cpu_speed;
}

/*
 *	C[v
 */
LONG CXM7Wnd::MainLoop(UINT wParam, LONG lParam)
{
	CClientDC *pDC;
	MSG msg;
	DWORD dwTime;
	int count;

	// G[`FbN
	switch (m_nErrorCode) {
		case 1:
			MessageBox("VM Init Error", NULL, MB_ICONSTOP | MB_OK);
			m_bClose = TRUE;
			PostMessage(WM_CLOSE, 0, 0);
			return 0;
		case 2:
			MessageBox("DirectX Init Error", NULL, MB_ICONSTOP | MB_OK);
			m_bClose = TRUE;
			PostMessage(WM_CLOSE, 0, 0);
			return 0;
	}

	// ^CI[o[JE^
	count = 0;

	// okAC[v
	while (!m_bClose) {
		// bZ[W|v
		while (::PeekMessage(&msg, NULL, 0, 0, PM_NOREMOVE)) {
			if (!AfxGetApp()->PumpMessage()) {
				::PostQuitMessage(0);
				break;
			}
		}

		// j[I̕
		if (m_bMenuFlag) {
			m_bMenuFlag = FALSE;
			m_dwTimerCount = 0;
			PlaySnd();
			if (m_lpddc) {
				// Sʃ[hȂA}EXJ[\offANbp[Ȃ
				if (m_bMouseCursor) {
					::ShowCursor(FALSE);
					m_bMouseCursor = FALSE;
				}
				m_lpdds[0]->SetClipper(NULL);
			}
			else {
				// EChE[hȂA}EXJ[\on
				if (!m_bMouseCursor) {
					::ShowCursor(TRUE);
					m_bMouseCursor = TRUE;
				}
			}
			m_bFullDraw = TRUE;
		}

		// s
		if (run_flag && m_bActive) {
			// soĂ΁A10msscontinue
			if (m_dwTimerCount > 0) {
				ProcessVM();
				m_dwTimerCount--;

				// ^CI[o[mF
				count = (count + 1) & 0x0f;
				if (!count) {
					if ((timeGetTime() - m_dwDrawTime) < 160) {
						continue;
					}
					// 16JEg1񒲂ׁA160ms`ȂȂ`
				}
				else {
					continue;
				}
			}
		}
		else {
			// TEhobt@ɋf[^l߂
			ProcessSnd(TRUE);
			// LvV̂ݕ`悵ASleep
			UpdateCaption();
			::Sleep(10);
			continue;
		}

		// t[[gmF
		dwTime = timeGetTime();
		if ((dwTime - m_dwDrawTime) < (1000 / m_nFrameRate)) {
			::Sleep(1);
			continue;
		}

		// `JE^XV
		m_dwDrawTime = dwTime;
		m_nDrawCount++;

		// `
		pDC = new CClientDC(this);
		OnDraw(pDC);
		delete pDC;
	}

	// N[Yv|Xg
	PostMessage(WM_CLOSE, 0, 0);

	return 0;
}

/*
 *	}`fBA^C}[
 *	R[obN
 */
void CALLBACK CXM7Wnd::TimerFunc(UINT wTimerID, UINT wMsg, DWORD dwUser,
	 DWORD dw1, DWORD dw2)
{
	CXM7Wnd *pXM7Wnd;

	// CEChE擾
	pXM7Wnd = (CXM7Wnd*)dwUser;

	// sŁAEChEANeBu
	if (run_flag && pXM7Wnd->m_bActive) {
		// 10ms̎s(100msȏ͗߂Ȃ)
		pXM7Wnd->m_dwTimerCount++;
		if (pXM7Wnd->m_dwTimerCount >= 10) {
			pXM7Wnd->m_dwTimerCount = 10;
		}
	}
	else {
		// sԂNA
		pXM7Wnd->m_dwTimerCount = 0;
	}
}

/*
 *	Cxg(Ȃ)
 */
extern "C" {
void do_events(void)
{
}
}

#endif	/* _WIN32 */
