/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 TEh ]
 */

#ifdef _WIN32

#include <afxwin.h>
#include "xm7.h"
#include "opn.h"
#include "win.h"
#include "resource.h"
#include "device.h"
#include "mainetc.h"
#include "cisc.h"
#include "opna.h"

/*
 *	TEh
 *	
 */
void CXM7Wnd::InitSnd()
{
	// o
	m_lpds = NULL;
	m_lpdsp = NULL;
	m_lpdsb = NULL;
	m_lpsbuf = NULL;
	m_lpstmp = NULL;
	m_sndsize = 0;
	m_pOPN = NULL;
	m_sndbank = FALSE;
	m_sndcount = 0;
	m_beepcount = 0;

	m_bSndOPN = TRUE;
	m_bSndPSG = TRUE;
	m_bSndBEEP = TRUE;
}

/*
 *	TEh
 *	I
 */
BOOL CXM7Wnd::SelectSnd(UINT rate, UINT tick, UINT ms)
{
	PCMWAVEFORMAT pcmwf;
	DSBUFFERDESC dsbd;
	WAVEFORMATEX wfex;
	int i;

	ASSERT((rate == 0) || (rate == 22050) || (rate == 44100));
	ASSERT((tick > 0) && (tick <= 500));
	ASSERT((ms > 0) && (ms < tick));

	// p[^L
	m_sndrate = rate;
	m_sndtick = tick;
	m_sndms = ms;
	m_sndcount = 0;

	// rate==0ȂAȂ
	if (rate == 0) {
		return TRUE;
	}

	// DiectSoundIuWFNg쐬
	if (DirectSoundCreate(NULL, &m_lpds, NULL) != DS_OK) {
		// ftHgfoCXȂAgp
		return TRUE;
	}

	// xݒ(D拦)
	if (m_lpds->SetCooperativeLevel(m_hWnd, DSSCL_PRIORITY) != DS_OK) {
		return FALSE;
	}

	// vC}obt@쐬
	memset(&dsbd, 0, sizeof(dsbd));
	dsbd.dwSize = sizeof(dsbd);
	dsbd.dwFlags = DSBCAPS_PRIMARYBUFFER;
	if (m_lpds->CreateSoundBuffer(&dsbd, &m_lpdsp, NULL) != DS_OK) {
		return FALSE;
	}

	// vC}obt@̃tH[}bgw
	memset(&wfex, 0, sizeof(wfex));
	wfex.wFormatTag = WAVE_FORMAT_PCM;
	wfex.nChannels = 1;
	wfex.nSamplesPerSec = m_sndrate;
    wfex.nBlockAlign = 2;
	wfex.nAvgBytesPerSec =
			wfex.nSamplesPerSec * wfex.nBlockAlign;
	wfex.wBitsPerSample = 16;
	if (m_lpdsp->SetFormat(&wfex) != DS_OK) {
		return FALSE;
	}

	// ZJ_obt@쐬
	memset(&pcmwf, 0, sizeof(pcmwf));
	pcmwf.wf.wFormatTag = WAVE_FORMAT_PCM;
	pcmwf.wf.nChannels = 1;
	pcmwf.wf.nSamplesPerSec = m_sndrate;
    pcmwf.wf.nBlockAlign = 2;
	pcmwf.wf.nAvgBytesPerSec =
			pcmwf.wf.nSamplesPerSec * pcmwf.wf.nBlockAlign;
	pcmwf.wBitsPerSample = 16;
	memset(&dsbd, 0, sizeof(dsbd));
	dsbd.dwSize = sizeof(dsbd);
	dsbd.dwFlags = DSBCAPS_CTRLDEFAULT;
	dsbd.dwBufferBytes = pcmwf.wf.nAvgBytesPerSec / (1000 / (m_sndtick * 2));
	dsbd.dwBufferBytes = ((dsbd.dwBufferBytes + 15) >> 4) << 4;
						// 16oCgEɐݒ
	m_sndsize = dsbd.dwBufferBytes;
	dsbd.lpwfxFormat = (LPWAVEFORMATEX)&pcmwf;
	if (m_lpds->CreateSoundBuffer(&dsbd, &m_lpdsb, NULL) != DS_OK) {
		return FALSE;
	}

	// TEhobt@쐬
	m_lpsbuf = (WORD *)malloc(m_sndsize / 2);
	if (m_lpsbuf == NULL) {
		return FALSE;
	}
	memset(m_lpsbuf, 0, m_sndsize / 2);

	m_lpstmp = (DWORD *)malloc(m_sndsize);
	if (m_lpstmp == NULL) {
		return FALSE;
	}

	// OPNfoCX쐬
	ASSERT(!m_pOPN);
	m_pOPN = new OPN;
	m_pOPN->Init(12288, m_sndrate / 100, TRUE, NULL);
	m_pOPN->Reset();
	m_pOPN->SetReg(0x27, 0);

	// TEhݒ(PSG)
	for (i=0; i<0x0e; i++) {
		opn_setb(i, opn_reg[i]);
	}

	// TEhݒ(vXP[)
	switch (opn_scale) {
		case 2:
			m_pOPN->SetReg(0x2f, 0);
			break;
		case 3:
			m_pOPN->SetReg(0x2e, 0);
			break;
	}

	// TEhݒ(FM)
	opn_setb(0x27, opn_reg[0x27] & 0xc0);
	for (i=0x30; i<0xb4; i++) {
		opn_setb(i, opn_reg[i]);
	}

	// TEhX^[g
	PlaySnd();

	return TRUE;
}

/*
 *	TEh
 *	N[Abv
 */
void CXM7Wnd::CleanSnd()
{
	StopSnd();

	// OPN
	if (m_pOPN) {
		delete m_pOPN;
		m_pOPN = NULL;
	}

	// TEh쐬obt@
	if (m_lpstmp) {
		free(m_lpstmp);
		m_lpstmp = NULL;
	}
	if (m_lpsbuf) {
		free(m_lpsbuf);
		m_lpsbuf = NULL;
	}

	// DirectSoundBuffer
	if (m_lpdsb) {
		m_lpdsb->Release();
		m_lpdsb = NULL;
	}
	if (m_lpdsp) {
		m_lpdsp->Release();
		m_lpdsp = NULL;
	}

	// DirectSound
	if (m_lpds) {
		m_lpds->Release();
		m_lpds = NULL;
	}
}

/*
 *	TEh
 *	tJn
 */
void CXM7Wnd::PlaySnd()
{
	if (m_lpdsb) {
		m_lpdsb->Play(0, 0, DSBPLAY_LOOPING);
	}
}

/*
 *	TEh
 *	t~
 */
void CXM7Wnd::StopSnd()
{
	if (m_lpdsb) {
		m_lpdsb->Stop();
	}
}

/*
 *	TEh
 *	obt@֒ǉ
 */
void CXM7Wnd::AddSnd(BOOL fillflag, BOOL zeroflag)
{
	int i;
	int samples;
	int dat;
	WORD highlow;
	WORD *q;

	// `FbN
	if (m_pOPN == NULL) {
		return;
	}

	// ɏ\ǉĂ΁AǉȂ
	ASSERT(m_sndcount <= (m_sndsize / 4));
	if (m_sndcount == (m_sndsize / 4)) {
		return;
	}

	// Tv
	if (fillflag) {
		samples = (m_sndsize / 4) - m_sndcount;
	}
	else {
		samples = (m_sndsize / 4) / (m_sndtick / m_sndms);
		if (samples > (int)(((m_sndsize / 4) - m_sndcount))) {
			samples = (m_sndsize / 4) - m_sndcount;
		}
	}

	// ~LVO
	memset(m_lpstmp, 0, samples * sizeof(int32));
	if (!zeroflag) {
		m_pOPN->Mix((int32*)m_lpstmp, samples);
		BeepSnd((int*)m_lpstmp, samples);
	}

	// ϊ
	q = &m_lpsbuf[m_sndcount];
	for (i=0; i<samples; i++) {
		dat = (int32)m_lpstmp[i];
		highlow = (WORD)(dat & 0x0000ffff);

		if ((dat > 0) && (highlow >= 0x8000)) {
			*q++ = 0x7fff;
			continue;
		}
		if ((dat < 0) && (highlow < 0x8000)) {
			*q++ = 0x8000;
			continue;
		}

		*q++ = highlow;
	}

	// JEgAbv
	m_sndcount += samples;
}

/*
 *	TEh
 *	
 */
void CXM7Wnd::ProcessSnd(BOOL zeroflag)
{
	DWORD curplay, curwrite;
	DWORD woffset;
	BOOL wflag;
	WORD *ptr1, *ptr2;
	DWORD size1, size2;
	WORD *p;
	UINT halfbytes;
	HRESULT hr;

	// `FbN
	if (m_pOPN == NULL) {
		return;
	}

	// ݂̉t󋵂擾
	if (m_lpdsb->GetCurrentPosition(&curplay, &curwrite) != DS_OK) {
		return;
	}

	// oNԍƔrāA󋵂ɂ߂
	wflag = FALSE;
	halfbytes = m_sndsize / 2;
	if ((!m_sndbank) && (curplay < halfbytes)) {
		wflag = TRUE;
		woffset = halfbytes;
	}
	if (m_sndbank && (curplay > halfbytes)) {
		wflag = TRUE;
		woffset = 0;
	}

	// ݂Kv΁A
	if (wflag) {
		// obt@ĂȂ΁AŖ߂
		AddSnd(TRUE, zeroflag);

		// bN
		hr = m_lpdsb->Lock(woffset, halfbytes, (void **)&ptr1, &size1,
							(void**)&ptr2, &size2, 0);
		// obt@Ă΁AXgA
		if (hr == DSERR_BUFFERLOST) {
			m_lpdsb->Restore();
		}
		// bNȂ΁AĂӖȂ
		if (hr != DS_OK) {
			return;
		}

		// obt@Rs[
		p = m_lpsbuf;
		memcpy(ptr1, p, size1);
		p += size1;
		if (ptr2) {
			memcpy(ptr2, p, size2);
		}

		// AbN
		m_lpdsb->Unlock(ptr1, size1, ptr2, size2);

		// oN]ANA
		m_sndbank = (!m_sndbank);
		m_sndcount = 0;
	}
	else {
		// ǉ
		AddSnd(FALSE, zeroflag);
	}
}

/*
 *	TEh
 *	BEEP
 */
void CXM7Wnd::BeepSnd(int *buf, int samples)
{
	UINT half;
	int i;

	// BEEPo̓`FbN
	if (!beep_flag || !speaker_flag) {
		return;
	}

	// o̓}XN`FbN
	if (!m_bSndBEEP) {
		return;
	}

	// n[tJE^Zo(0.4305ms)
	half = (m_sndrate * 4305) / 10000000;

	for (i=0; i<samples; i++) {
		// Tv
		if (m_beepcount < half) {
			*buf += 0x00000800;
		}
		else {
			*buf -= 0x00000800;
		}
		buf++;

		// JE^]
		m_beepcount++;
		if (m_beepcount >= (half * 2)) {
			m_beepcount = 0;
		}
	}
}

/*
 *	OPNo
 */
extern "C" {
void opn_setb(BYTE reg, BYTE dat)
{
	static BYTE pres = 3;

	if (!pMainWnd->m_pOPN) {
		return;
	}

	/* vXP[̒ */
	if (opn_scale != pres) {
		pres = opn_scale;
		switch (pres) {
			case 2:
				pMainWnd->m_pOPN->SetReg(0x2f, 0);
				break;
			case 3:
				pMainWnd->m_pOPN->SetReg(0x2e, 0);
				break;
		}
	}

	/* OPN}XN */
	if (!pMainWnd->m_bSndOPN) {
		if (reg == 0x28) {
			dat &= 0x0f;
		}
	}

	/* PSG}XN */
	if (!pMainWnd->m_bSndPSG) {
		if ((reg >= 8) && (reg <= 10)) {
			dat = 0;
		}
	}

	/* o */
	pMainWnd->m_pOPN->SetReg((uint8)reg, (uint8)dat);
}
}

#endif	/* _WIN32 */
