/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ Win32 Xe[^Xr[ ]
 */

#ifdef _WIN32
#ifndef _win_view_h_
#define _win_view_h_

/*
 *	萔錾
 */
#define XM7REG_MNAME	"CPU(Main)"
#define XM7REG_SNAME	"CPU(Sub)"
#define XM7REG_WIDTH	17
#define XM7REG_HEIGHT	5
#define IDW_MAINREG		0x4000
#define IDW_SUBREG		IDW_MAINREG+1

#define XM7DIS_MNAME	"DisAssemble(Main)"
#define XM7DIS_SNAME	"DisAssemble(Sub)"
#define XM7DIS_WIDTH	44
#define XM7DIS_HEIGHT	8
#define IDW_MAINDIS		IDW_SUBREG+1
#define IDW_SUBDIS		IDW_MAINDIS+1

#define XM7DUMP_MNAME	"Memory Dump(Main)"
#define XM7DUMP_SNAME	"Memory Dump(Sub)"
#define XM7DUMP_WIDTH	53
#define XM7DUMP_HEIGHT	8
#define IDW_MAINDUMP	IDW_SUBDIS+1
#define IDW_SUBDUMP		IDW_MAINDUMP+1

#define XM7INT_MNAME	"Interrupt(Main)"
#define XM7INT_SNAME	"Interrupt(Sub)"
#define XM7INT_WIDTH	26
#define XM7INT_HEIGHT	10
#define IDW_MAININT		IDW_SUBDUMP+1
#define IDW_SUBINT		IDW_MAININT+1

#define XM7BREAK_NAME	"Break Point"
#define XM7BREAK_WIDTH	15
#define XM7BREAK_HEIGHT	BREAKP_MAX
#define IDW_BREAK		IDW_SUBINT+1

#define XM7VER_NAME		"F-BASIC ROM"
#define XM7VER_WIDTH	20
#define XM7VER_HEIGHT	5
#define IDW_VER			IDW_BREAK+1

#define XM7TTLPAL_NAME	"Digital Palette"
#define XM7TTLPAL_WIDTH	12
#define XM7TTLPAL_HEIGHT 8
#define IDW_TTLPAL		IDW_VER+1

#define XM7MULTI_NAME	"Multi Page"
#define XM7MULTI_WIDTH	24
#define XM7MULTI_HEIGHT	3
#define IDW_MULTI		IDW_TTLPAL+1

#define XM7FDC_NAME		"FDC"
#define XM7FDC_WIDTH	57
#define XM7FDC_HEIGHT	8
#define IDW_FDC			IDW_MULTI+1

#define XM7KNJ_NAME		"Kanji ROM"
#define XM7KNJ_WIDTH	16
#define XM7KNJ_HEIGHT	18
#define IDW_KNJ			IDW_FDC+1

#define XM7TAPE_NAME	"Cassette Tape"
#define XM7TAPE_WIDTH	16
#define XM7TAPE_HEIGHT	6
#define IDW_TAPE		IDW_KNJ+1

#define XM7LP_NAME		"Line Printer"
#define XM7LP_WIDTH		16
#define XM7LP_HEIGHT	3
#define IDW_LP			IDW_TAPE+1

#define XM7OPN_NAME		"OPN"
#define XM7OPN_WIDTH	32
#define XM7OPN_HEIGHT	19
#define IDW_OPN			IDW_LP+1

#define XM7SUB_NAME		"Sub Control"
#define XM7SUB_WIDTH	19
#define XM7SUB_HEIGHT	4
#define IDW_SUB			IDW_OPN+1

#define XM7KBD_NAME		"Keyboard"
#define XM7KBD_WIDTH	18
#define XM7KBD_HEIGHT	9
#define IDW_KEYBOARD	IDW_SUB+1

#define XM7CRT_NAME		"CRT Register"
#define XM7CRT_WIDTH	19
#define XM7CRT_HEIGHT	3
#define IDW_CRT			IDW_KEYBOARD+1

/*-[ AhX̓_CAO ]-----------------------------------------------*/

/*
 *	AhX̓_CAO NX
 */
class CXM7AddrDlg : public CDialog
{
public:
	CXM7AddrDlg(CWnd *pParent, WORD *pAddr);
										// RXgN^
	BOOL OnInitDialog();				// 
	void OnOK();						// I

private:
	WORD *m_pAddr;						// AhXL
};

/*-[ r[EChE ]-----------------------------------------------------*/

/*
 *	r[EChE NX
 */
class CXM7ViewWnd : public CWnd
{
public:
	CXM7ViewWnd(CWnd **pNotify);		// RXgN^
	void PostNcDestroy();				// IuWFNgj
	afx_msg void OnCaptureChanged(CWnd *pCWnd);	// Lv`[ύX
	afx_msg void OnClose();				// N[Y
	afx_msg void OnEnterMenuLoop(BOOL bTrackFlag);
										// j[[vɓ
	afx_msg LONG OnEnterSizeMove(UINT wParam, LONG lParam);
										// ړ[hɓ
	afx_msg void OnSysCommand(UINT nID, LPARAM lParam);
										// VXeR}hs

protected:
	CFont *GetViewFont();				// \ptHg쐬
	void GetFontSize();					// \ptHgTCY̎擾
	void AdjustWindow(int width, int height);
										// EChETCY̕␳
	void StringExt(char *pszStr, int width);
										// ̊g

	CWnd **m_pNotify;					// EChEʒm|C^
	int m_nCharWidth;					// tHghbgTCY
	int m_nCharHeight;					// tHgchbgTCY

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ WX^EChE ]---------------------------------------------------*/

/*
 *	WX^EChE NX
 */
class CXM7RegWnd : public CXM7ViewWnd
{
public:
	CXM7RegWnd(CWnd **pNofity, CWnd *pParent, int cpu);
										// RXgN^
	afx_msg void OnPaint();				// `

private:
	cpu6809_t *m_pReg;					// WX^f[^ւ̃|C^

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ WX^EChE ]---------------------------------------------------*/

/*
 *	tAZuEChE NX
 */
class CXM7DisWnd : public CXM7ViewWnd
{
public:
	CXM7DisWnd(CWnd **pNofity, CWnd *pParent, int cpu);
										// RXgN^
	afx_msg void OnPaint();
										// `
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pScrollBar);
										// XN[
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
										// {^NbN
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
										// _uNbN
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnPC();
										// PCֈړ
	afx_msg void OnGo();
										// AhXw_CAO
	afx_msg void OnFIRQ();
										// FIRQxN^ֈړ
	afx_msg void OnIRQ();
										// IRQxN^ֈړ

	void SetAddr(WORD addr);			// AhXw

private:
	int m_CPU;							// CPU
	WORD m_addr;						// PsڂPC

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ _vEChE ]-----------------------------------------------------*/

/*
 *	_vEChE NX
 */
class CXM7DumpWnd : public CXM7ViewWnd
{
public:
	CXM7DumpWnd(CWnd **pNofity, CWnd *pParent, int cpu);
										// RXgN^
	afx_msg void OnPaint();				// `
	afx_msg void OnVScroll(UINT nSBCode, UINT nPos, CScrollBar *pScrollBar);
										// XN[
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnGo();				// AhXw_CAO
	afx_msg void OnX();					// XWX^w
	afx_msg void OnY();					// YWX^w
	afx_msg void OnU();					// UWX^w
	afx_msg void OnS();					// SWX^w
	afx_msg void OnPC();				// PCWX^w
	afx_msg void OnDP();				// DPy[Ww

	void SetAddr(WORD addr);			// AhXw

private:
	int m_CPU;							// CPU
	WORD m_addr;						// \AhX

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ 荞݃EChE ]---------------------------------------------------*/

/*
 *	荞݃EChE NX
 */
class CXM7IntWnd : public CXM7ViewWnd
{
public:
	CXM7IntWnd(CWnd **pNofity, CWnd *pParent, int cpu);
										// RXgN^
	afx_msg void OnPaint();				// `

private:
	void PaintSub(CDC *pDC, UINT y, char *pszMsg, BOOL req_flag,
		 BOOL mask_flag, WORD irq_flag);// `Tu
	UINT m_CPU;							// CPU

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ u[N|CgEChE ]-------------------------------------------*/

/*
 *	u[N|CgEChE NX
 */
class CXM7BreakWnd : public CXM7ViewWnd
{
public:
	CXM7BreakWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `
	afx_msg void OnLButtonDblClk(UINT nFlags, CPoint point);
										// _uNbN
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
										// NbN
	afx_msg void OnContextMenu(CWnd *pWnd, CPoint point);
										// ReLXgj[
	afx_msg void OnEnable();			// L
	afx_msg void OnDisable();			// 
	afx_msg void OnDelete();			// 폜
	afx_msg void OnClear();				// SăNA

private:
	UINT m_ContextLine;					// ReLXgCfbNX

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ ROMo[WEChE ]----------------------------------------------*/

/*
 *	ROMo[WEChE NX
 */
class CXM7VerWnd : public CXM7ViewWnd
{
public:
	CXM7VerWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ TTLpbgEChE ]------------------------------------------------*/

/*
 *	TTLpbgEChE NX
 */
class CXM7TTLPalWnd : public CXM7ViewWnd
{
public:
	CXM7TTLPalWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ }`y[WEChE ]-----------------------------------------------*/

/*
 *	}`y[WEChE NX
 */
class CXM7MultiWnd : public CXM7ViewWnd
{
public:
	CXM7MultiWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ FDCEChE ]--------------------------------------------------------*/

/*
 *	FDCEChE NX
 */
class CXM7FDCWnd : public CXM7ViewWnd
{
public:
	CXM7FDCWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `
	void Space(CDC* pDC, UINT x, UINT y, UINT width, UINT height);
										// Xy[X`
	void RegSub(CDC* pDC, UINT x, UINT y);
										// WX^n
	void CmdSub(CDC* pDC, UINT x, UINT y);
										// R}hn
	void StatSub(CDC* pDC, UINT x , UINT y);
										// Xe[^Xn

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ ROMEChE ]----------------------------------------------------*/

/*
 *	ROMEChE NX
 */
class CXM7KnjWnd : public CXM7ViewWnd
{
public:
	CXM7KnjWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ JZbge[vEChE ]---------------------------------------------*/

/*
 *	JZbge[vEChE NX
 */
class CXM7TapeWnd : public CXM7ViewWnd
{
public:
	CXM7TapeWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ Cv^EChE ]---------------------------------------------*/

/*
 *	Cv^EChE NX
 */
class CXM7LPWnd : public CXM7ViewWnd
{
public:
	CXM7LPWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ OPNEChE ]--------------------------------------------------------*/

/*
 *	OPNEChE NX
 */
class CXM7OPNWnd : public CXM7ViewWnd
{
public:
	CXM7OPNWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ TuCPURg[EChE ]----------------------------------------*/

/*
 *	TuCPURg[EChE NX
 */
class CXM7SubWnd : public CXM7ViewWnd
{
public:
	CXM7SubWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ L[{[hEChE ]-------------------------------------------------*/

/*
 *	L[{[hEChE NX
 */
class CXM7KbdWnd : public CXM7ViewWnd
{
public:
	CXM7KbdWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

/*-[ CRTWX^EChE ]------------------------------------------------*/

/*
 *	CRTWX^EChE NX
 */
class CXM7CRTWnd : public CXM7ViewWnd
{
public:
	CXM7CRTWnd(CWnd **pNofity, CWnd *pParent);
										// RXgN^
	afx_msg void OnPaint();				// `

	DECLARE_MESSAGE_MAP()				// bZ[W }bv
};

#endif	/* _win_view_h_ */
#endif	/* _WIN32 */
