/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 * [ X680x0 ]
 */

#ifdef HUMAN68K

#ifndef _68k_h_
#define _68k_h_

/*
 *	荞݃}N
 */
#define _push()					asm("	move.w	sr,-(sp)");
#define _disable()				asm("	ori.w	#$0700,sr");
#define _pop()					asm("	move.w	(sp)+,sr");

/*
 * vg^Cv錾
 */
#ifdef __cplusplus
extern "C" {
#endif

/* DOS,IOCSbv֐(68k_sub.c) */
int dos_print(char *s);
										/* \ */
int dos_cpumode(int usp);
										/* X[pE[U؂ւ */
int dos_conmode(int mode);
										/* R\[[hݒE擾 */
int dos_funcmode(int mode);
										/* t@NVL[ݒE擾 */
int dos_curon(void);
										/* J[\on */
int dos_curoff(void);
										/* J[\off */
int dos_open(char *fname, int mode);
										/* t@CI[v */
int dos_read(int handle, void *buf, int size);
										/* t@Cǂݍ */
int dos_write(int handle, void *buf, int size);
										/* t@C */
int dos_close(int handle);
										/* t@CN[Y */
int dos_seek(int handle, int offset, int type);
										/* t@CV[N */
void *dos_malloc(int size);
										/* m */
int dos_mfree(void *ptr);
										/*  */
int iocs_mson(void);
										/* }EXJ[\on */
int iocs_msoff(void);
										/* }EXJ[\off */
int iocs_msstat(void);
										/* }EXJ[\Ԏ擾 */

/* \(68k_disp.c) */
BOOL disp_init(void);
										/*   */
void disp_cleanup(void);
										/*  N[Abv */
void disp_crtc(BOOL crtc24_flag);
										/*  CRTCݒ */

/* L[{[h(68k_kbd.c) */
BOOL kbd_init(void);
										/* L[{[h  */
void kbd_cleanup(void);
										/* L[{[h N[Abv */
void kbd_timer(void);
										/* L[{[h 10ms^C} */

/* ̑(68k_etc.c) */
BOOL timer_init(void);
										/* ^C}[  */
void timer_cleanup(void);
										/* ^C}[ N[Abv */
void timer_entry(void);
										/* Vnh */
void timer_int(void);
										/* 荞ݏ */
void timer_norm(void);
										/* ʏ폈 */

/*
 *	O[o[N
 */
extern BOOL disp_crtc_mode;
										/* 24k,31k [h */
extern BYTE timer_mul;
										/* ^C}[{ */
extern BOOL timer_flag;
										/* ^C}[tO */
extern DWORD boot_timer;
										/* TIMER-C IWixN^ */
extern BYTE kbd_map[0x80];
										/* L[{[h }bv */
#ifdef __cplusplus
}
#endif

#endif	/* _68k_h_ */
#endif	/* HUMAN68K */
