/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ X680x0 ̑ ]
 */

#ifdef HUMAN68K

#include <string.h>
#include "xm7.h"
#include "gui.h"
#include "68k.h"
#include "mainetc.h"

/*
 *	O[oϐ
 */
DWORD boot_timer;					/* NTIMER-CxN^ */
BYTE timer_mul;						/* ^C}[{ */
BOOL timer_flag;					/* ^C}[tO */

/*
 *	X^eBbNϐ
 */
static BYTE timer_mul_cnt;			/* {JE^ */
static BYTE timer_nmi_cnt;			/* NMI荞݃JE^ */

/*
 *	^C}[ 
 */
int timer_init(void)
{
	DWORD *p;

	/* ^C}[萔 */
	timer_mul_cnt = timer_mul;
	timer_nmi_cnt = 6;
	timer_flag = FALSE;

	/* 荞݃xN^ݒ */
	p = (DWORD *)(0x000114);
	_push();
	_disable();
	boot_timer = *p;
	*p = (DWORD)timer_entry;
	_pop();

	return TRUE;
}

/*
 *	^C}[ N[Abv
 */
void timer_cleanup(void)
{
	DWORD *p;

	/* 荞݃xN^A */
	p = (DWORD *)(0x000114);
	_push();
	_disable();
	*p = boot_timer;
	_pop();
}

/*
 *	^C}[ 荞ݏ
 */
void timer_int(void)
{
	if (gui_flag) {
		timer_norm();
	}
	else {
		timer_flag = TRUE;
	}
}

/*
 *	^C}[ ʏ폈
 */
void timer_norm(void)
{
	/* L[{[h */
	kbd_timer();

	/* { */
	timer_mul_cnt--;
	if (timer_mul_cnt != 0) {
		/* ^C}[{ݒ肳Ă̂ŁACPUx */
		maincpu.total = 0;
		return;
	}

	/* {Zbg */
	timer_mul_cnt = timer_mul;

	/* NMI */
	timer_nmi_cnt--;
	if (timer_nmi_cnt == 0) {
		timer_nmi_cnt = 2;
		subcpu_nmi();
	}

	/* IRQ */
	mainetc_timer();
}

/*
 *	OPNo
 */
void opn_setb(BYTE reg, BYTE dat)
{
}

/*
 *	WCXeBbN
 */
BYTE joy_getb(BYTE index)
{
	BYTE dat;
	BYTE tmp;

	if (index == 0) {
		dat = *(BYTE *)(0xe9a001);
	}
	else {
		dat = *(BYTE *)(0xe9a003);
	}

	dat = ~dat;
	tmp = dat >> 1;
	dat &= 0x0f;
	tmp &= 0x30;

	return dat | tmp;
}

#endif	/* HUMAN68K */
