/*
 *	FM-7 EMULATOR "XM7"
 *
 *	Copyright (C) 1999,2000 ohD(ytanaka@ipc-tokai.or.jp)
 *	[ X680x0 C ]
 */

#include <string.h>
#include "xm7.h"
#include "display.h"
#include "ttlpalet.h"
#include "subctrl.h"
#include "fdc.h"
#include "gui.h"
#include "68k.h"

/*
 *	O`
 */
extern void _main(void);

/*
 *	O[o [N
 */
BYTE *cmdline;

/*
 *	X^eBbN [N
 */
static BYTE fname_drv0[128];
static BYTE fname_drv1[128];

/*
 *	G[
 */
void dos_error(char *msg)
{
	char *title;

	title = (char *)(_main);
	dos_print(title + 6);
	dos_print(msg);
	dos_print("\n");
}

/*
 *	gdko
 */
void usage(void)
{
	char *title;

	title = (char *)(_main);
	dos_print(title + 6);
	dos_print("Usage:XM7.x [-option] [/option] filename1 filename2\n");
	dos_print("  -m         荞ݎ{(default:-m5)\n");
	dos_print("  -h         24k[h(default:31k)\n");
	dos_print("  filename1  hCuOɃZbgfBXN\n");
	dos_print("  filename2  hCuPɃZbgfBXN\n");
}

/*
 *	R}hC
 */
BOOL arg(void)
{
	BYTE *src;
	BYTE *dst;
	BYTE dat;
	int mul;

	/* [NGA */
	disp_crtc_mode = FALSE;
	timer_mul = 5;
	fname_drv0[0] = '\0';
	fname_drv1[0] = '\0';

	/* R}hC擾 */
	src = cmdline;
	dat = *src++;
	if (dat == 0) {
		/* R}hCȂ */
		return TRUE;
	}

	while ((dat = *src) >= 0x20) {
		/* Xy[X͔΂ */
		if (dat == 0x20) {
			src++;
			continue;
		}

		/* '-' , '/' `FbN */
		if ((dat == '-') || (dat == '/')) {
			src++;
			dat = *src;
			switch (dat) {

				/* 荞ݔ{ */
				case 'M':
				case 'm':
					src++;
					mul = 0;

					while ((*src >= '0') && (*src <= '9')) {
						mul = mul * 10 + (*src - '0');
						src++;
					}
					if (mul == 0) {
						return FALSE;
					}
					timer_mul = mul;
					continue;

				/* 24k[h */
				case 'H':
				case 'h':
					src++;
					disp_crtc_mode = TRUE;
					continue;

				/* 蓖ăIvV */
				default:
					return FALSE;
			}
		}

		/* hCu0 or hCu1 */
		if (fname_drv0[0] == '\0') {
			dst = fname_drv0;
		}
		else {
			if (fname_drv1[0] == '\0') {
				dst = fname_drv1;
			}
			else {
				return FALSE;
			}
		}

		/* Xy[XȏオRs[ */
		while (*src > 0x20) {
			*dst++ = *src++;
		}
		/* I[ݒ */
		*dst = '\0';
	}

	return TRUE;
}

/*
 *	C
 */
int main(void)
{
	int boot_stack;
	int ret;

	/* ߂l */
	ret = 0;

	/* R}hC */
	if (!arg()) {
		usage();
		return 1;
	}

	/* X[p[oCU */
	boot_stack = dos_cpumode(0);

	if (system_init()) {
		disp_init();
		timer_init();
		kbd_init();

		system_reset();
		if (fname_drv0[0]) {
			fdc_setdisk(0, fname_drv0);
		}
		if (fname_drv1[0]) {
			fdc_setdisk(1, fname_drv1);
		}
		else {
			if ((fdc_ready[0] == FDC_TYPE_D77) && (fdc_medias[0] >= 2)) {
				fdc_setdisk(0, fname_drv0);
				fdc_setmedia(1, 1);
			}
		}

		debug_run();
		system_cleanup();

		kbd_cleanup();
		timer_cleanup();
		disp_cleanup();
	}
	else {
		dos_error("ROMt@C܂");
		ret = 1;
	}

	/* [U[h */
	dos_cpumode(boot_stack);

	return ret;
}

/*
 *	Cxg
 */
void do_events(void)
{
	/* OPT1,OPT2`FbN */
	if ((kbd_map[0x72] || kbd_map[0x73])) {
		gui_start();
		return;
	}

	/* ^C}[`FbN */
	if (timer_flag) {
		timer_norm();
		timer_flag = FALSE;
	}
}

