/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

// This module contains a few Input file parsing routines used for
// parsing XML files. Most importantly, it keeps track of the line number

#ifndef __FILEPARSER_HPP__
#define __FILEPARSER_HPP__

#include "Input.hpp"

class FileParser : public Input
{
   unsigned curlineno;  // The current line number

public:
	FileParser(Session *s);
	~FileParser();

   char OpenFile(char *filename);
   unsigned GetCurLineNo();

   char ReadStringUntil(char **destptr,int *destlen,char stopatwspace,char c1,char c2);
		// This function scans ahead in the buffer until some character c1 or c2 occurs
		// If 'stopwspace=1', then we also stop at the first white space detected.
		// In this case, *destptr and *destlen will contain the pointer and length
		// of the buffer *with* the character c1 or c2 and the functions returns 1.
		// If a white space has been detected, then the function also returns 1,
		// but the white-space is *not* included in the length.
		// If the function couldn't find such a character in the current buffer, we try to refill
		// If it is still not found, then the function returns the current buffer in *destptr and *destlen
		// and returns 0.

   char ReadStringUntil(char **destptr,int *destlen,char c1);
      // This function scans ahead in the buffer until some character c1 occurs
      // In this case, *destptr and *destlen will contain the pointer and length
      // of the buffer *with* the character and the functions returns 0.

      // If the function couldn't find such a character in the current buffer, we try to refill
      // If it is still not found, then the function returns the current buffer in *destptr and *destlen
      // and returns 0.

   char ReadWhiteSpaces(char **destptr,int *destlen);
      // This function scans ahead in the buffer over all white-spaces
      // *destptr and *destlen will contain the pointer and length
      // of the buffer with the white-spaces

      // If the buffer got fill without reaching a non-whitespace character,
      // then the function returns the current buffer in *destptr and *destlen
      // and returns 1. Otherwise, 

   char ReadStringUntil(char **destptr,int *destlen,char *searchstr);
		// This function scans ahead in the buffer until string 'searchstr'
		// is reached. In this case, *destptr and *destlen will contain the pointer and length
		// of the buffer *with* the search string at the end and the functions returns 0.
		// If the function couldn't find such a character in the current buffer, we try to refill
		// If it is still not found, then the function returns the current buffer in *destptr and *destlen
		// and returns 1.

   char SkipChar();
      // Skips the next character

   char GetChar(char *c);
      // Reads the next character

   void SkipData(int len);
      // Skips 'len' characters
};

#endif /* __FILEPARSER_HPP__ */
