/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************
// This module contains the output file management

#ifndef __OUTPUT_HPP__
#define __OUTPUT_HPP__

#include <string.h>
#include <stdlib.h>

#ifndef WIN32
#include <unistd.h>
#else
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#endif

#include "Types.hpp"
#include "Error.hpp"

char FileExists(char *filename);
void RemoveFile(char *filename);

class Settings;

// For now, we do not have a static implementation
//#define SET_OUTPUT_STATIC

#ifdef SET_OUTPUT_STATIC
	#define OUTPUT_STATIC static
#else
	#define OUTPUT_STATIC
#endif

class Output
{
protected:
	Settings *settings;
   OUTPUT_STATIC FILE  *output;        // The output file handler
   OUTPUT_STATIC char  *buf;           // the output buffer
   OUTPUT_STATIC char  *savefilename;  // the name of the output file
   OUTPUT_STATIC int   bufsize,curpos; // buffer size and current position
   OUTPUT_STATIC int   overallsize;    // the accumulated size of the output data
	int maxlen;

public:
	Output(Settings *settings);

	void setMaxLength(int mlen);

	virtual char /*OUTPUT_STATIC*/ myCreateFile(char *filename,int mybufsize=65536);
   virtual void OUTPUT_STATIC CloseFile();
   virtual void OUTPUT_STATIC CloseAndDeleteFile();
   virtual void OUTPUT_STATIC Flush();

   char OUTPUT_STATIC *GetBufPtr(int *len);
   void OUTPUT_STATIC SaveBytes(int bytecount);
	int OUTPUT_STATIC GetCurFileSize();
	void OUTPUT_STATIC StoreData(char *ptr,int len);
   void OUTPUT_STATIC StoreInt32(int val);
   void OUTPUT_STATIC StoreChar(char c);
   void OUTPUT_STATIC StoreNewline();
   char OUTPUT_STATIC *GetDataPtr(int len);
};

class MemOutput: public Output
{
	char **memorybuffer;
	int *bufferlength;

	char *totalbuffer;
	int totalbuflen;

public:
	MemOutput(Settings *settings) : Output(settings) {};

   // Creates the output file. If 'filename==NULL', then the standard
   // output is used.
   virtual char OUTPUT_STATIC myCreateFile(char **membuf,int *buflen=NULL,int mybufsize=65536);

	// Writes the remaining output to the file and closes the file
   virtual void OUTPUT_STATIC CloseFile();

	// Writes the remaining data and closes the file and removes it
   virtual void OUTPUT_STATIC CloseAndDeleteFile();

	// Flushes the output file
   virtual void OUTPUT_STATIC Flush();
};

#endif /* __OUTPUT_HPP__ */
