/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

#include "stdafx.h"

/* some C functions */
// An auxiliary function to identify the end of a string
char *ParseString(char *from,char *to)
{
   if(*from!='"')
      return NULL;

   from++;

   while(from<to)
   {
		if (*from=='"') {
         return from;
		} else if (*from=='\\') {
			/* escaping */
         from++;
		}
      from++;
   }

   XMillException *e = new XMillException(XMILL_ERR_PARSE, "String constant \"...\" expected instead of '");
   e->ErrorCont(from,to-from);
   throw e;
	/* dummy return */
   return NULL;
}

char *SkipWhiteSpaces(char *ptr,char *endptr)
   // Skips white spaces starting at *ptr and returns the
   // the pointer to the first non-white-space character.
   // The iteration stops if 'endptr' is reached.
{
   while((ptr<endptr)&&
         ((*ptr==' ')||(*ptr==',')||(*ptr=='\t')||(*ptr=='\r')||(*ptr=='\n')))

      ptr++;

   return ptr;
}

/* class UserCompressor implementation */
UserCompressor::UserCompressor(Session *s)
{
	SetSession(s);
}

void UserCompressor::SetSession(Session *s)
{
	session = s;
}

#ifdef NOTHREAD
void *UserCompressor::operator new(size_t size)  
{  
	return ::session->mainmem->GetByteBlock(size);
}
void UserCompressor::operator delete(void *ptr)  {}
#endif

// The following functions must be overloaded by the corresponding
// user compressor

unsigned short UserCompressor::GetUserContNum()  {  return contnum;      }
unsigned short UserCompressor::GetUserDataSize() {  return datasize;     }
unsigned char UserCompressor::IsRejecting()      {  return (unsigned char)isrejecting;  }
unsigned char UserCompressor::CanOverlap()       {  return (unsigned char)canoverlap;   }
unsigned char UserCompressor::IsFixedLen()       {  return (unsigned char)isfixedlen;   }

/***************************************************************/

UserUncompressor::UserUncompressor(Session *s)
{
	session = s;
}

#ifdef NOTHREAD
void *UserUncompressor::operator new(size_t size)  
{  
	return ::session->mainmem->GetByteBlock(size);
}
void UserUncompressor::operator delete(void *ptr)  {}
#endif

unsigned short UserUncompressor::GetUserContNum()  {  return contnum;      }
unsigned short UserUncompressor::GetUserDataSize() {  return datasize;     }

