/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

History:

      24/11/99  - initial release by Hartmut Liefke, liefke@seas.upenn.edu
                                     Dan Suciu,      suciu@research.att.com
*/

//**************************************************************************
//**************************************************************************

// This module contains the XML-Parser. Based on class 'FileParser',
// the XML parser implements functions for finding and parsing elements and attributes
// the events are handled through an SAX-like interface called SAXClient

#ifndef __XMLPARSE_HPP__
#define __XMLPARSE_HPP__

#include "Error.hpp"
#include "FileParser.hpp"
#include "SAXClient.hpp"

class SAXClient;
class MemFile;

class XMLParse : public FileParser
{ 
   SAXClient *saxclient;   // the event-receiving client
	char islastblock;

public:
	XMLParse(Session *s);
	~XMLParse();

   // This is the main parse function
   char DoParsing(SAXClient *myclient);

	// Writes a parser error and exits
   void XMLParseError(char *errmsg);

	// Writes a parser error and exits
   void XMLParseError(char *errmsg,int savelineno);

	void SetLastBlock();
	void ResetLastBlock();

private:
   char SkipWhiteSpaces(char *isokay);

	// This function scans the attributes in a given start label
   // The returns as soon as the trailing '>' is reached
   char ParseAttribs(char *isokay);

	// Scans a label after the '<' has already been parsed.
   char ParseLabel();

	// Parses a processing instruction
   char ParsePI();

	// Parses a CDATA section
   char ParseCDATA();

	// Parses a comment section
   char ParseComment();

	// Parses some text data
   char ParseText();

	// Parses a DOCTYPE section.
   // A DOCTYPE has format <!DOCTYPE ... >  or  <!DOCTTYPE ... [ ... ] >
   char ParseDOCTYPE();

	char IsLastBlock();
};

class XMLMemParse: public XMLParse
{
	MemFile *memfile;

public:
	XMLMemParse(Session *s);
	XMLMemParse(Session *s, char *b, int len = 0);
	~XMLMemParse();

	void setData(char *b, int len = 0);
};

#endif /* __XMLPARSE_HPP__ */
