// main.cpp : XMI file inspector main
//

#include "stdafx.h"

#ifdef WIN32
int _tmain(int argc, _TCHAR* argv[])
#else
int main(int argc, char* argv[])
#endif
{
	int stat = 0;
	XMIInspect *inspector = NULL;

	if (argc < 3) {
		/* note: level 0 means no output at all, 9 means full debug info. values 3-7 provide the most useful info. */
		printf ("usage: %s level file1 file2 ..\n", argv[0]);
		stat = -1;
		goto cleanup;
	}

	inspector = new XMIInspect(atoi(argv[1]));

	try {
		for (int i=2; i<argc; i++) {
			inspector->reset();
			if ((stat = inspector->inspectFile(argv[i])) != 0) {
				goto cleanup;
			}
		}
	} catch (...) {
		printf("An exception occurred!\n");
		stat = XMIINS_ERR_EXCEPTION;
	}

cleanup:
	trydel (inspector);

	return stat;
}

