/*
This product contains certain software code or other information
("AT&T Software") proprietary to AT&T Corp. ("AT&T").  The AT&T
Software is provided to you "AS IS".  YOU ASSUME TOTAL RESPONSIBILITY
AND RISK FOR USE OF THE AT&T SOFTWARE.  AT&T DOES NOT MAKE, AND
EXPRESSLY DISCLAIMS, ANY EXPRESS OR IMPLIED WARRANTIES OF ANY KIND
WHATSOEVER, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, WARRANTIES OF
TITLE OR NON-INFRINGEMENT OF ANY INTELLECTUAL PROPERTY RIGHTS, ANY
WARRANTIES ARISING BY USAGE OF TRADE, COURSE OF DEALING OR COURSE OF
PERFORMANCE, OR ANY WARRANTY THAT THE AT&T SOFTWARE IS "ERROR FREE" OR
WILL MEET YOUR REQUIREMENTS.

Unless you accept a license to use the AT&T Software, you shall not
reverse compile, disassemble or otherwise reverse engineer this
product to ascertain the source code for any AT&T Software.

(c) AT&T Corp. All rights reserved.  AT&T is a registered trademark of AT&T Corp.

***********************************************************************

Description:

		Program to test the in-memory API to the XMill (de)compression routines

History:

      10/11/2002  - created by Hedzer Westra <hedzer@adlibsoft.com>

*/

#include "stdafx.h"

#define tryfree(c) {if (c) {free(c); c=NULL;}}

#define MAXFILES 100

#define BUFLEN 1024
#ifndef STRLEN
	#define STRLEN 4096
#endif

#define TEST_COMPDECOMP		1
#define TEST_DECOMP			2
#define TEST_TARGETSIZE		3

#define TEST_ERROR_NONE				0
#define TEST_ERROR_TARGETSIZE		-1
#define TEST_ERROR_NOEXACTMATCH	-2
#define TEST_ERROR_NOIGNMATCH		-3
#define TEST_ERROR_MODE				-4
#define TEST_ERROR_FILE				-5
#define TEST_ERROR_FOUND			-6

#define TEST_STATS_NONE		0
#define TEST_STATS_ERR		1
#define TEST_STATS_WARN		2
#define TEST_STATS_TIMING  3
#define TEST_STATS_BPCTIME 4
#define TEST_STATS_ALL		5

class testsettings {
	bool lossy;
	char bzip;
	int mode;
	bool exprs;
	XMill *xmill;
	char stats;
	bool ignorewhite;
	unsigned int blocksize;
	bool mustfail;
   int gpcidx;

	int compdecomp(char *buffer, int buflen, char *filename, int targetsize, clock_t *t2t, clock_t *t3t, 
                  int *xmibuflen, bool isFirst);

public:
	int times;

	testsettings();
	~testsettings();

	int parsesetting(char *s, char *s1 = NULL, bool *usedboth = NULL);
	int run(char **files, int numfiles);
	int run(FILE *script);

	int rundecomp(char *xmlfile, char *xmifile, int times);
	int runcompdecomp(char *filename, int targetsize = 0);
	int runcomptarget(char *filename, int targetsize);

	int checkintegrity(char *buffer, int buflen, char *xmlbuf, int xmlbuflen);
	void setstats(char stats);
};
