/*
 * XML Catalog Manager (xmlcatmgr)
 * $Id: xmldoc.h,v 1.1 2004/08/31 19:07:23 jmmv Exp $
 *
 * Copyright (c) 2003, 2004 Julio M. Merino Vidal.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 * 3. Neither the name of the author nor the names of contributors may
 *    be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef XMLCATMGR_XMLDOC_H
#define XMLCATMGR_XMLDOC_H

#include "linklist.h"
#include "xmlnode.h"

struct doctype {
    char *dt_text;
};

struct xmldoc {
    struct doctype *xd_doctype;
    struct xmlattrs xd_attrs;
    struct xmlnodes xd_nodes;
    struct xmlnode *xd_root;
};

#define XMLDOC_FOREACH_NODE(iter, doc) \
    LINKLIST_FOREACH(iter, &((doc)->xd_nodes))

#define XMLDOC_ROOT(doc) ((doc)->xd_root)

struct xmldoc *xmldoc_new(const char *);
struct xmldoc *xmldoc_parse(FILE *);
void xmldoc_free(struct xmldoc *);
bool xmldoc_write(struct xmldoc *, FILE *);
void xmldoc_append_node(struct xmldoc *, struct xmlnode *);

#endif /* XMLCATMGR_XMLDOC_H */

/*
 * Local Variables: ***
 * mode: c ***
 * c-file-style: "stroustrup" ***
 * End: ***
 * vim: syntax=c:expandtab:shiftwidth=4:softtabstop=4
 */
