/*
 * Copyright 1991-1997, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   ig.h								*
*									*
*	Icon grid.							*
*									*
************************************************************************/
/*** VERSION 0.09 ***/
/*
**	Portability
*/
#if defined(_AIX) || defined(__SVR4) || defined(SVR4)
#define uchar_t uchar__t
#define ushort_t ushort__t
#define uint_t uint__t
#define ulong_t ulong__t
#endif

#define IconSelected(icon)	((icon)->selected)
#define IconTag(icon)		((icon)->tag)
#define IconState(icon)		((icon)->state)
#define IconData(icon)		((icon)->data)

/*
**	Types
*/
typedef unsigned char uchar_t;
typedef unsigned short ushort_t;
typedef unsigned int uint_t;
typedef unsigned long int ulong_t;

typedef struct _IconGrid *IconGrid;
typedef struct _IGView *IGView;

typedef void (*IGproc)();

/*
**	node in icon list
*/
typedef struct _IGIcon {
   char *		tag;
   int			taglen;
   int			cliptaglen;
   uint_t		tagwidth;
   int			state;
   int			selected;
   int			row, col;
   void *		data;
   struct _IGIcon *	prev;
   struct _IGIcon *	next;
}IGIcon;

IconGrid ig_init();
void ig_realize();
IGView ig_register_view();
int ig_register_image_data();
int ig_register_image_file();
int ig_register_image();
void ig_set_view();
IGIcon *ig_add_icon();
void *ig_set_data();
IGIcon *ig_find_icon();
void ig_change_state();
void ig_select();
void ig_unselect();
void ig_remove_icon();
void ig_call_callback();
void ig_refresh();
void ig_clear();
void ig_down();
void ig_move();
void ig_up();
void ig_expose();
void ig_configure();
void ig_resize();
