/*
 * Copyright 1991-1997, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   layout.c								*
*									*
*	Read a layout file.						*
*									*
************************************************************************/
#include <sys/stat.h>
#include <fcntl.h>

#include <stdio.h>
#include "layout.h"

int
layout_file(filename, rtn)
   char *filename;
   layoutproc_t rtn;
{
   int fd, rv = -1;
   struct stat st;
   char *bp = 0;

   if ((fd = open(filename, O_RDONLY)) >= 0) {
      if (fstat(fd, &st) == 0)
         if (bp = (char *)malloc(st.st_size + 1)) {
            if (read(fd, bp, st.st_size) == st.st_size) {
               bp[st.st_size] = '\0';
               rv = layout_data(bp, rtn);
            }
            free(bp);
         }
      close(fd);
   }
   return rv;
}

int
layout_data(str, rtn)
   char *str;
   layoutproc_t rtn;
{
   register char *cp, *dp, tc;
   register int row, col;

   row = col = 0;
   for (cp=str; *cp;) {
      switch (*cp) {
         case ' ':
         case '\t':
            cp++;
            break;
         case '\n':
            /* mark new line */;
            if (col) {
               row++;
               col = 0;
            }
            cp++;
            break;
         case '#':
            while (*cp && *cp!='\n')
               cp++;
            break;
         default:
            for (dp=cp; *dp &&
			*dp != ' ' &&
			*dp != '\t' &&
			*dp != '\n' &&
			*dp != '#'; dp++);
            tc = *dp;
            *dp = '\0';
            (*rtn)(cp, row, col++);
            *dp = tc;
            cp = dp;
            break;
      }
   }
   (*rtn)(0, 0, 0);
}
