/*
 * Copyright 1991-1997, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#define OPEN_PROMPT "Open file:"
#define SAVE_PROMPT "Save to file:"
#define ADD_PROMPT "Add display:"
#define DROP_PROMPT "Really drop displays?"

typedef struct {
   Widget	top;
   Widget	shell;
}popup_t;

typedef struct {
   Widget	top;	/* must match popup_t */
   Widget	shell;	/* must match popup_t */
   Widget	dialog;	/* could be a Form or a Dialog */
   Widget	enable;
   Widget	accept;
   Widget	cancel;
}dialog_t;

typedef struct {
   Widget	top;	/* must match popup_t */
   Widget	shell;	/* must match popup_t */
   Widget	form;
   Widget	text;
   Widget	dismiss;
}error_t;

typedef struct {
   Widget	input;
   Widget	mode_radio;
}add_d_t;

void ui_create();
void ui_create_radio();
void ui_create_pulldown();
void ui_create_dialog();
void ui_create_dialog_dismiss();
error_t *ui_create_error();
char *ui_get_dialog_string();
void ui_get_add_info();
void ui_free_add_info();
void ui_free_string();
