/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
#include <xmc.h>
#include <xmclib.h>
#include <xmcp.h>
#include "common.h"

TptrId
XmcCreateGlyphTptr
   AL((muxp, disp_mask, src_font, mask_font, src_char, mask_char,
							fgcolor, bgcolor))
   DB Mux *muxp
   DD unsigned int disp_mask
   DD XId src_font
   DD XId mask_font
   DD unsigned int src_char
   DD unsigned int mask_char
   DD XmcColor *fgcolor
   DD XmcColor *bgcolor
   DE
{
   xmcCreateGlyphTptrReq *p;

   p = (xmcCreateGlyphTptrReq *)Xmc_allocout(muxp, sz_xmcCreateGlyphTptrReq);

   p->code = XMC_CreateGlyphTptr;
   p->mask = disp_mask;
   p->length = sz_xmcCreateGlyphTptrReq;
   p->srcID = src_font;
   p->mskID = mask_font;
   p->srcChar = src_char;
   p->mskChar = mask_char;
   if (fgcolor) {
      p->foreRed = fgcolor->red;
      p->foreGreen = fgcolor->green;
      p->foreBlue = fgcolor->blue;
   }
   if (bgcolor) {
      p->backRed = bgcolor->red;
      p->backGreen = bgcolor->green;
      p->backBlue = bgcolor->blue;
   }
   muxp->outseqno++;
}
