/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   es.c								*
*									*
*	Event stamp routines.  For marking chunks containing events	*
*	with housekeeping info (for managing sequence number mapping).	*
*									*
************************************************************************/
#include "xmx.h"
#include "es.h"
#include "incl/es.pvt.h"

void
es_mark
   AL((bp))
   DB buffer_t *bp
   DE
{
   register int i;
   register chunk_t *chp;

   chp = buf_chunk(bp);

   if (chp->type == P_EVENT) {	/* can be called repeatedly on same chunk */
      i = (int)chp->dptr;
      chp->dptr = (void *)(i + 1);
   }
   else if (chp->type == P_NONE) {
      chp->type = P_EVENT;
      chp->dptr = (void *)1;
   }
   else
      warn("es_mark: chunk has type %s!\n", debug_proto_type_str(chp->type));
}

void
es_unmark
   AL((chp))
   DB chunk_t *chp
   DE
{
   if (chp->type == P_EVENT)
      chp->type = P_NONE;
}
