/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   image.h								*
*									*
************************************************************************/
/*
**  Iords encode all 51 possible image formats:
**
**    XY format
**
**	12 XYtype's * 3 scan_pad's = 36 iords
**		 _ _ _ _ _ _ _
**	bits -> |_|_|_|_|_|_|_|
**		 | \ / \ / | |
**		 |  |   |  | * bit order {0,1}  \
**		 |  |   |  * byte order {0,1}    > XYtype
**		 |  |   * scan_unit {00,10,01}  /
**		 |  * scan_pad {00,10,01}
**		 * format {0}
**    Z format
**
**	5 Ztype's * 3 scan_pad's = 15 iords
**		 _ _ _ _ _ _ _
**	bits -> |_|_|_|_|_|_|_|
**		 | \ / | \   /
**		 |  |  |   |
**		 |  |  |   * bpp {000,001,010,011,100} > Ztype
**		 |  |  * unused {0}
**		 |  * scan_pad {00,10,01}
**		 * format {1}
*/
#define IMINC		4		/* allocate 4 images at a time */
#define NO_XYS		36
#define NO_ZS		15
#define MAX_XY		43		/* binary 101011 (32/32/msb/msb) */
#define MAX_Z		36		/* binary 100100 (32bpp) */
#define XY_SZ		(MAX_XY + 1)	/* XY array size */
#define Z_SZ		(MAX_Z + 1)	/* Z array size */
#define IMDEX_SZ	XY_SZ

#define MAXBPP	32			/* an X protocol invariant */

#define ZBIT			0x40	/* ZPixmap if set */
#define XYTYPE_MASK		0x0f	/* gets xytype from iord */
#define ZTYPE_MASK		0x07	/* gets ztype from iord */
#define TYPE_MASK		0x0f	/* gets either of above */
#define IMDEX_MASK		0x3f	/* gets image index from iord */

#define XYTYPE(bit,byte,unit)	((bit)+(byte)*2+((unit)/16)*4)
#define ZTYPE(bpp)		((bpp)/8)
#define XYIORD(XYtype,scan_pad)	((XYtype)+((scan_pad)/16)*16)
#define ZIORD(Ztype,scan_pad)	(ZBIT+(Ztype)+((scan_pad)/16)*16)

#define IORD_ZBPP(iord)		(((iord)&ZTYPE_MASK)?((iord)&ZTYPE_MASK)*8:4)
#define IORD_PAD(iord)		(((iord)&0x30)?((iord)&0x30):8)
#define IORD_ZTYPE(iord)	((iord)&ZTYPE_MASK)
#define IORD_XYTYPE(iord)	((iord)&XYTYPE_MASK)

#define IORD_IMDEX(iord)	((iord)&IMDEX_MASK)
#define IORD_TYPE(iord)		((iord)&TYPE_MASK)
/*
**	bytes per scanline
*/
#define BPS(width,bpp,pad)	((((width)*(bpp)+((pad)-1))/(pad))*(pad)/8)

typedef struct _imlist_t {
   u8_t		refs;			/* in use? */
   u8_t		depth;			/* depth of image */
   iord_t	source;			/* current source image */
   uint_t	width;			/* width of image (x + left_pad) */
   uint_t	scanlines;		/* number of scanlines */
   buffer_t *	bp;			/* buffer from which to allocate */
   chunk_t *	chp[IMDEX_SZ];		/* array of image chunks */
   struct _imlist_t *	next;
}imlist_t;
