/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   rx.h								*
*									*
************************************************************************/
#define rx_q(cp)		((cp) ? (cp)->rxqp : zrxqp)
#define rx_major(rxp)		((rxp)->major)
#define rx_minor(rxp)		((rxp)->minor)

#define rx_decr(rxp)		(rxp)->count--

#define rx_repeats(rxqp)	(rxqp->head)

#ifdef NEED_PROTO
typedef void (*reply_proc)(df_t *, server_t *, client_t *,
					u8_t, u16_t, u16_t, chunk_t *);
#else
typedef void (*reply_proc)();
#endif

typedef struct _rx_t {
   u8_t			major;		/* major request code */
   u16_t		minor;		/* minor request code */
   u16_t		seqno;		/* sequence number of request */
   u16_t		count;		/* number of servers that will reply */
   reply_proc		fptr;		/* function to invoke */
   df_t *		dfp;		/* data frame */
   struct _rx_t *	next;
}rx_t;

/*
**	a fifo stack
*/
typedef struct _rxq_t {
   int			repeat;		/* build a repeat block? */
   rx_t *		in;		/* fifo in */
   rx_t *		out;		/* fifo out */
   rx_t *		head;		/* "counted block" head */
   rx_t *		tail;		/* "counted block" tail */
   cx_t *		cstk;		/* continue stack */
}rxq_xxx;	/* rxq_t defined in xmx.h */
