/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   sel.c								*
*									*
*	Selections.							*
*									*
************************************************************************/
#include <X11/X.h>
#define NEED_EVENTS
#include <X11/Xproto.h>
#include "xmx.h"
#include "df.h"
#include "incl/sel.pvt.h"

#define SELMAPSZ	128

typedef struct _sel_t {
   atom_t		name;
   client_t *		cp;
   window_t *		wp;
   etime_t 		time;
   struct _sel_t *	next;
}sel_t;

static sel_t *selmap[SELMAPSZ];

/************************************************************************
*									*
*   sel_set_owner							*
*									*
************************************************************************/
int
sel_set_owner
   AL((cp, p))
   DB client_t *cp
   DD xSetSelectionOwnerReq *p
   DE
{
   register atom_t key;
   register sel_t *sp;
   register window_t *wp;
   etime_t time;

   if (p->window == 0) {
      wp = 0;
      cp = 0;		/* client is None if window is None */
   }
   else
      if ((wp = (window_t *)hash_data(vmap, p->window)) == 0) {
         proto_Error(cp, BadWindow, p->window, 0, X_SetSelectionOwner);
         return -1;
      }
   time_update(0);
   time_convert(p->time, &time);
   if (time_cmp(time, vtime) > 0)	/* later than current time */
      return 0;

   for (sp=selmap[key=p->selection%SELMAPSZ]; sp; sp=sp->next)
      if (p->selection == sp->name)
         break;

   if (sp == 0) {			/* a new one */
      if (MALLOC(sp, sel_t *, sizeof(sel_t)))
         return -1;
      sp->name = p->selection;
      sp->next = selmap[key];
      selmap[key] = sp;
   }
   else {
      if (time_cmp(time, sp->time) < 0)	/* earlier than last modify time */
         return 0;

      if (sp->cp && sp->cp != cp)
         event_SelectionClear(	sp->cp,
				time_stamp(time),
				sp->wp->cid,
				p->selection);
   }
   time_assign(time, sp->time);
   sp->wp = wp;
   sp->cp = cp;
   return 0;
}

/************************************************************************
*									*
*   sel_get_owner							*
*									*
************************************************************************/
void
sel_get_owner
   AL((cp, p))
   DB client_t *cp
   DD xResourceReq *p
   DE
{
   register sel_t *sp;

   if (atom_name(p->id, 0, 0)) {
      proto_Error(cp, BadAtom, p->id, 0, X_GetSelectionOwner);
      return;
   }
   for (sp=selmap[p->id%SELMAPSZ]; sp; sp=sp->next)
      if (p->id == sp->name)
         break;

   proto_GetSelectionOwnerReply(cp, (sp && sp->wp) ? sp->wp->cid : 0);
}

/************************************************************************
*									*
*   sel_convert								*
*									*
************************************************************************/
int
sel_convert
   AL((cp, p))
   DB client_t *cp
   DD xConvertSelectionReq *p
   DE
{
   window_t *wp;	/* not used TODO */
   register sel_t *sp;

   if ((wp = (window_t *)hash_data(vmap, p->requestor)) == 0) {
      proto_Error(cp, BadWindow, p->requestor, 0, X_ConvertSelection);
      return -1;
   }
   for (sp=selmap[p->selection%SELMAPSZ]; sp; sp=sp->next)
      if (p->selection == sp->name)
         break;

   if (sp && sp->cp)
      event_SelectionRequest(	sp->cp,
				p->time,
				sp->wp->cid,
				p->requestor,
				p->selection,
				p->target,
				p->property);
   else
      event_SelectionNotify(	cp,
				p->time,
				p->requestor,
				p->selection,
				p->target,
				p->property);
   return 0;
}

/************************************************************************
*									*
*   sel_client_death							*
*									*
************************************************************************/
void
sel_client_death
   AL((cp))
   DB client_t *cp
   DE
{
   register int i;
   register sel_t *sp;

   for (i=0; i<SELMAPSZ; i++)
      for (sp=selmap[i]; sp; sp=sp->next)
         if (sp->cp == cp) {
            sp->cp = 0;
            sp->wp = 0;
         }
}

/************************************************************************
*									*
*   sel_reset								*
*									*
************************************************************************/
void
sel_reset
   VOID
{
   register int i;
   register sel_t *sp, *lp;

   for (i=0; i<SELMAPSZ; i++)
      if (selmap[i]) {
         for (sp=selmap[i]; lp=sp;) {
            sp = sp->next;
            free(lp);
         }
         selmap[i] = 0;
      }
}

/************************************************************************
*									*
*   sel_client_death							*
*									*
************************************************************************/
void
sel_print
   VOID
{
   register int i;
   register sel_t *sp;

   printf("Selections:\n");
   for (i=0; i<SELMAPSZ; i++)
      for (sp=selmap[i]; sp; sp=sp->next)
         printf("   name(%d)\tcp(%x)\twp(%x)\ttime(%d)\n",
					sp->name, sp->cp, sp->wp, sp->time);
}
