/*
 * Copyright 1991-1998, Brown University, Providence, RI.
 * 
 *                         All Rights Reserved
 * 
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose other than its incorporation into a
 * commercial product is hereby granted without fee, provided that the
 * above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Brown University not be used in
 * advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.
 * 
 * BROWN UNIVERSITY DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR ANY
 * PARTICULAR PURPOSE.  IN NO EVENT SHALL BROWN UNIVERSITY BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */
/************************************************************************
*									*
*   xmcp.c								*
*									*
************************************************************************/
#include <xmc.h>
#include <xmcp.h>
#include "xmx.h"
#include "incl/xmcp.pvt.h"

static char padsrc[4];

void
xmcp_ServerConn
   AL((bp, base, mask, config_mode, deftpID))
   DB buffer_t *bp
   DD u32_t base
   DD u32_t mask
   DD u8_t config_mode
   DD rid_t deftpID
   DE
{
   xmcServerConn *p;

   if (buf_avail(bp) < sz_xmcServerConn)
      buf_adjust(bp, sz_xmcServerConn);

   p = (xmcServerConn *)buf_next(bp);

   p->success = 1;
   p->configMode = config_mode;
   p->base = base;
   p->mask = mask;
   p->deftpID = deftpID;

   buf_grow(bp, sz_xmcServerConn);
}

void
xmcp_ServerDeny
   AL((bp, length, reason))
   DB buffer_t *bp
   DD u16_t length
   DD char *reason
   DE
{
   xmcServerConn *p;

   if (buf_avail(bp) < sz_xmcServerConn)
      buf_adjust(bp, sz_xmcServerConn);

   p = (xmcServerConn *)buf_next(bp);

   p->success = 0;
   p->nBytesReason = length;

   buf_grow(bp, sz_xmcServerConn);
   if (length) {
      buf_put(bp, reason, length);
      if (PAD(length))
         buf_put(bp, padsrc, PAD(length));
   }
}

void
xmcp_GetAuthReply
   AL((bp, sn, pmask))
   DB buffer_t *bp
   DD u16_t sn
   DD u32_t pmask
   DE
{
   xmcGetAuthReply *p;

   if (buf_avail(bp) < sz_xmcGetAuthReply)
      buf_adjust(bp, sz_xmcGetAuthReply);

   p = (xmcGetAuthReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   p->length = sz_xmcGetAuthReply;
   p->pMask = pmask;

   buf_grow(bp, sz_xmcGetAuthReply);
}

void
xmcp_QueryDisplayReply
   AL((bp, sn, screen, display, family, length, address, mode, tag, tpp,
								window))
   DB buffer_t *bp
   DD u16_t sn
   DD u16_t screen
   DD u16_t display
   DD u16_t family
   DD u16_t length
   DD char *address
   DD u8_t mode
   DD char *tag
   DD tp_t *tpp
   DD rid_t window
   DE
{
   register int taglen, padlen, totlen;
   xmcQueryDisplayReply *p;

   if (buf_avail(bp) < sz_xmcQueryDisplayReply)
      buf_adjust(bp, sz_xmcQueryDisplayReply);

   taglen = strlen(tag);
   totlen = sz_xmcQueryDisplayReply + length + taglen;
   padlen = PAD(totlen);
   totlen += padlen;

   p = (xmcQueryDisplayReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   p->length = totlen;
   p->screen = screen;
   p->displayNumber = display;
   p->family = family;
   p->nBytesAddress = length;
   p->mode = mode;
   p->nBytesTag = taglen;
   p->tpID = /* TODO */0;
   p->window = window;

   buf_grow(bp, sz_xmcQueryDisplayReply);
   if (length)
      buf_put(bp, address, length);

   if (taglen)
      buf_put(bp, tag, taglen);

   if (padlen)
      buf_put(bp, padsrc, padlen);
}

void
xmcp_ListDisplaysReply
   AL((bp, sn, n, lstp))
   DB buffer_t *bp
   DD u16_t sn
   DD int n
   DD list_t *lstp
   DE
{
   register int sz;
   xmcListDisplaysReply *p;

   if (buf_avail(bp) < sz_xmcListDisplaysReply)
      buf_adjust(bp, sz_xmcListDisplaysReply);

   p = (xmcListDisplaysReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   sz = (n * sizeof(u32_t));
   p->length = sz_xmcListDisplaysReply + (u16_t)sz;
   p->nDisplays = n;

   buf_grow(bp, sz_xmcListDisplaysReply);
   if (sz)
      list_move(lstp, bp);
}

void
xmcp_ListDisplaysWithInfoReply
   AL((bp, sn, dpid, screen, display, family, length, address, mode, tag,
					tpp, window, count))
   DB buffer_t *bp
   DD u16_t sn
   DD u32_t dpid
   DD u16_t screen
   DD u16_t display
   DD u16_t family
   DD u16_t length
   DD char *address
   DD u8_t mode
   DD char *tag
   DD tp_t *tpp
   DD rid_t window
   DD u16_t count
   DE
{
   register int taglen, padlen, totlen;
   xmcListDisplaysWithInfoReply *p;

   if (buf_avail(bp) < sz_xmcListDisplaysWithInfoReply)
      buf_adjust(bp, sz_xmcListDisplaysWithInfoReply);

   taglen = strlen(tag);
   totlen = sz_xmcListDisplaysWithInfoReply + length + taglen;
   padlen = PAD(totlen);
   totlen += padlen;

   p = (xmcListDisplaysWithInfoReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   p->length = totlen;
   p->dispID = dpid;
   p->screen = screen;
   p->displayNumber = display;
   p->family = family;
   p->nBytesAddress = length;
   p->mode = mode;
   p->nBytesTag = taglen;
   p->tpID = /* TODO */0;
   p->window = window;
   p->count = count;

   buf_grow(bp, sz_xmcListDisplaysWithInfoReply);
   if (length)
      buf_put(bp, address, length);

   if (taglen)
      buf_put(bp, tag, taglen);

   if (padlen)
      buf_put(bp, padsrc, padlen);
}

void
xmcp_SyncReply
   AL((bp, sn))
   DB buffer_t *bp
   DD u16_t sn
   DE
{
   xmcSyncReply *p;

   if (buf_avail(bp) < sz_xmcSyncReply)
      buf_adjust(bp, sz_xmcSyncReply);

   p = (xmcSyncReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   p->length = sz_xmcSyncReply;

   buf_grow(bp, sz_xmcSyncReply);
}

void
xmcp_GetConfigReply
   AL((bp, sn, w, h, ndt, dtp, nexts, exts))
   DB buffer_t *bp
   DD u16_t sn
   DD u16_t w
   DD u16_t h
   DD int ndt
   DD char *dtp
   DD int nexts
   DD char **exts
   DE
{
   register int i, totlen, dtlen, padlen;
   xmcGetConfigReply *p;

   if (buf_avail(bp) < sz_xmcGetConfigReply)
      buf_adjust(bp, sz_xmcGetConfigReply);

   dtlen = ndt * (1);
   totlen = sz_xmcGetConfigReply + dtlen;
   for (i=0; i<nexts; i++)
      if (exts[i])
         totlen += strlen(exts[i]);
   padlen += PAD(totlen);
   totlen += padlen;

   p = (xmcGetConfigReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   p->length = totlen;
   p->width = w;
   p->height = h;
   p->nDepthTypes = ndt;
   p->nExtensions = nexts;

   buf_grow(bp, sz_xmcGetConfigReply);

   if (ndt)
      buf_put(bp, dtp, dtlen);

   if (padlen)
      buf_put(bp, padsrc, padlen);
}

void
xmcp_GetEventMaskReply
   AL((bp, sn, mask))
   DB buffer_t *bp
   DD u16_t sn
   DD u16_t mask
   DE
{
   xmcGetEventMaskReply *p;

   if (buf_avail(bp) < sz_xmcGetEventMaskReply)
      buf_adjust(bp, sz_xmcGetEventMaskReply);

   p = (xmcGetEventMaskReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   p->length = sz_xmcGetEventMaskReply;
   p->mask = mask;

   buf_grow(bp, sz_xmcGetEventMaskReply);
}

void
xmcp_GetXEventMaskReply
   AL((bp, sn, mask))
   DB buffer_t *bp
   DD u16_t sn
   DD u16_t mask
   DE
{
   xmcGetXEventMaskReply *p;

   if (buf_avail(bp) < sz_xmcGetXEventMaskReply)
      buf_adjust(bp, sz_xmcGetXEventMaskReply);

   p = (xmcGetXEventMaskReply *)buf_next(bp);

   p->reply = XMC_Reply;
   p->seqNo = sn;
   p->length = sz_xmcGetXEventMaskReply;
   p->mask = mask;

   buf_grow(bp, sz_xmcGetXEventMaskReply);
}

/*
**	Events
*/
void
xmcp_DisplayIdEvent
   AL((bp, code, seqn, dispId))
   DB buffer_t *bp
   DD u8_t code
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcDisplayIdEvent *p;

   if (buf_avail(bp) < sz_xmcEvent)
      buf_adjust(bp, sz_xmcEvent);

   p = (xmcDisplayIdEvent *)buf_next(bp);

   p->code = code;
   p->seqNo = seqn;
   p->dispID = dispId;

   buf_grow(bp, sz_xmcEvent);
}

void
xmcp_DisplayInEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, DisplayInEvent, seqn, dispId);
}

void
xmcp_DisplayRefusedEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, DisplayRefusedEvent, seqn, dispId);
}

void
xmcp_DisplayOutEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, DisplayOutEvent, seqn, dispId);
}

void
xmcp_ModeFloorEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, ModeFloorEvent, seqn, dispId);
}

void
xmcp_ModeSeatEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, ModeSeatEvent, seqn, dispId);
}

void
xmcp_ModeViewEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, ModeViewEvent, seqn, dispId);
}

void
xmcp_PointerGrabEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, PointerGrabEvent, seqn, dispId);
}

void
xmcp_PointerNoGrabEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, PointerNoGrabEvent, seqn, dispId);
}

void
xmcp_PointerUngrabEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, PointerUngrabEvent, seqn, dispId);
}

void
xmcp_KeyboardGrabEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, KeyboardGrabEvent, seqn, dispId);
}

void
xmcp_KeyboardNoGrabEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, KeyboardNoGrabEvent, seqn, dispId);
}

void
xmcp_KeyboardUngrabEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, KeyboardUngrabEvent, seqn, dispId);
}

void
xmcp_ShareSelectionsEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, ShareSelectionsEvent, seqn, dispId);
}

void
xmcp_UnshareSelectionsEvent
   AL((bp, seqn, dispId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t dispId
   DE
{
   xmcp_DisplayIdEvent(bp, UnshareSelectionsEvent, seqn, dispId);
}

void
xmcp_TptrAssignEvent
   AL((bp, code, seqn, dispId, tptrId))
   DB buffer_t *bp
   DD u8_t code
   DD u16_t seqn
   DD rid_t dispId
   DD u32_t tptrId
   DE
{
   xmcTptrAssignEvent *p;

   if (buf_avail(bp) < sz_xmcEvent)
      buf_adjust(bp, sz_xmcEvent);

   p = (xmcTptrAssignEvent *)buf_next(bp);

   p->code = code;
   p->seqNo = seqn;
   p->dispID = dispId;
   p->tpID = tptrId;

   buf_grow(bp, sz_xmcEvent);
}

void
xmcp_TptrEvent
   AL((bp, code, seqn, tptrId))
   DB buffer_t *bp
   DD u8_t code
   DD u16_t seqn
   DD u32_t tptrId
   DE
{
   xmcTptrEvent *p;

   if (buf_avail(bp) < sz_xmcEvent)
      buf_adjust(bp, sz_xmcEvent);

   p = (xmcTptrEvent *)buf_next(bp);

   p->code = code;
   p->seqNo = seqn;
   p->tpID = tptrId;

   buf_grow(bp, sz_xmcEvent);
}

void
xmcp_TptrHideEvent
   AL((bp, seqn, tptrId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t tptrId
   DE
{
   xmcp_TptrEvent(bp, TptrHideEvent, seqn, tptrId);
}

void
xmcp_TptrShowEvent
   AL((bp, seqn, tptrId))
   DB buffer_t *bp
   DD u16_t seqn
   DD rid_t tptrId
   DE
{
   xmcp_TptrEvent(bp, TptrShowEvent, seqn, tptrId);
}

void
xmcp_ConfigModeEvent
   AL((bp, seqn, mode))
   DB buffer_t *bp
   DD u16_t seqn
   DD u8_t mode
   DE
{
   xmcConfigModeEvent *p;

   if (buf_avail(bp) < sz_xmcEvent)
      buf_adjust(bp, sz_xmcEvent);

   p = (xmcConfigModeEvent *)buf_next(bp);

   p->code = ConfigModeEvent;
   p->seqNo = seqn;
   p->mode = mode;

   buf_grow(bp, sz_xmcEvent);
}

void
xmcp_KeyButtonEvent
   AL((bp, code, seqn, dispID, detail, time, event, child, rootX, rootY,
							eventX, eventY, state))
   DB buffer_t *bp
   DD u8_t code
   DD u16_t seqn
   DD u32_t dispID
   DD u8_t detail
   DD timestamp_t time
   DD rid_t event
   DD rid_t child
   DD s16_t rootX
   DD s16_t rootY
   DD s16_t eventX
   DD s16_t eventY
   DD u16_t state
   DE
{
   xmcKeyButtonEvent *p;

   if (buf_avail(bp) < sz_xmcEvent)
      buf_adjust(bp, sz_xmcEvent);

   p = (xmcKeyButtonEvent *)buf_next(bp);

   p->code = code;
   p->seqNo = seqn;
   p->dispID = dispID;
   p->detail = detail;
   p->time = time;
   p->event = event;
   p->child = child;
   p->rootX = rootX;
   p->rootY = rootY;
   p->eventX = eventX;
   p->eventY = eventY;
   p->state = state;

   buf_grow(bp, sz_xmcEvent);
}

void
xmcp_SeatKeyPressEvent
   AL((bp, seqn, dispID, detail, time, event, child, rootX, rootY, eventX,
								eventY, state))
   DB buffer_t *bp
   DD u16_t seqn
   DD u32_t dispID
   DD u8_t detail
   DD timestamp_t time
   DD rid_t event
   DD rid_t child
   DD s16_t rootX
   DD s16_t rootY
   DD s16_t eventX
   DD s16_t eventY
   DD u16_t state
   DE
{
   xmcp_KeyButtonEvent(bp, SeatKeyPressEvent, seqn, dispID, detail, time,
			event, child, rootX, rootY, eventX, eventY, state);
}

void
xmcp_SeatKeyReleaseEvent
   AL((bp, seqn, dispID, detail, time, event, child, rootX, rootY, eventX,
								eventY, state))
   DB buffer_t *bp
   DD u16_t seqn
   DD u32_t dispID
   DD u8_t detail
   DD timestamp_t time
   DD rid_t event
   DD rid_t child
   DD s16_t rootX
   DD s16_t rootY
   DD s16_t eventX
   DD s16_t eventY
   DD u16_t state
   DE
{
   xmcp_KeyButtonEvent(bp, SeatKeyReleaseEvent, seqn, dispID, detail, time,
			event, child, rootX, rootY, eventX, eventY, state);
}

void
xmcp_SeatButtonPressEvent
   AL((bp, seqn, dispID, detail, time, event, child, rootX, rootY, eventX,
								eventY, state))
   DB buffer_t *bp
   DD u16_t seqn
   DD u32_t dispID
   DD u8_t detail
   DD timestamp_t time
   DD rid_t event
   DD rid_t child
   DD s16_t rootX
   DD s16_t rootY
   DD s16_t eventX
   DD s16_t eventY
   DD u16_t state
   DE
{
   xmcp_KeyButtonEvent(bp, SeatButtonPressEvent, seqn, dispID, detail, time,
			event, child, rootX, rootY, eventX, eventY, state);
}

void
xmcp_SeatButtonReleaseEvent
   AL((bp, seqn, dispID, detail, time, event, child, rootX, rootY, eventX,
								eventY, state))
   DB buffer_t *bp
   DD u16_t seqn
   DD u32_t dispID
   DD u8_t detail
   DD timestamp_t time
   DD rid_t event
   DD rid_t child
   DD s16_t rootX
   DD s16_t rootY
   DD s16_t eventX
   DD s16_t eventY
   DD u16_t state
   DE
{
   xmcp_KeyButtonEvent(bp, SeatButtonReleaseEvent, seqn, dispID, detail, time,
			event, child, rootX, rootY, eventX, eventY, state);
}

/*
**	Errors
*/
void
xmcp_Error
   AL((bp, seqn, errcode, opcode, data))
   DB buffer_t *bp
   DD u16_t seqn
   DD u8_t errcode
   DD u8_t opcode
   DD u32_t data
   DE
{
   xmcError *p;

   if (buf_avail(bp) < sz_xmcError)
      buf_adjust(bp, sz_xmcError);

   p = (xmcError *)buf_next(bp);

   p->code = 0;
   p->seqNo = seqn;
   p->errorCode = errcode;
   p->opcode = opcode;
   p->data = data;

   buf_grow(bp, sz_xmcError);
}
