/*
 * Copyright (c) 2001-2009 XORP, Inc.
 * See the XORP LICENSE.lgpl file for licensing, conditions, and warranties
 * on use.
 *
 * DO NOT EDIT THIS FILE - IT IS PROGRAMMATICALLY GENERATED
 *
 * Generated by 'clnt-gen'.
 */

#ident "$XORP: xorp/xrl/interfaces/datain_xif.cc,v 1.24 2009/01/05 18:31:12 jtc Exp $"

#include "datain_xif.hh"

bool
XrlDatainV0p1Client::send_receive(
	const char*	dst_xrl_target_name,
	const string&	peer,
	const uint32_t&	genid,
	const bool&	status,
	const uint32_t&	secs,
	const uint32_t&	micro,
	const vector<uint8_t>&	data,
	const ReceiveCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "datain/0.1/receive");
        x->args().add(XrlAtom(peer));
        x->args().add(XrlAtom(genid));
        x->args().add(XrlAtom(status));
        x->args().add(XrlAtom(secs));
        x->args().add(XrlAtom(micro));
        x->args().add(XrlAtom(data));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, peer);
    x->args().set_arg(1, genid);
    x->args().set_arg(2, status);
    x->args().set_arg(3, secs);
    x->args().set_arg(4, micro);
    x->args().set_arg(5, data);

    return _sender->send(*x, callback(this, &XrlDatainV0p1Client::unmarshall_receive, cb));
}


/* Unmarshall receive */
void
XrlDatainV0p1Client::unmarshall_receive(
	const XrlError&	e,
	XrlArgs*	a,
	ReceiveCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlDatainV0p1Client::send_error(
	const char*	dst_xrl_target_name,
	const string&	peer,
	const uint32_t&	genid,
	const string&	reason,
	const ErrorCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "datain/0.1/error");
        x->args().add(XrlAtom(peer));
        x->args().add(XrlAtom(genid));
        x->args().add(XrlAtom(reason));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, peer);
    x->args().set_arg(1, genid);
    x->args().set_arg(2, reason);

    return _sender->send(*x, callback(this, &XrlDatainV0p1Client::unmarshall_error, cb));
}


/* Unmarshall error */
void
XrlDatainV0p1Client::unmarshall_error(
	const XrlError&	e,
	XrlArgs*	a,
	ErrorCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}

bool
XrlDatainV0p1Client::send_closed(
	const char*	dst_xrl_target_name,
	const string&	peer,
	const uint32_t&	genid,
	const ClosedCB&	cb
)
{
    static Xrl* x = NULL;

    if (!x) {
        x = new Xrl(dst_xrl_target_name, "datain/0.1/closed");
        x->args().add(XrlAtom(peer));
        x->args().add(XrlAtom(genid));
    }

    x->set_target(dst_xrl_target_name);

    x->args().set_arg(0, peer);
    x->args().set_arg(1, genid);

    return _sender->send(*x, callback(this, &XrlDatainV0p1Client::unmarshall_closed, cb));
}


/* Unmarshall closed */
void
XrlDatainV0p1Client::unmarshall_closed(
	const XrlError&	e,
	XrlArgs*	a,
	ClosedCB		cb
)
{
    if (e != XrlError::OKAY()) {
	cb->dispatch(e);
	return;
    } else if (a && a->size() != 0) {
	XLOG_ERROR("Wrong number of arguments (%u != %u)", XORP_UINT_CAST(a->size()), XORP_UINT_CAST(0));
	cb->dispatch(XrlError::BAD_ARGS());
	return;
    }
    cb->dispatch(e);
}
