/* xQuery.c -- Query packer properties
 * Copyright (C) 1996-2000 authors
 * This file is part of the xpk package.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA.
 */

/*
 * Author: SDI (before 1.2 Urban Dominik Mller)
 * Written by Dirk Stcker <stoecker@amigaworld.com>
 * UNIX version by Vesa Halttunen <vesuri@jormas.com>
 */

#include <stdio.h>
#include <sys/types.h>
#include <xpk/xpk.h>
#include <xpk/amigalibs.h>

char errbuf[XPKERRMSGSIZE];
char line1[200], line2[200], line3[200], line4[200];
char line5[200], line6[200], line7[200];

void end(const char *text)
{
  if(text)
    printf(text);
 
  exit(text ? 10 : 0);
}

void packerquery(unsigned int packerid)
{
  struct XpkPackerInfo xpinfo;
  struct XpkMode xminfo;
  unsigned int packer[2]={ packerid, 0 };
  int mode, res;
  char name[5];

  printf("Packer : %s\n", packer);

  if(res = XpkQueryTags(XPK_PackerQuery, &xpinfo, XPK_PackMethod, packer,
			TAG_DONE))
    return;
  
  printf("Name   : %s\n", xpinfo.xpi_LongName);
  printf("Descr. : %s\n", xpinfo.xpi_Description);
  printf("DefMode: %ld\t", xpinfo.xpi_DefMode);
  printf("DefChunk: %ld Kb\t", xpinfo.xpi_DefChunk >> 10);
  printf("MaxChunk: %ld Kb\n", xpinfo.xpi_MaxChunk >> 10);
  
  printf("                      Pack  Unpack  Pack Unpack\n");
  printf("Name   Mode  Ratio   Speed   Speed   Mem    Mem Description\n");
  /*       FAST 99..100 99.7% 1024K/s 1040K/s 1024K  1024K Gnubbeldubbel */

  memcpy(name, packer, 4); name[4] = 0;

  for(mode = 0; mode < 100; mode = xminfo.xm_Upto + 1)
  {
    if(XpkQueryTags(XPK_ModeQuery, &xminfo,
		    XPK_PackMethod, packer,
		    XPK_PackMode, mode,
		    TAG_DONE))
      break;
    printf("%4.4s %2ld..%-3ld %2ld.%1ld%% %4ldK/s %4ldK/s %4ldK  %4ldK %s\n",
      name, mode, xminfo.xm_Upto, xminfo.xm_Ratio / 10, xminfo.xm_Ratio % 10,
	    xminfo.xm_PackSpeed, xminfo.xm_UnpackSpeed,
	    xminfo.xm_PackMemory >> 10, xminfo.xm_UnpackMemory >> 10,
	    xminfo.xm_Description);
  }
  printf("\n");
}

void main(int argc, char **argv)
{
  struct XpkPackerList list;
  int i;

  if(XpkQueryTags(XPK_PackersQuery, &list, TAG_DONE))
    end("Cannot get information");

  if(argc == 1)
    for(i = 0; i < list.xpl_NumPackers; i++)
      packerquery(list.xpl_Packer[i]);
  else
    for(i = 1; i < argc; i++)
      packerquery(argv[i]);
  
  end(NULL);
}
