/* xType.c -- Unpack file to stdout
 * Copyright (C) 1996-2000 authors
 * This file is part of the xpk package.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA.
 */

/*
 * Author: SDI (before 1.1 Urban Dominik Mller)
 * Written by Dirk Stcker <stoecker@amigaworld.com>
 * UNIX version by Vesa Halttunen <vesuri@jormas.com>
 */

#include <stdio.h>
#include <sys/types.h>
#include <xpk/xpk.h>
#include <xpk/amigalibs.h>

#define XPKLEN_ONECHUNK 0x7fffffff

unsigned char errbuf[XPKERRMSGSIZE + 1], *outbuf;
int outbuflen;

void end(char * text)
{
  if(text)	printf("%s\n", text);
  exit(text ? 10 : 0);
}

int main(int argc, char **argv)
{
  struct XpkFib *xfh;
  char *ptr, *last, *eol;
  int i, len;

  if(argc < 2 || argv[1][0] == '?')
    end("Usage: xType filename");

  for(i=1; i < argc; i++) {
    if(XpkOpenTags(&xfh, XPK_InName, (unsigned int)argv[i], XPK_PassThru, 1, TAG_DONE))
      end(errbuf);
    if(!(outbuf=(char *) malloc(outbuflen=xfh->xf_NLen + XPK_MARGIN)))
      end("Out of memory");
    while((len=XpkRead(xfh, outbuf, XPKLEN_ONECHUNK)) > 0) {
      ptr=outbuf;
      last=ptr + len;
      *last='\n';

      do {
	if(!(eol=(char *)strchr(ptr, '\n')))
	  eol=last - 1;
	fwrite(ptr, 1, 1 + eol - ptr, stdout);
	ptr=eol + 1;
      } while(ptr < last);
    }

    if(XpkClose(xfh) || len)
      end(errbuf);

    free(outbuf);
    outbuf=0;
  }

  end(0);
}
