/* XRoads v0.5 -- By Brad Johnson
 * Started sometime in April 1998
 * Based on "Crossroads" and "Crossroads II: Pandemonium"
 * Originally written by Steve Harter for the Commodore 64
 * and published in "Compute!'s Gazette" December 87 & 88
 * All quotations above are probably copyrights or at least
 * trademarks.
 */

/* This program is provided "as is". I accept no responsibility for any
 * problems resulting from the use (or mis-use) or this program in any
 * way. Do whatever you want with this program, as long as you do a few
 * things:
 * 1 - Make sure to give me *some* credit (all you have to do is mention
 *     my name somewhere)
 * 2 - Any use of this code, wether in it's original form or in an altered
 *     state, must be provided free of charge. That goes for binaries AND
 *     source code.
 * That's all for now... have fun!
 */

/********************************************************
 *** This file contains the tile data used for XRoads ***
 *** (In integer-array format rather than character)  ***
 ***        All tiles are held in LSB format          ***
 ********************************************************/

#include "config.h"

/*** Creature Tiles ***/
tile_t tile[NUMCREATURES+1][2] = {
/* Player */                     {{28, 28, 12, 254, 125, 22, 115, 55},
                                  {28, 28, 12, 254, 110, 12, 12, 28}},
/* Brown Dog */			 {{0, 0, 97, 254, 62, 98, 0, 0},
				  {0, 1, 97, 255, 62, 28, 0, 0}},
/* Blue Flea (Pandemonium) */	 {{0, 12, 2, 29, 117, 30, 124, 24},
				  {2, 2, 1, 29, 245, 30, 252, 108}},
/* Blue Flea (Old one) */	 {{0, 60, 157, 127, 62, 34, 102, 0},
                                  {0, 60, 28, 30, 255, 54, 18, 0}},
/* Pink Mutant (Pandemonium} */	 {{0, 12, 4, 236, 62, 12, 23, 98},
				  {0, 12, 4, 124, 30, 12, 4, 12}},
/* Pink Mutant (Old one) */	 {{60, 28, 60, 62, 62, 60, 24, 56},
				  {60, 28, 60, 254, 61, 238, 38}},
/* Green Mashed Potato */	 {{62, 54, 255, 15, 15, 255, 33, 231},
				  {62, 54, 255, 95, 175, 255, 24, 56}},
/* Cyan Mashed Potato */	 {{24, 124, 30, 255, 255, 28, 28, 60},
				  {24, 124, 30, 255, 255, 54, 99, 230}},
/* Blue Egghead */		 {{115, 202, 58, 10, 60, 248, 108, 196},
				  {114, 202, 249, 10, 252, 120, 16, 48}},
/* Orange Lion */		 {{7, 241, 145, 255, 63, 255, 67, 193}, 
				  {4, 247, 145, 255, 31, 255, 50, 22}},
/* Red Chomper */		 {{31, 125, 171, 3, 171, 126, 15, 25},
				  {31, 125, 255, 171, 255, 126, 6, 14}},
/* Yellow Lemonshark */		 {{126, 243, 31, 15, 31, 254, 111, 225},
				  {126, 243, 255, 15, 255, 126, 12, 28}},
/* Brown Monkey */		 {{227, 177, 253, 63, 255, 55, 99, 195},
				  {228, 182, 249, 63, 252, 60, 12, 28}},
/* Pink Tagteam */		 {{0, 227, 161, 253, 63, 248, 54, 98},
				  {0, 224, 163, 253, 63, 220, 8, 24}},
/* Pink Tagteam + Mutant */	 {{12, 229, 174, 236, 62, 221, 8, 24},
				  {13, 229, 190, 236, 63, 220, 54, 98}},
/* Grey Thrower */		 {{114, 23, 114, 50, 126, 114, 50, 112},
				  {112, 18, 119, 50, 254, 114, 122, 202}}, 
/* Grey Archer */		 {{199, 163, 151, 255, 151, 167, 207, 25}, 
				  {199, 163, 151, 255, 151, 167, 195, 7}}, 
/* Blue Rubberhead */		 {{60, 78, 255, 15, 126, 56, 102, 206}, 
				  {60, 78, 255, 31, 126, 8, 8, 24}}, 
/* Purple Rubberhead */		 {{255, 143, 255, 60, 126, 126, 119, 225}, 
				  {255, 143, 255, 60, 126, 126, 28, 60}}, 
/* Green Rubberhead */		 {{60, 36, 124, 52, 4, 60, 8, 24}, 
				  {60, 100, 60, 4, 4, 60, 22, 50}},
/* White Skull */		 {{60, 78, 255, 171, 3, 171, 254, 198}, 
				  {60, 78, 255, 255, 171, 255, 126, 56}}, 
/* Green Vaccuum */		 {{28, 54, 158, 204, 254, 220, 183, 18}, 
				  {28, 54, 190, 204, 255, 204, 132, 12}}
                                 }; /* End of Creatures Tile Data */

/*** Extras ***/
tile_t worm[2] = {{0, 0, 136, 85, 85, 34, 0, 0},
                  {0, 0, 17, 170, 170, 68, 0, 0}};
tile_t blank = {255, 255, 255, 255, 255, 255, 255, 255};
tile_t arrow = {0, 0, 64, 255, 64, 0, 0, 0};
tile_t bullet = {0, 0, 0, 60, 60, 0, 0, 0};
tile_t spar[3] = {{0, 48, 18, 30, 120, 72, 12, 0},
                  {0, 24, 8, 122, 94, 16, 24, 0},
                  {0, 12, 100, 88, 26, 38, 48, 0}};
tile_t scicon = {7, 1, 119, 20, 23, 16, 112, 0};
tile_t cross = {0, 24, 24, 126, 126, 24, 24, 0};
tile_t heart = {54, 127, 127, 127, 62, 28, 8, 0};
tile_t spade = {8, 28, 62, 127, 127, 62, 8, 28};
tile_t diamond = {8, 28, 62, 127, 62, 28, 8, 0};
tile_t club = {8, 28, 42, 127, 42, 8, 28, 0};
tile_t flag = {14, 62, 254, 62, 14, 2, 2, 2};

/*** Wall tiles ***/
tile_t walls[NUMWALLS] = 	{{126, 129, 153, 165, 165, 153, 129, 126},
				 {126, 129, 129, 129, 129, 129, 129, 126},
				 {219, 153, 60, 255, 255, 60, 153, 219},
				 {126, 195, 189, 189, 189, 189, 195, 126},
				 {60, 231, 189, 102, 102, 189, 231, 60},
				 {219, 231, 126, 189, 189, 126, 231, 219},
				 {255, 255, 189, 153, 153, 189, 255, 255},
				 {255, 129, 129, 129, 129, 129, 129, 255},
				 {126, 255, 255, 255, 255, 255, 255, 126},
				 {231, 165, 219, 36, 36, 219, 165, 231},
				 {219, 195, 60, 189, 189, 60, 195, 219},
				 {102, 165, 195, 24, 24, 195, 165, 102},

                                 /* ^ Crossroads Wall Tiles */

                                 /* v New Wall Tiles */

				 {255, 129, 189, 165, 165, 189, 129, 255},
				 {60, 24, 189, 231, 231, 189, 24, 60},
                                 {255, 193, 161, 145, 137, 133, 131, 255},
				 {231, 195, 165, 24, 24, 165, 195, 231},
				 {255, 129, 163, 151, 135, 155, 189, 255},
				 {102, 219, 165, 90, 90, 165, 219, 102},
				 {102, 153, 129, 90, 90, 129, 153, 102},
				 {231, 173, 199, 18, 72, 227, 181, 231}
};


tile_t explosion[4] =		{{0, 0, 0, 24, 24, 0, 0, 0},
				 {0, 0, 16, 4, 32, 20, 0, 0},
				 {0, 16, 2, 0, 64, 0, 20, 0},
				 {16, 1, 0, 0, 128, 0, 34}};

/* Test area: 

        1
     1362
 12486248

 * * * *  85
  * * * * 170
 * * * *  85
  * * * * 170
 * * * *  85
  * * * * 170
 * * * *  85
  * * * * 170

  **  **  102
 * *  * * 165
 **    ** 195
    **    24
    **    24
 **    ** 195
 * *  * * 165
  **  **  102

 ***  *** 231
 * *  * * 165
 ** ** ** 219
   *  *   36
   *  *   36
 ** ** ** 219
 * *  * * 165
 ***  *** 231

 ** ** ** 219
 **    ** 195
   ****   60
 * **** * 189
 * **** * 189
   ****   60
 **    ** 195
 ** ** ** 219

 ******** 255
 ******** 255
 * **** * 189
 *  **  * 153
 *  **  * 153
 * **** * 189
 ******** 255
 ******** 255

 ******** 255
 *      * 129
 *      * 129
 *      * 129
 *      * 129
 *      * 129
 *      * 129
 ******** 255

  ******  126
 ******** 255
 ******** 255
 ******** 255
 ******** 255
 ******** 255
 ******** 255
  ******  126


  ** **
 ******* 
 ******* 
 ******* 
  *****
   *** 
    *



    *
   ***   
  *****
 *******
 *******
  *****
    * 
   *** 

    *
   ***   
  * * *
 *******
  * * *
    * 
   *** 

    *
   ***
  *****
 *******
  *****
   ***
    *
     

*/
