// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: fireball.C,v 3.9 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "random.h"
#include "trig.h"
#include "util.h"
#include "xsc.h"

#include "fireball.h"

using namespace Trig;


namespace {

const coords fireball_points[] = {
    { COS00 / 2.0, -SIN00 / 2.0 }, { -COS00 / 2.0,  SIN00 / 2.0 },
    { COS15 / 2.0, -SIN15 / 2.0 }, { -COS15 / 2.0,  SIN15 / 2.0 },
    { COS30 / 2.0, -SIN30 / 2.0 }, { -COS30 / 2.0,  SIN30 / 2.0 },
    { COS45 / 2.0, -SIN45 / 2.0 }, { -COS45 / 2.0,  SIN45 / 2.0 },
    { COS60 / 2.0, -SIN60 / 2.0 }, { -COS60 / 2.0,  SIN60 / 2.0 },
    { COS75 / 2.0, -SIN75 / 2.0 }, { -COS75 / 2.0,  SIN75 / 2.0 },
    { COS90 / 2.0,  SIN90 / 2.0 }, { -COS90 / 2.0, -SIN90 / 2.0 },
    { COS75 / 2.0,  SIN75 / 2.0 }, { -COS75 / 2.0, -SIN75 / 2.0 },
    { COS60 / 2.0,  SIN60 / 2.0 }, { -COS60 / 2.0, -SIN60 / 2.0 },
    { COS45 / 2.0,  SIN45 / 2.0 }, { -COS45 / 2.0, -SIN45 / 2.0 },
    { COS30 / 2.0,  SIN30 / 2.0 }, { -COS30 / 2.0, -SIN30 / 2.0 },
    { COS15 / 2.0,  SIN15 / 2.0 }, { -COS15 / 2.0, -SIN15 / 2.0 },
};

} // namespace


Fireball::Fireball(void)
{
    //fprintf(stderr, "Fireball::Fireball()\n");
    set_scale(25.0);
    flying = false;
    paused = false;
    points = fireball_points;
    num_points = sizeof(fireball_points) / sizeof(coords);
    xpoints = new XPoint[num_points];
    randomizer = new float[num_points];
    gc = fetch_gc(GC_GREEN);
} // Fireball::Fireball


Fireball::~Fireball(void)
{
    //fprintf(stderr, "Fireball::~Fireball()\n");
    delete[] randomizer;
} // Fireball::~Fireball


void
Fireball::set_randomizer(void)
{
    if (paused) {
	return;
    }

    for (int i = 0; i < num_points; i++) {
	randomizer[i] = (Random::get() % 500) / 1000.0 + 0.50;
    }
} // Fireball::set_randomizer


void
Fireball::render(const bool ink)
{
    if (!alive()) {
	return;
    }

    if (ink) {
	set_randomizer();
	set_xpoints();
    }
    paint_points(ink);
} // Fireball::render


void
Fireball::move(Ship *ship)
{
    if (!alive()) {
	return;
    }

    x += dx;
    y += dy;
    if ((x >= wwidth) || (x < 0) || (y >= gwheight) || (y < 0) ||
	    ship->hit(this)) {
	snuff();
    }
} // Fireball::move


void
Fireball::launch(King *king)
{
    if (alive()) {
	return;
    }

    x = wwidth2;
    y = gwheight2;

    const float deg = king->get_theta();
    const float mag = (wwidth / 2.5) / args.fps;
    dx = xcos(deg) * mag;
    dy = -xsin(deg) * mag;

    flying = true;
} // Fireball::launch


void
Fireball::set_xpoints(void)
{
    for (int i = 0; i < num_points; i++) {
	float nsize = randomizer[i] * size;

	xpoints[i].x = (int)((nsize * points[i].x) + x);
	xpoints[i].y = (int)((nsize * points[i].y) + y);
    }
} // Fireball::set_xpoints
