// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: fireball.h,v 3.8 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_FIREBALL_H

class Fireball;

#else	// XSC_FIREBALL_H
#define	XSC_FIREBALL_H

#include "king.h"
#include "ship.h"
#include "stats.h"
#include "xything.h"

class Fireball : public virtual Xything {
private:
    bool flying;
    float *randomizer;
    bool paused;

    void set_randomizer(void);

public:
    Fireball(void);
    ~Fireball(void);

    void render(const bool);

    void move(Ship *);
    void launch(King *);
    void set_xpoints(void);

    bool alive(void) const;
    void snuff(void);
    void pause(const bool);
};


inline bool
Fireball::alive(void) const
{
    return flying;
} // Fireball::alive


inline void
Fireball::snuff(void)
{
    flying = false;
} // Fireball::snuff


inline void
Fireball::pause(const bool pause_state)
{
    paused = pause_state;
} // Fireball::pause

#endif	// XSC_FIREBALL_H
