// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

static const char *const file_id =
	"@(#)$Id: minefield.C,v 3.7 2005/01/02 19:11:17 mark Exp $";

#include "global.h"

#include "random.h"
#include "util.h"
#include "xsc.h"

#include "minefield.h"


Minefield::Minefield(void)
{
    //fprintf(stderr, "Minefield::Minefield()\n");
    nummines = 3;
    buzzers = new Buzzer[nummines];
} // Minefield::Minefield


Minefield::~Minefield(void)
{
    //fprintf(stderr, "Minefield::~Minefield()\n");
    delete[] buzzers;
} // Minefield::~Minefield


void
Minefield::render(const bool ink) const
{
    for (int i = 0; i < nummines; i++) {
	buzzers[i].render(ink);
    }
} // Minefield::render


void
Minefield::move(Castle *castle, Ship *ship) const
{
    for (int i = 0; i < nummines; i++) {
	buzzers[i].move(castle, ship);
    }
} // Minefield::move


void
Minefield::resize(const int nwidth, const int nheight) const
{
    for (int i = 0; i < nummines; i++) {
	buzzers[i].resize(nwidth, nheight);
    }
} // Minefield::resize


bool
Minefield::hit(Laser *laser) const
{
    for (int i = 0; i < nummines; i++) {
	if (buzzers[i].hit(laser)) {
	    return true;
	}
    }
    return false;
} // Minefield::hit


void
Minefield::launch(King *king, Castle *castle) const
{
    if (!king->alive()) {
	return;
    }

    for (int i = 0; i < nummines; i++) {
	if (!buzzers[i].alive() &&
		(Random::get() % (int)(2 * args.fps) == 0)) {
	    buzzers[i].launch(king, castle);
	    return;
	}
    }
} // Minefield::launch


void
Minefield::upgrade(Castle *castle) const
{
    for (int i = 0; i < nummines; i++) {
	buzzers[i].upgrade(castle);
    }
} // Minefield::upgrade


void
Minefield::snuff(void) const
{
    for (int i = 0; i < nummines; i++) {
	buzzers[i].snuff();
    }
} // Minefield::snuff


void
Minefield::pause(bool pause_state) const
{
    for (int i = 0; i < nummines; i++) {
	buzzers[i].pause(pause_state);
    }
} // Minefield::pause
