// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: thing.h,v 3.2 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_THING_H

class Thing;

#else	// XSC_THING_H
#define	XSC_THING_H

class Thing {
protected:
    float x;
    float y;
    float size;
    float scale;
    float diag;

    Window window;
    GC gc;

    int num_points;
    const struct coords *points;
    XPoint *xpoints;

public:
    Thing(void);
    virtual ~Thing(void);

    float get_size(void) const;
    void set_size(const float);

    float get_scale(void) const;
    void set_scale(const float);

    Window get_window(void) const;
    void set_window(const Window);

    GC get_gc(void) const;
    void set_gc(const GC);

    float get_x(void) const;
    void set_x(float);

    float get_y(void) const;
    void set_y(float);

    float get_diag(void) const;

    virtual void set_points(const struct coords *, const int);

    virtual XPoint *get_xpoints(void) const;
    virtual void set_xpoints(void);

    virtual void paint_points(const bool) const;

    virtual void render(const bool);
    void draw(void);
    void erase(void);

    virtual void resize(const int, const int);
};


inline float
Thing::get_size(void) const
{
    return size;
} // Thing::get_size


inline float
Thing::get_scale(void) const
{
    return scale;
} // Thing::get_scale


inline Window
Thing::get_window(void) const
{
    return window;
} // Thing::get_window


inline void
Thing::set_window(const Window w)
{
    window = w;
} // Thing::set_window


inline GC
Thing::get_gc(void) const
{
    return gc;
} // Thing::get_gc


inline void
Thing::set_gc(const GC ngc)
{
    gc = ngc;
} // Thing::set_gc


inline float
Thing::get_x(void) const
{
    return x;
} // Thing::get_x


inline void
Thing::set_x(float nx)
{
    x = nx;
} // Thing::set_x


inline float
Thing::get_y(void) const
{
    return y;
} // Thing::get_y


inline void
Thing::set_y(float ny)
{
    y = ny;
} // Thing::set_y


inline float
Thing::get_diag(void) const
{
    return diag;
} // Thing::get_diag


inline void
Thing::draw(void)
{
    render(true);
} // Thing::draw


inline void
Thing::erase(void)
{
    render(false);
} // Thing::erase

#endif	// XSC_THING_H
