// xsc: Copyright (c) 1993-2005 by Mark B. Hanson (mbh@panix.com).

// @(#)$Id: xything.h,v 3.4 2005/01/02 19:11:17 mark Exp $

#ifdef	XSC_XYTHING_H

class Xything;

#else	// XSC_XYTHING_H
#define	XSC_XYTHING_H

#include "trig.h"
#include "xsc.h"

#include "thing.h"

using namespace Trig;

class Xything : virtual public Thing {
protected:
    float dx;
    float dy;

public:
    Xything(void);
    virtual ~Xything(void);

    float get_dx(void) const;
    void set_dx(const float);

    float get_dy(void) const;
    void set_dy(const float);

    float get_angle(void) const;
    float get_radius(void) const;

    virtual void move(void);
    virtual void resize(const int, const int);
    virtual void bounce(const float);
};


inline float
Xything::get_dx(void) const
{
    return dx;
} // Xything::get_dx


inline void
Xything::set_dx(const float new_dx)
{
    dx = new_dx;
} // Xything::set_dx


inline float
Xything::get_dy(void) const
{
    return dy;
} // Xything::get_dy


inline void
Xything::set_dy(const float new_dy)
{
    dy = new_dy;
} // Xything::set_dy


inline float
Xything::get_angle(void) const
{
    return xatan2(y - gwheight2, wwidth2 - x);
} // Xything::get_angle


inline float
Xything::get_radius(void) const
{
    return hypot(x - wwidth2, y - gwheight2);
} // Xything::get_radius

#endif	// XSC_XYTHING_H
