
/* Lib functions for divers programs. */

#include <stdio.h>
#include <string.h>
#include "config.h"

/* Use prototypes if available.  */
#if defined (__cplusplus) || (defined (__STDC__) && __STDC__)
#undef  PARAMS
#define PARAMS(protos)  protos
#else /* Not C++ or ANSI C.  */
#undef  PARAMS
#define PARAMS(protos)  ()
#endif /* C++ or ANSI C.  */

#if HAVE_MALLOC_H
#   include <malloc.h>
#elif defined STDC_HEADERS
    extern void free PARAMS ((char *));
    extern char *malloc PARAMS ((int));
    extern char *realloc PARAMS ((char*, int));
#endif

#if 0  /* urg, this is a weird type of basename (), at least on glibc */
#if HAVE_LIBGEN_H
#   include <libgen.h>
#endif
#endif

extern void close_file (FILE * f);
extern void error (char const *fmt,...);
extern void error_setprogname (char const *fmt);
extern FILE *open_file (char const *name, char const *mode);
extern void output (FILE * f, char const *s,...);
extern char *str_addchar (char *str, int ch);
extern char *str_concat (char *str, char const *tail);
extern char *str_replace (char *str, char const *search, char const *replace);
extern char *str_short (char const *s);

#if ! HAVE_HSEARCH_R
#define strarr_add strtab_add
#define strarr_del strtab_del
#define strarr_find strtab_find
#define strarr_free strtab_free
#else
/* urg, glibc-2.1 needs this */
#define __USE_GNU
#endif

extern char **strarr_add (char **tab, int *ntab, char const *newstr);
extern void strarr_del (char **tab, int *ntab, char const *what);
extern int strarr_find (char **tab, int ntab, char const *string);
extern void strarr_free (char **tab, int ntab);

extern char **strtab_add (char **tab, int *ntab, char const *newstr);
extern void strtab_del (char **tab, int *ntab, char const *what);
extern int strtab_find (char **tab, int ntab, char const *string);
extern void strtab_free (char **tab, int ntab);

extern void warning (char const *fmt,...);
extern void *xrealloc (void *mem, int newsz);
extern char *xstrdup (char const *s);
extern void warranty ();
