/*
 *  CreateEditDialog()  -   dialog to edit yrolo database
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  11/13/94    muquit  first cut
 */

#include "xhead.h"
#include "defines.h"
#include "xymrolo.h"

#define TIGHTNESS 20
#define NUMBER_OF_BUTTONS 2

Boolean CreateEditDialog (parent)
Widget
    parent;
{
    Arg
        args[20];
    int
        n;
    
    int
        i;

    static Widget
        formW,
        paneW,
        controlformW,
        actionformW,
        namelabelW,
        nameTextW,

        companyLabW,

        emailLabelW,
        emailTextW,

        number1LabelW,
        number1TextW,

        number2LabelW,
        number2TextW,

        buttonW,
        commentTextW;
    
    Widget
        remarksLabW,
        addressLabW,
        faxLabW,
        vsbW,
        hsbW;

    Pixel
        scb_bg;

    char
        *label[3];

    label[0] = "Accept";
    label[1] = "Dismiss";

    
    /*
    ** create the base form
    */


    n = 0;
    XtSetArg (args[n], XmNdialogStyle,
        XmDIALOG_PRIMARY_APPLICATION_MODAL);    n++;
    formW = XmCreateFormDialog(parent, "Yrolo",
        args, n);
    
    w_special[ROLOVIEWFD_W] = formW;

    XtVaSetValues (XtParent(formW), XmNtitle, "Yrolo Edit", NULL);

    /*
    ** create a pane
    */

    paneW = XtVaCreateWidget("Rpane",
        xmPanedWindowWidgetClass, formW,
        XmNsashWidth,           1,
        XmNsashHeight,          1,
        XmNtopAttachment,       XmATTACH_FORM,
        XmNbottomAttachment,    XmATTACH_FORM,
        XmNleftAttachment,      XmATTACH_FORM,
        XmNrightAttachment,     XmATTACH_FORM,
        NULL);

    /*
    ** create form for control area
    */

    controlformW = XtVaCreateWidget ("Controlform",
        xmFormWidgetClass, paneW,
        NULL);

    /*
    ** create name label
    */

    namelabelW = XtVaCreateManagedWidget ("Name",
        xmLabelWidgetClass, controlformW,
        XmNtopAttachment, XmATTACH_FORM,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        NULL);
    
    /*
    ** create name text W
    */

    nameTextW = XtVaCreateWidget ("Nametext",
        xmTextWidgetClass, controlformW,
        XmNmaxLength, (int)100,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNcolumns, (short)35,
        XmNrows, (short)1,
        XmNtopAttachment, XmATTACH_FORM,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);

    w_special[NAME_TEXT_W] = nameTextW;

    XtAddCallback(nameTextW, XmNactivateCallback, ReturnHit, NULL);

    /*
    ** company Label
    */

    companyLabW = XtVaCreateManagedWidget ("Company",
        xmLabelWidgetClass, controlformW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, nameTextW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    /*
    ** Company Text
    */

    GEcompanyTextW = XtVaCreateWidget ("Nametext",
        xmTextWidgetClass, controlformW,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, nameTextW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);

    XtAddCallback(GEcompanyTextW, XmNactivateCallback, ReturnHit, NULL);

    /*
    ** create the address label
    */

    addressLabW = XtVaCreateManagedWidget ("Address",
        xmLabelGadgetClass, controlformW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GEcompanyTextW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    /*
    ** create address text
    */

    GEaddressTextW = XtVaCreateManagedWidget ("Nametext",
        xmTextWidgetClass, controlformW,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GEcompanyTextW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);

    XtAddCallback(GEaddressTextW, XmNactivateCallback, ReturnHit, NULL);

    GEaddressText2W = XtVaCreateManagedWidget ("Nametext",
        xmTextWidgetClass, controlformW,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GEaddressTextW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);   
    XtAddCallback(GEaddressText2W, XmNactivateCallback, ReturnHit, NULL);
    /*
    ** create Phone #1 label
    */

    number1LabelW = XtVaCreateManagedWidget ("Phone1",
        xmLabelWidgetClass, controlformW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GEaddressText2W,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    /*
    ** Create Phone #1 Text W
    */

    number1TextW = XtVaCreateWidget ("Nametext",
        xmTextWidgetClass, controlformW,
        XmNmaxLength, (int)64,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNcolumns, (short)25,
        XmNrows, (short)1,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GEaddressText2W,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);

    w_special[PHONE_1_TEXT_W] = number1TextW;
    XtAddCallback(number1TextW, XmNactivateCallback, ReturnHit, NULL);

    /*
    ** create Phone #2 label
    */


    number2LabelW = XtVaCreateManagedWidget ("Phone2",
        xmLabelWidgetClass, controlformW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, number1TextW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        NULL);
    /*
    ** Create Phone #2 Text W
    */

    number2TextW = XtVaCreateWidget ("Nametext",
        xmTextWidgetClass, controlformW,
        XmNmaxLength, (int)64,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNcolumns, (short)25,
        XmNrows, (short)1,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, number1TextW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);

    w_special[PHONE_2_TEXT_W] = number2TextW;
    XtAddCallback(number2TextW, XmNactivateCallback, ReturnHit, NULL);

    /*
    ** create whphone label
    */

    faxLabW = XtVaCreateManagedWidget ("Fax",
        xmLabelGadgetClass, controlformW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, number2TextW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    /*
    ** Fax Text
    */

    GEfaxTextW = XtVaCreateManagedWidget ("Nametext",
        xmTextWidgetClass, controlformW,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, number2TextW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);
    XtAddCallback(GEfaxTextW, XmNactivateCallback, ReturnHit, NULL);

    /*
    ** Create E-mail Label
    */

    emailLabelW = XtVaCreateManagedWidget ("Email",
        xmLabelWidgetClass, controlformW,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GEfaxTextW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNrightAttachment, XmATTACH_POSITION,
        XmNrightPosition, 18,
        XmNalignment,   XmALIGNMENT_END,
        NULL);

    /*
    ** create e-mail text w
    */

    emailTextW = XtVaCreateWidget ("Emailtext",
        xmTextWidgetClass, controlformW,
        XmNmaxLength, (int)64,
        XmNeditMode, XmSINGLE_LINE_EDIT,
        XmNcolumns, (short)25,
        XmNrows, (short)1,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, GEfaxTextW,
        XmNleftAttachment, XmATTACH_POSITION,
        XmNleftPosition, 18,
        XmNrightAttachment, XmATTACH_FORM,
        NULL);
    
    w_special[EMAIL_TEXT_W] = emailTextW;
    XtAddCallback(emailTextW, XmNactivateCallback, ReturnHit, NULL);

    /*
    ** remarks label
    */

    remarksLabW = XtVaCreateManagedWidget ("Remarks",
        xmLabelGadgetClass, controlformW,
        XmNleftAttachment, XmATTACH_FORM,
        XmNtopAttachment, XmATTACH_WIDGET,
        XmNtopWidget, emailTextW,
        XmNtopOffset, (int) 10,
        NULL);
    /*
    ** Create the Comment Text Widget
    */

    n = 0;
    XtSetArg (args[n], XmNeditMode, XmMULTI_LINE_EDIT);  n++;
    XtSetArg (args[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
    XtSetArg (args[n], XmNleftAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNrightAttachment, XmATTACH_FORM); n++;
    XtSetArg (args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
    XtSetArg (args[n], XmNtopWidget, remarksLabW); n++;

    commentTextW = XmCreateScrolledText ( controlformW, "Commentext",
        args, n);

    XtAddCallback (commentTextW, XmNactivateCallback, 
        (XtCallbackProc) InfoButtonCB, (XtPointer) EDIT_OR_ADD_CARD);

    w_special[COMMENT_TEXT_W] = commentTextW;

    
    /*
    ** set the scroll bar colors
    */

    scb_bg = (Pixel) AllocateNamedColor(XtDisplay(w_special[TOPLEVEL_W]), 
        scb_bgcolor);

    if (scb_bg > 256)   /* Parse error */
    {
        /*
        ** set the color as same as the bg of the toplevel W
        */
        XtVaGetValues(w_special[TOPLEVEL_W],
            XmNbackground, &scb_bg,
            NULL);
    }

    XtVaGetValues(XtParent(commentTextW),
        XmNverticalScrollBar, &vsbW,
        XmNhorizontalScrollBar, &hsbW,
        NULL);
    
    SetScrollbarColors(vsbW, hsbW, scb_bg);

    /*
    ** create form for action area
    */

    actionformW = XtVaCreateWidget("Actionform",
        xmFormWidgetClass, paneW,
        XmNfractionBase, TIGHTNESS*NUMBER_OF_BUTTONS-1,
        NULL);
        
    /*
    ** create push buttons
    */

    for (i=0; i < NUMBER_OF_BUTTONS; i++)
    {

#ifdef DEBUG2
    (void) fprintf (stderr, "pblabels:%s\n",label[i]);
#endif

        buttonW = XtVaCreateManagedWidget (label[i],
            xmPushButtonWidgetClass, actionformW,
            /*
            XmNshowAsDefault,                  i == 0,
            */
            XmNleftAttachment, i ? XmATTACH_POSITION : XmATTACH_FORM,
            XmNleftPosition,    TIGHTNESS*i,
            XmNtopAttachment, XmATTACH_FORM,
            XmNbottomAttachment, XmATTACH_FORM,
            XmNrightAttachment,
                i != NUMBER_OF_BUTTONS-1 ? XmATTACH_POSITION : XmATTACH_FORM,
            XmNrightPosition, TIGHTNESS*i+(TIGHTNESS-1),
            NULL);

        switch(i)
        {
            case 0:
            {
                XtAddCallback (buttonW, XmNactivateCallback, InfoButtonCB,
                    (XtPointer) EDIT_OR_ADD_CARD);
                break;
            }
            
            case 1:
            {
                XtAddCallback (buttonW, XmNactivateCallback, InfoButtonCB,
                    (XtPointer) DISMISS_WINDOW);
                break;
            }
        }

        if (i==0)
        {
            Dimension
                height = (Dimension) 0;
            Dimension
                h = (Dimension) 0;

            XtVaGetValues (actionformW, 
                XmNmarginHeight, &h,
                NULL);
            
            height +=h<<1;

            XtVaSetValues (buttonW,
                XmNdefaultButton, buttonW,
                XmNpaneMaximum, height,
                XmNpaneMinimum, height,
                NULL);
            

        }
    }

    XtManageChild (actionformW);
    XtManageChild (commentTextW);
    XtManageChild (number2TextW);
    XtManageChild (number1TextW);
    XtManageChild (emailTextW);
    XtManageChild (GEcompanyTextW);
    XtManageChild (nameTextW);
    XtManageChild (controlformW);
    XtManageChild (nameTextW);
    XtManageChild (paneW);
    
    return (True);
}
