/*
 *  File_Sel()  -   description
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      when    who     why
 *  ???         mm      first cut
 *  ??? 
 * 5/10/94      mm      TGA
 * 5/17/94      mm      SUN Raster
 */

#include <xhead.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>     /*W_OK*/
#include "xymrolo.h"
#include "defines.h"

#include <errcds.h>

XmStringCharSet charset = XmSTRING_DEFAULT_CHARSET;

int
is_writable(file)
char *file;
{
    struct stat s_buf;

    /* if file can't be accessed (via stat()) return. */
    if (stat(file, &s_buf) == -1)
        return -1;
    else if ((s_buf.st_mode & S_IFMT) == S_IFDIR)
        return 0; /* a directory */
    else if (!(s_buf.st_mode & S_IFREG) || access(file, R_OK) == -1)
        /* not a normal file or it is not writable */
        return -1;
    /* legitimate file */
    return 1;
}

void
FileSelectionCB(w, client_data, call_data)
Widget
    w;

XtPointer
    client_data;

XtPointer
    call_data;

{
    int
        rc = 0;

    char
        *file = (char *) NULL;

    XmFileSelectionBoxCallbackStruct
        *cbs = (XmFileSelectionBoxCallbackStruct *) call_data;

    /* get the string typed in the text field in char * format */

    if (!XmStringGetLtoR(cbs->value, charset, &file))
        return;

    if (*file != '/') {
        char
            *dir,
            *newfile;

        if (XmStringGetLtoR(cbs->dir, charset, &dir))
        {
            newfile = XtMalloc(strlen(dir) + 1 + strlen(file) + 1);
            sprintf(newfile, "%s/%s", dir, file);
            XtFree(file);
            XtFree(dir);
            file = newfile;
        }
    }


    switch (is_writable(file)) 
    {
        case 1:
        {
#ifdef DEBUG
            (void) fprintf (stderr, "Filename: %s\n",
                file);
#endif

            switch((int) client_data)
            {
                case FILE_OPEN:
                {
                    XtUnmanageChild (w_special[FILE_OPEN_DIALOG_W]);
                    XFlush(XtDisplay(w_special[FILE_OPEN_DIALOG_W]));
                    SetBusyCursorState (w_special[MAINWINDOW_W], False);
                    break;
                }

                case INCLUDE_FILE:
                {
                    (void) fprintf(stderr,
                        "Attach text file\n");
                    break;
                }

                default:            /* Unknown */
                    break;
            }



            switch ((int) client_data)
            {
                case FILE_OPEN:
                {
                    FILE
                        *fp;
                    char
                        Magick[20];

                    *Magick='\0';

                    fp = fopen (file, "r");

                    (void) fgets (Magick,19,fp);

                    if (feof(fp)) 
                    {
                        WriteStatus(1,rolomessageTextW,
                            "Unexpected end of file while reading!");
                        (void) fclose ((FILE *) fp);
                        return;
                    }

                    if (strncmp(Magick, ROLODEX_MAGICK, 
                        (int)strlen(ROLODEX_MAGICK)) != 0)
                    {
                        ShowErrorDialog (INVALID_ROLODEX_FILE,
                            "File is not in Yrolo format!");
                        (void) fclose ((FILE *) fp);
                        return;
                    }
                    (void) fclose ((FILE *) fp);
                    rc = ReadList(file);
                    break;
                }
            }

            break;
        }

        case 0: 
        {
            /* a directory was selected, scan it */
            /*XmString str = XmStringCreateSimple(file);
            XmFileSelectionDoSearch(w, str);
            XmStringFree(str);*/
            (void) fprintf (stderr,
                "File is a Directory!\n");
            WriteStatus(1,rolomessageTextW, 
                "File is a Directory!");
            break;
        }

        case -1:
            /* a system error on this file */
        {
            (void) fprintf (stderr,
                "System Error while trying to open File!\n");
            WriteStatus(1,rolomessageTextW, 
                "System Error while trying to open File!");
            break;
        }
    }

    if (file)
    XtFree(file);
}
