/* uuencode.c - convert files to ascii-encoded form
 * Usage: uuencode [filename] < infile
 *
 * If [filename] isn't specified, "/dev/stdout" is the default.  This allows
 * use of my uudecode as a pipeline filter.
 *
 * Written and placed in the public domain by Phil Karn, KA9Q
 * 31 March 1987
 */
/*
** changed to a function, muquit@semcor.com, 3/19/95
** keep the mode of file instead of a hard coded 0666, muquit
** changed to write to a file pointer instead of stdout
*/

#include "xhead.h"
#include "xymrolo.h"

void Uuencode (ifilename, ofilename)
char
    *ifilename;
char
    *ofilename;
{
#define LINELEN 45
    FILE
        *ifp,
        *ofp;

    char
        linebuf[LINELEN];

    register
        char *cp;

    int
        linelen;

    struct stat
        statbuf;

    int
        mode;

    stat (ifilename, &statbuf);

    ifp = fopen (ifilename, "r");
    ofp = fopen (ofilename, "w");

    mode = statbuf.st_mode & (S_IRWXU | S_IRWXG | S_IRWXO);

    (void) fprintf (ofp,
        "begin %o %s\n", mode, basename(ifilename));

    for(;;)
    {
        linelen = fread(linebuf,1,LINELEN,ifp);
        if(linelen <= 0)
            break;
        (void) fputc((' ' + linelen), ofp); /* Record length */
        for(cp = linebuf; cp < &linebuf[linelen]; cp += 3)
        {
            fputc((' ' + ((cp[0] >> 2) & 0x3f)), ofp);
            fputc((' ' + (((cp[0] << 4) & 0x30) | ((cp[1] >> 4) & 0xf))),ofp);
            fputc((' ' + (((cp[1] << 2) & 0x3c) | ((cp[2] >> 6) & 0x3))),ofp);
            fputc((' ' + (cp[2] & 0x3f)), ofp);
        }
        fputc('\n', ofp);
    }
    (void) fprintf(ofp," \n");  /* 0-length null record */
    (void) fprintf(ofp, "end\n");

    (void) fclose ((FILE *) ifp);
    (void) fclose ((FILE *) ofp);
}

#ifdef TEST
void main(argc, argv)
int
    argc;
char
    **argv;
{
    if (argc < 3)
    {
        (void) fprintf(stderr,"Usage: %s infile outfile\n", argv[0]);
        exit(1);
    }
    Uuencode (argv[1], argv[2]);
}
#endif  /* TEST */
