/*
 *  WriteList() - writes the rolo list to the file
 *
 *  RCS:
 *      $Revision: 1.1 $
 *      $Date: 1995/05/07 19:34:10 $
 *
 *  Security:
 *      Unclassified
 *
 *  Description:
 *      text
 *
 *  Input Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Output Parameters:
 *      type    identifier  description
 *
 *      text
 *
 *  Return Values:
 *      value   description
 *
 *  Side Effects:
 *      text
 *
 *  Limitations and Comments:
 *      text
 *
 *  Development History:
 *      who                 when        why
 *      muquit@semcor.com   11/14/94    first cut
 */


#include "xhead.h"
#include "xymrolo.h"
#include "defines.h"

void WriteList(filename)
char
    *filename;
{
    FILE
        *fp;
    
    RoloRec
        *rr;

    char
        *s;

    char
        tmpfile[MaxTextLength];

    int
        rc = 0;

    char
        message[MaxTextLength];

    *message = '\0';

    TemporaryFilename(tmpfile);

#ifdef DEBUG2
    (void) fprintf (stderr, 
        "Tmp file: %s\n", tmpfile);
#endif


    fp = fopen(tmpfile, "w");

    if (fp == (FILE *) NULL)
    {
        Warning("WriteList(): Could not open temporary file", 
            tmpfile);
        return;
    }
    
    /*
    ** write the header
    */
    fprintf(fp, ROLODEX_MAGICK);
    fprintf(fp, "\n");

    /*
    ** write the Version String
    */
    (void) fprintf (fp, VersionString);
    (void) fprintf (fp, "\n");

    /*
    ** update Global Version String..string is written now to the file
    */
    (void) strcpy (GversionString, VersionString);

    for(rr=RoloList; rr != (RoloRec *) NULL; rr=rr->next)
    {

        if (rr->name)
            (void) fprintf(fp, "%s\n", rr->name);
        else
            (void) fputc('\n', fp);
        
        if (rr->company)
            (void) fprintf(fp, "%s\n", rr->company);
        else
            (void) fputc('\n', fp);

        if (rr->address)
            (void) fprintf(fp, "%s\n", rr->address);
        else
            (void) fputc('\n', fp);

        if (rr->address2)
            (void) fprintf(fp, "%s\n", rr->address2);
        else
            (void) fputc('\n', fp);

        if (rr->number)
            (void) fprintf(fp, "%s\n", rr->number);
        else
            (void) fputc('\n', fp);

        if (rr->number2)
            (void) fprintf(fp, "%s\n", rr->number2);
        else
            (void) fputc('\n', fp);

        if (rr->number3)
            (void) fprintf(fp, "%s\n", rr->number3);
        else
            (void) fputc('\n', fp);

        if (rr->email)
            (void) fprintf(fp,"%s\n",rr->email);
        else
            (void) fputc('\n', fp);


        if (rr->text)
            (void) fprintf(fp, "%s", rr->text);

        /*
        ** check if there's a new line. we need to do this, because
        ** if the next has new line at the end, it will grow if we
        ** do not check and add another new line
        */

        for (s=rr->text; *s != '\0'; s++);
        s--;

        if (*s != '\n')
            fputc ('\n', fp);

        fputc((char)12, fp);
            fputc ('\n', fp);
            fputc ('\n', fp);
    }

    (void) fclose((FILE *) fp);

    if (filename == (char *) NULL)
    {
        Warning("No rolodex file exists for writing!",(char *)NULL);
        WriteStatus(1,rolomessageTextW,"No rolodex file for writing!");
        return;
    }

    if (GwroteToTempfile == True)
        GrolodexModified = True;
    else
        GrolodexModified = False;

    rc = MyCopy(tmpfile, filename);

    if (rc)
    {
#ifdef DEBUG
        (void) fprintf (stderr, "Return code from MyCopy: %d\n", rc);
#endif
        Warning("Unable to Write Change to Card file..", filename);
        (void) sprintf (message, 
            "Unabe to Save Cards to file: %s", filename);
        WriteStatus(1,rolomessageTextW, message);
        GwroteToTempfile = True;
        GrolodexModified = True;
        return;
    }
    else
    {
#ifdef DEBUG2
        (void) fprintf (stderr, "Copying succeeded!\n");
#endif
        if (unlink(tmpfile) < 0)
            Warning("Failed to remove Temporary file:", tmpfile);

        if (strcmp(filename, rolofile) != 0)
        {
            (void) sprintf (message, 
                "Card Database saved to file: %s\n", filename);
            WriteStatus(0,rolomessageTextW,
                message);
        }
    }
}
