#ifndef __ASM_H
#define __ASM_H

#define MAX_LABEL 128
#define MAX_TEXT 1024


extern int WARNINGS;
extern int pruchod; /* 1=assembling without labels, 2=adding label addresses */
extern unsigned short address;  /* address of the code */
extern unsigned short end;  /* highest address used */
extern int line;   /* number of line with an error */
extern int disable_defx;   /* 1=defb, defw, ... are forbidden; 0=defb, defw, ... can be used */
extern unsigned char* memory_ptr;   /* pointer to Z80 memory */

extern int compile(void);
extern void error(int line_number,char * line_string_from_input,char *error_message);
extern void asm_init(void); /* this must be run before all */
extern void asm_close(void); /* this must be run after all */
extern void take_line(char *line);  /* you must define function reading lines from input */

#endif
